/*
 * Decompiled with CFR 0.152.
 */
package com.embeddedunveiled.serial.vendor;

import com.embeddedunveiled.serial.SerialComException;
import com.embeddedunveiled.serial.SerialComLoadException;
import com.embeddedunveiled.serial.SerialComUnexpectedException;
import com.embeddedunveiled.serial.internal.SerialComSLabsUSBXpressJNIBridge;
import com.embeddedunveiled.serial.internal.SerialComSystemProperty;
import com.embeddedunveiled.serial.vendor.SerialComVendorLib;
import java.io.File;
import java.io.FileNotFoundException;

public final class SerialComSLabsUSBXpress
extends SerialComVendorLib {
    private final SerialComSLabsUSBXpressJNIBridge mSerialComSLabsUSBXpressJNIBridge = new SerialComSLabsUSBXpressJNIBridge();
    public static final int SI_RETURN_SERIAL_NUMBER = 0;
    public static final int SI_RETURN_DESCRIPTION = 1;
    public static final int SI_RETURN_LINK_NAME = 2;
    public static final int SI_RETURN_VID = 3;
    public static final int SI_RETURN_PID = 4;
    public static final int SI_RX_NO_OVERRUN = 1;
    public static final int SI_RX_EMPTY = 2;
    public static final int SI_RX_OVERRUN = 3;
    public static final int SI_RX_READY = 4;
    public static final int SI_HELD_INACTIVE = 1;
    public static final int SI_HELD_ACTIVE = 2;
    public static final int SI_FIRMWARE_CONTROLLED = 3;
    public static final int SI_RECEIVE_FLOW_CONTROL = 4;
    public static final int SI_TRANSMIT_ACTIVE_SIGNAL = 5;
    public static final int SI_STATUS_INPUT = 6;
    public static final int SI_HANDSHAKE_LINE = 7;

    public SerialComSLabsUSBXpress(File libDirectory, String vlibName, int cpuArch, int osType, SerialComSystemProperty serialComSystemProperty) throws UnsatisfiedLinkError, SerialComLoadException, SerialComUnexpectedException, SecurityException, FileNotFoundException {
        SerialComSLabsUSBXpressJNIBridge.loadNativeLibrary(libDirectory, vlibName, cpuArch, osType, serialComSystemProperty);
    }

    public int getNumDevices() throws SerialComException {
        int ret = this.mSerialComSLabsUSBXpressJNIBridge.getNumDevices();
        if (ret < 0) {
            throw new SerialComException("Could not get the number of devices connected to host. Please retry !");
        }
        return ret;
    }

    public String getProductString(int index, int flag) throws SerialComException {
        String ret = null;
        if (flag == 0 || flag == 1 || flag == 2 || flag == 3 || flag == 4) {
            ret = this.mSerialComSLabsUSBXpressJNIBridge.getProductString(index, flag);
            if (ret == null) {
                throw new SerialComException("Could not get the requested information. Please retry !");
            }
            return ret;
        }
        throw new IllegalArgumentException("Invalid flag passed for requested operation !");
    }

    public long open(int index) throws SerialComException {
        if (index < 0) {
            throw new IllegalArgumentException("Argument index can not be negative !");
        }
        long handle = this.mSerialComSLabsUSBXpressJNIBridge.open(index);
        if (handle < 0L) {
            throw new SerialComException("Could not open the requested device at given index. Please retry !");
        }
        return handle;
    }

    public boolean close(long handle) throws SerialComException {
        int ret = this.mSerialComSLabsUSBXpressJNIBridge.close(handle);
        if (ret < 0) {
            throw new SerialComException("Could not close the requested device. Please retry !");
        }
        return true;
    }

    public int read(long handle, byte[] buffer, int numOfBytesToRead) throws SerialComException {
        if (buffer == null) {
            throw new IllegalArgumentException("Argument buffer can not be null !");
        }
        if (numOfBytesToRead <= 0) {
            throw new IllegalArgumentException("Argument numOfBytesToRead can not be negative or zero !");
        }
        int ret = this.mSerialComSLabsUSBXpressJNIBridge.read(handle, buffer, numOfBytesToRead);
        if (ret < 0) {
            throw new SerialComException("Could not read the data from the requested device. Please retry !");
        }
        return ret;
    }

    public int write(long handle, byte[] buffer, int numOfBytesToWrite) throws SerialComException {
        if (buffer == null) {
            throw new IllegalArgumentException("Argument buffer can not be null !");
        }
        if (numOfBytesToWrite <= 0) {
            throw new IllegalArgumentException("Argument numOfBytesToWrite can not be negative or zero !");
        }
        int ret = this.mSerialComSLabsUSBXpressJNIBridge.write(handle, buffer, numOfBytesToWrite);
        if (ret < 0) {
            throw new SerialComException("Could not send data to the requested device. Please retry !");
        }
        return ret;
    }

    public boolean cancelIO(long handle) throws SerialComException {
        int ret = this.mSerialComSLabsUSBXpressJNIBridge.cancelIO(handle);
        if (ret < 0) {
            throw new SerialComException("Could not cancel the IO operations in progress. Please retry !");
        }
        return true;
    }

    public boolean flushBuffer(long handle, byte flushTransmit, byte flushReceive) throws SerialComException {
        int ret = this.mSerialComSLabsUSBXpressJNIBridge.flushBuffer(handle, flushTransmit, flushReceive);
        if (ret < 0) {
            throw new SerialComException("Could not flush the buffers as requested. Please retry !");
        }
        return true;
    }

    public boolean setTimeouts(long readTimeOut, long writeTimeOut) throws SerialComException {
        if (readTimeOut < 0L) {
            throw new IllegalArgumentException("Argument readTimeOut can not be negative !");
        }
        if (writeTimeOut < 0L) {
            throw new IllegalArgumentException("Argument writeTimeOut can not be negative !");
        }
        int ret = this.mSerialComSLabsUSBXpressJNIBridge.setTimeouts(readTimeOut, writeTimeOut);
        if (ret < 0) {
            throw new SerialComException("Could not set the desired timeout values for the requested device. Please retry !");
        }
        return true;
    }

    public long[] getTimeouts(long handle, long readTimeOut, long writeTimeOut) throws SerialComException {
        long[] ret = this.mSerialComSLabsUSBXpressJNIBridge.getTimeouts();
        if (ret == null) {
            throw new SerialComException("Could not get the timeout values for the requested device. Please retry !");
        }
        return ret;
    }

    public long[] checkRXQueue(long handle) throws SerialComException {
        long[] ret = this.mSerialComSLabsUSBXpressJNIBridge.checkRXQueue(handle);
        if (ret == null) {
            throw new SerialComException("Could not get the requested values for the given device. Please retry !");
        }
        return ret;
    }

    public boolean setBaudRate(long handle, int baudrate) throws SerialComException {
        int ret = this.mSerialComSLabsUSBXpressJNIBridge.setBaudRate(handle, baudrate);
        if (ret < 0) {
            throw new SerialComException("Could not set the baud rate. Please retry !");
        }
        return true;
    }

    public boolean setBaudDivisor(long handle, int divisor) throws SerialComException {
        int ret = this.mSerialComSLabsUSBXpressJNIBridge.setBaudRate(handle, divisor);
        if (ret < 0) {
            throw new SerialComException("Could not set the given divisor. Please retry !");
        }
        return true;
    }

    public boolean setLineControl(long handle, int lineControl) throws SerialComException {
        int ret = this.mSerialComSLabsUSBXpressJNIBridge.setLineControl(handle, lineControl);
        if (ret < 0) {
            throw new SerialComException("Could not set the line control settings. Please retry !");
        }
        return true;
    }

    public boolean setFlowControl(long handle, int ctsMaskCode, int rtsMaskCode, int dtrMaskCode, int dsrMaskCode, int dcdMaskCode, int flowXonXoff) throws SerialComException {
        int ret = this.mSerialComSLabsUSBXpressJNIBridge.setFlowControl(handle, ctsMaskCode, rtsMaskCode, dtrMaskCode, dsrMaskCode, dcdMaskCode, flowXonXoff);
        if (ret < 0) {
            throw new SerialComException("Could not set the flow control settings. Please retry !");
        }
        return true;
    }

    public byte getModemStatus(long handle) throws SerialComException {
        int ret = this.mSerialComSLabsUSBXpressJNIBridge.getModemStatus(handle);
        if (ret < 0) {
            throw new SerialComException("Could not get modem status. Please retry !");
        }
        return (byte)ret;
    }

    public boolean setBreak(long handle, int breakValue) throws SerialComException {
        int ret = this.mSerialComSLabsUSBXpressJNIBridge.setBreak(handle, breakValue);
        if (ret < 0) {
            throw new SerialComException("Could not set the break condition as given. Please retry !");
        }
        return true;
    }

    public long readLatch(long handle) throws SerialComException {
        long ret = this.mSerialComSLabsUSBXpressJNIBridge.readLatch(handle);
        if (ret < 0L) {
            throw new SerialComException("Could not read the port latch value for given device. Please retry !");
        }
        return ret;
    }

    public boolean writeLatch(long handle, long mask, long latchValue) throws SerialComException {
        int ret = this.mSerialComSLabsUSBXpressJNIBridge.writeLatch(handle, mask, latchValue);
        if (ret < 0) {
            throw new SerialComException("Could not write the given latch value on the given device. Please retry !");
        }
        return true;
    }

    public String getPartNumber(long handle) throws SerialComException {
        String ret = this.mSerialComSLabsUSBXpressJNIBridge.getPartNumber(handle);
        if (ret == null) {
            throw new SerialComException("Could not get the part number. Please retry !");
        }
        return ret;
    }

    public int deviceIOControl(long handle, int ctrlCode, byte[] inputBuf, int numBytesToRead, byte[] outputBuf, int numOfBytesToWrite) throws SerialComException {
        int ret = this.mSerialComSLabsUSBXpressJNIBridge.deviceIOControl(handle, ctrlCode, inputBuf, numBytesToRead, outputBuf, numOfBytesToWrite);
        if (ret < 0) {
            throw new SerialComException("Could not perform the IO control operation. Please retry !");
        }
        return ret;
    }

    public long getDllVersion() throws SerialComException {
        long ret = this.mSerialComSLabsUSBXpressJNIBridge.getDllVersion();
        if (ret < 0L) {
            throw new SerialComException("Could not get the dll version for the requested device. Please retry !");
        }
        return ret;
    }

    public long getDriverVersion() throws SerialComException {
        long ret = this.mSerialComSLabsUSBXpressJNIBridge.getDriverVersion();
        if (ret < 0L) {
            throw new SerialComException("Could not get the driver version for the requested device. Please retry !");
        }
        return ret;
    }
}

