/*
 * Decompiled with CFR 0.152.
 */
package com.embeddedunveiled.serial.vendor;

import com.embeddedunveiled.serial.SerialComLoadException;
import com.embeddedunveiled.serial.SerialComUnexpectedException;
import com.embeddedunveiled.serial.internal.SerialComSystemProperty;
import com.embeddedunveiled.serial.vendor.SerialComFTDID2XX;
import com.embeddedunveiled.serial.vendor.SerialComMCHPSimpleIO;
import com.embeddedunveiled.serial.vendor.SerialComSLabsCP210xManufacturing;
import com.embeddedunveiled.serial.vendor.SerialComSLabsCP210xRuntime;
import java.io.File;
import java.io.FileNotFoundException;

public class SerialComVendorLib {
    public static final int VLIB_FTDI_D2XX = 1;
    public static final int VLIB_MCHP_SIMPLEIO = 2;
    public static final int VLIB_SLABS_CP210XRUNTIME = 3;
    public static final int VLIB_SLABS_CP210XMANUFACTURING = 4;
    public static final int VLIB_SLABS_USBXPRESS = 5;

    public SerialComVendorLib getVendorLibInstance(int vendorLibIdentifier, File libDirectory, String vlibName, int cpuArch, int osType, SerialComSystemProperty serialComSystemProperty) throws UnsatisfiedLinkError, SerialComLoadException, SerialComUnexpectedException, SecurityException, FileNotFoundException {
        SerialComVendorLib vendorLib = null;
        switch (vendorLibIdentifier) {
            case 1: {
                if (cpuArch != 2 && cpuArch != 1) {
                    throw new SerialComLoadException("FTDI D2XX library is not supported for this CPU architecture !");
                }
                if (osType != 2 && osType != 1 && osType != 4) {
                    throw new SerialComLoadException("FTDI D2XX library is not supported for this operating system !");
                }
                vendorLib = new SerialComFTDID2XX(libDirectory, vlibName, cpuArch, osType, serialComSystemProperty);
                break;
            }
            case 2: {
                if (cpuArch != 2 && cpuArch != 1) {
                    throw new SerialComLoadException("Microchip SimpleIO library is not supported for this CPU architecture !");
                }
                if (osType != 2) {
                    throw new SerialComLoadException("Microchip SimpleIO library is not supported for this operating system !");
                }
                vendorLib = new SerialComMCHPSimpleIO(libDirectory, vlibName, cpuArch, osType, serialComSystemProperty);
                break;
            }
            case 3: {
                if (cpuArch != 2 && cpuArch != 1) {
                    throw new SerialComLoadException("Silicon labs cp210x runtime dll library is not supported for this CPU architecture !");
                }
                if (osType != 2) {
                    throw new SerialComLoadException("Silicon labs cp210x runtime dll library is not supported for this operating system !");
                }
                vendorLib = new SerialComSLabsCP210xRuntime(libDirectory, vlibName, cpuArch, osType, serialComSystemProperty);
                break;
            }
            case 4: {
                if (cpuArch != 2 && cpuArch != 1) {
                    throw new SerialComLoadException("Silicon labs cp210x manufacturing dll library is not supported for this CPU architecture !");
                }
                if (osType != 2 && osType != 1) {
                    throw new SerialComLoadException("Silicon labs cp210x manufacturing dll library is not supported for this operating system !");
                }
                vendorLib = new SerialComSLabsCP210xManufacturing(libDirectory, vlibName, cpuArch, osType, serialComSystemProperty);
                break;
            }
            case 5: {
                if (cpuArch != 2 && cpuArch != 1) {
                    throw new SerialComLoadException("Silicon labs usbxpress library is not supported for this CPU architecture !");
                }
                if (osType != 2) {
                    throw new SerialComLoadException("Silicon labs usbxpress library is not supported for this operating system !");
                }
                vendorLib = new SerialComSLabsCP210xManufacturing(libDirectory, vlibName, cpuArch, osType, serialComSystemProperty);
                break;
            }
            default: {
                throw new IllegalArgumentException("Given argument vendorLibIdentifier is invalid !");
            }
        }
        return vendorLib;
    }
}

