/*
 * Decompiled with CFR 0.152.
 */
package com.ftdi;

import com.ftdi.BitModes;
import com.ftdi.DeviceStatus;
import com.ftdi.DeviceType;
import com.ftdi.EEPROMData;
import com.ftdi.FTD2XX;
import com.ftdi.FTD2XXException;
import com.ftdi.FTDeviceInputStream;
import com.ftdi.FTDeviceOutputStream;
import com.ftdi.FT_STATUS;
import com.ftdi.FlowControl;
import com.ftdi.Parity;
import com.ftdi.Purge;
import com.ftdi.StopBits;
import com.ftdi.WordLength;
import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.ByteByReference;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FTDevice {
    private static final FTD2XX ftd2xx = FTD2XX.INSTANCE;
    private final int devID;
    private final int devLocationID;
    private final int flag;
    private final DeviceType devType;
    private Pointer ftHandle;
    private final String devSerialNumber;
    private final String devDescription;
    private FTDeviceInputStream fTDeviceInputStream = null;
    private FTDeviceOutputStream fTDeviceOutputStream = null;
    private boolean open = false;

    private FTDevice(DeviceType devType, int devID, int devLocationID, String devSerialNumber, String devDescription, Pointer ftHandle, int flag) {
        this.devType = devType;
        this.devID = devID;
        this.devLocationID = devLocationID;
        this.devSerialNumber = devSerialNumber;
        this.devDescription = devDescription;
        this.ftHandle = ftHandle;
        this.flag = flag;
        this.open = false;
    }

    public String getDevDescription() {
        return this.devDescription;
    }

    public int getDevID() {
        return this.devID;
    }

    public String getDevSerialNumber() {
        return this.devSerialNumber;
    }

    public DeviceType getDevType() {
        return this.devType;
    }

    public int getDevLocationID() {
        return this.devLocationID;
    }

    public int getFlag() {
        return this.flag;
    }

    public boolean isInUse() {
        return (this.flag & 1) != 0;
    }

    public boolean isOpen() {
        return this.open;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof FTDevice)) {
            return false;
        }
        FTDevice eq = (FTDevice)obj;
        return eq.ftHandle == this.ftHandle;
    }

    public int hashCode() {
        int hash = 5;
        hash = 97 * hash + this.ftHandle.hashCode();
        return hash;
    }

    public String toString() {
        return "FTDevice{devDescription=" + this.devDescription + ", devSerialNumber=" + this.devSerialNumber + '}';
    }

    private static void ensureFTStatus(int ftstatus) throws FTD2XXException {
        if (ftstatus != FT_STATUS.OK.constant()) {
            throw new FTD2XXException(ftstatus);
        }
    }

    private static FTDevice getXthDevice(int Xth) throws FTD2XXException {
        IntByReference flag = new IntByReference();
        IntByReference devType = new IntByReference();
        IntByReference devID = new IntByReference();
        IntByReference locID = new IntByReference();
        PointerByReference ftHandle = new PointerByReference();
        Memory devSerNum = new Memory(16L);
        Memory devDesc = new Memory(64L);
        FTDevice.ensureFTStatus(ftd2xx.FT_GetDeviceInfoDetail(Xth, flag, devType, devID, locID, (Pointer)devSerNum, (Pointer)devDesc, ftHandle));
        return new FTDevice(DeviceType.values()[devType.getValue()], devID.getValue(), locID.getValue(), devSerNum.getString(0L), devDesc.getString(0L), ftHandle.getValue(), flag.getValue());
    }

    public static List<FTDevice> getDevices() throws FTD2XXException {
        return FTDevice.getDevices(false);
    }

    public static List<FTDevice> getDevices(boolean isIncludeOpenedDevices) throws FTD2XXException {
        IntByReference devNum = new IntByReference();
        FTDevice.ensureFTStatus(ftd2xx.FT_CreateDeviceInfoList(devNum));
        ArrayList<FTDevice> devs = new ArrayList<FTDevice>(devNum.getValue());
        for (int i = 0; i < devNum.getValue(); ++i) {
            FTDevice device = FTDevice.getXthDevice(i);
            if (isIncludeOpenedDevices) {
                devs.add(device);
                continue;
            }
            if ((device.flag & 1) != 0) continue;
            devs.add(device);
        }
        Logger.getLogger(FTDevice.class.getName()).log(Level.INFO, "Found devs: {0} (All:{1})", new Object[]{devs.size(), devNum.getValue()});
        return devs;
    }

    public static List<FTDevice> getDevicesByDescription(String description) throws FTD2XXException {
        IntByReference devNum = new IntByReference();
        FTDevice.ensureFTStatus(ftd2xx.FT_CreateDeviceInfoList(devNum));
        ArrayList<FTDevice> devs = new ArrayList<FTDevice>(devNum.getValue());
        for (int i = 0; i < devNum.getValue(); ++i) {
            FTDevice device = FTDevice.getXthDevice(i);
            if ((device.flag & 1) != 0 || !description.equals(device.devDescription)) continue;
            devs.add(device);
        }
        Logger.getLogger(FTDevice.class.getName()).log(Level.INFO, "Found devs: {0} (All:{1})", new Object[]{devs.size(), devNum.getValue()});
        return devs;
    }

    public static List<FTDevice> getDevicesBySerialNumber(String serialNumber) throws FTD2XXException {
        IntByReference devNum = new IntByReference();
        FTDevice.ensureFTStatus(ftd2xx.FT_CreateDeviceInfoList(devNum));
        ArrayList<FTDevice> devs = new ArrayList<FTDevice>(devNum.getValue());
        for (int i = 0; i < devNum.getValue(); ++i) {
            FTDevice device = FTDevice.getXthDevice(i);
            if ((device.getFlag() & 1) != 0 || !serialNumber.equals(device.devSerialNumber)) continue;
            devs.add(device);
        }
        Logger.getLogger(FTDevice.class.getName()).log(Level.INFO, "Found devs: {0} (All:{1})", new Object[]{devs.size(), devNum.getValue()});
        return devs;
    }

    public static List<FTDevice> getDevicesByDeviceType(DeviceType deviceType) throws FTD2XXException {
        IntByReference devNum = new IntByReference();
        FTDevice.ensureFTStatus(ftd2xx.FT_CreateDeviceInfoList(devNum));
        ArrayList<FTDevice> devs = new ArrayList<FTDevice>(devNum.getValue());
        for (int i = 0; i < devNum.getValue(); ++i) {
            FTDevice device = FTDevice.getXthDevice(i);
            if ((device.flag & 1) != 0 || !device.devType.equals((Object)deviceType)) continue;
            devs.add(device);
        }
        Logger.getLogger(FTDevice.class.getName()).log(Level.INFO, "Found devs: {0} (All:{1})", new Object[]{devs.size(), devNum.getValue()});
        return devs;
    }

    public void open() throws FTD2XXException {
        Memory memory = new Memory(16L);
        memory.setString(0L, this.devSerialNumber);
        PointerByReference handle = new PointerByReference();
        FTDevice.ensureFTStatus(ftd2xx.FT_OpenEx((Pointer)memory, 1, handle));
        this.ftHandle = handle.getValue();
        this.open = true;
    }

    public void close() throws FTD2XXException {
        if (!this.open) {
            return;
        }
        this.open = false;
        FTDevice.ensureFTStatus(ftd2xx.FT_Close(this.ftHandle));
    }

    public void cyclePort() throws FTD2XXException {
        FTDevice.ensureFTStatus(ftd2xx.FT_CyclePort(this.ftHandle));
    }

    public void setBaudRate(long baudRate) throws FTD2XXException {
        FTDevice.ensureFTStatus(ftd2xx.FT_SetBaudRate(this.ftHandle, (int)baudRate));
    }

    public void setDataCharacteristics(WordLength wordLength, StopBits stopBits, Parity parity) throws FTD2XXException {
        FTDevice.ensureFTStatus(ftd2xx.FT_SetDataCharacteristics(this.ftHandle, (byte)wordLength.constant(), (byte)stopBits.constant(), (byte)parity.constant()));
    }

    public void setTimeouts(long readTimeout, long writeTimeout) throws FTD2XXException {
        FTDevice.ensureFTStatus(ftd2xx.FT_SetTimeouts(this.ftHandle, (int)readTimeout, (int)writeTimeout));
    }

    public void setFlowControl(FlowControl flowControl) throws FTD2XXException {
        FTDevice.ensureFTStatus(ftd2xx.FT_SetFlowControl(this.ftHandle, (short)flowControl.constant(), (byte)0, (byte)0));
    }

    public void setFlowControl(FlowControl flowControl, byte uXon, byte uXoff) throws FTD2XXException {
        FTDevice.ensureFTStatus(ftd2xx.FT_SetFlowControl(this.ftHandle, (short)flowControl.constant(), uXon, uXoff));
    }

    public void setDtr(boolean status) throws FTD2XXException {
        if (status) {
            FTDevice.ensureFTStatus(ftd2xx.FT_SetDtr(this.ftHandle));
        } else {
            FTDevice.ensureFTStatus(ftd2xx.FT_ClrDtr(this.ftHandle));
        }
    }

    public void setRts(boolean status) throws FTD2XXException {
        if (status) {
            FTDevice.ensureFTStatus(ftd2xx.FT_SetRts(this.ftHandle));
        } else {
            FTDevice.ensureFTStatus(ftd2xx.FT_ClrRts(this.ftHandle));
        }
    }

    public EnumSet<DeviceStatus> getDeviceStatus() throws FTD2XXException {
        IntByReference modstat = new IntByReference();
        FTDevice.ensureFTStatus(ftd2xx.FT_GetModemStatus(this.ftHandle, modstat));
        return DeviceStatus.parseToEnumset(modstat.getValue());
    }

    public int getQueueStatus() throws FTD2XXException {
        IntByReference reference = new IntByReference();
        FTDevice.ensureFTStatus(ftd2xx.FT_GetQueueStatus(this.ftHandle, reference));
        return reference.getValue();
    }

    public void purgeBuffer(boolean rxBuffer, boolean txBuffer) throws FTD2XXException {
        int mask = 0;
        if (rxBuffer) {
            mask |= Purge.PURGE_RX.constant();
        }
        if (txBuffer) {
            mask |= Purge.PURGE_TX.constant();
        }
        FTDevice.ensureFTStatus(ftd2xx.FT_Purge(this.ftHandle, mask));
    }

    public void resetDevice() throws FTD2XXException {
        FTDevice.ensureFTStatus(ftd2xx.FT_ResetDevice(this.ftHandle));
    }

    public void setLatencyTimer(short timer) throws FTD2XXException, IllegalArgumentException {
        if (timer < 2 || timer > 255) {
            throw new IllegalArgumentException("Valid range is 2 - 255!");
        }
        FTDevice.ensureFTStatus(ftd2xx.FT_SetLatencyTimer(this.ftHandle, (byte)timer));
    }

    public short getLatencyTimer() throws FTD2XXException {
        ByteByReference byReference = new ByteByReference();
        FTDevice.ensureFTStatus(ftd2xx.FT_GetLatencyTimer(this.ftHandle, byReference));
        return (short)((short)byReference.getValue() & 0xFF);
    }

    public void setBitMode(byte ucMask, BitModes bitMode) throws FTD2XXException {
        FTDevice.ensureFTStatus(ftd2xx.FT_SetBitMode(this.ftHandle, ucMask, (byte)bitMode.constant()));
    }

    public BitModes getBitMode() throws FTD2XXException {
        ByteByReference byt = new ByteByReference();
        FTDevice.ensureFTStatus(ftd2xx.FT_GetBitmode(this.ftHandle, byt));
        return BitModes.parse(byt.getValue());
    }

    public void setUSBParameters(int inTransferSize, int outTransferSize) throws FTD2XXException {
        FTDevice.ensureFTStatus(ftd2xx.FT_SetUSBParameters(this.ftHandle, inTransferSize, outTransferSize));
    }

    public void writeEEPROM(EEPROMData programData) throws FTD2XXException {
        FTDevice.ensureFTStatus(ftd2xx.FT_EE_Program(this.ftHandle, programData.ft_program_data));
    }

    public EEPROMData readEEPROM() throws FTD2XXException {
        FTD2XX.FT_PROGRAM_DATA.ByReference ftByReference = new FTD2XX.FT_PROGRAM_DATA.ByReference();
        FTDevice.ensureFTStatus(ftd2xx.FT_EE_Read(this.ftHandle, ftByReference));
        return new EEPROMData(ftByReference);
    }

    public int getEEPROMUserAreaSize() throws FTD2XXException {
        IntByReference size = new IntByReference();
        FTDevice.ensureFTStatus(ftd2xx.FT_EE_UASize(this.ftHandle, size));
        return size.getValue();
    }

    public byte[] readEEPROMUserArea(int numberOfBytes) throws FTD2XXException {
        IntByReference actually = new IntByReference();
        Memory dest = new Memory((long)numberOfBytes);
        FTDevice.ensureFTStatus(ftd2xx.FT_EE_UARead(this.ftHandle, (Pointer)dest, numberOfBytes, actually));
        return dest.getByteArray(0L, actually.getValue());
    }

    public byte[] readFullEEPROMUserArea() throws FTD2XXException {
        int numberOfBytes = this.getEEPROMUserAreaSize();
        return this.readEEPROMUserArea(numberOfBytes);
    }

    public String readFullEEPROMUserAreaAsString() throws IOException {
        IntByReference actually = new IntByReference();
        int numberOfBytes = this.getEEPROMUserAreaSize();
        Memory dest = new Memory((long)numberOfBytes);
        FTDevice.ensureFTStatus(ftd2xx.FT_EE_UARead(this.ftHandle, (Pointer)dest, numberOfBytes, actually));
        return dest.getString(0L);
    }

    public void writeEEPROMUserArea(byte[] data) throws FTD2XXException {
        Memory source = new Memory((long)data.length);
        source.write(0L, data, 0, data.length);
        FTDevice.ensureFTStatus(ftd2xx.FT_EE_UAWrite(this.ftHandle, (Pointer)source, data.length));
    }

    public void writeEEPROMUserArea(String data) throws FTD2XXException {
        Memory source = new Memory((long)data.length());
        source.setString(0L, data);
        FTDevice.ensureFTStatus(ftd2xx.FT_EE_UAWrite(this.ftHandle, (Pointer)source, data.length()));
    }

    public int write(byte[] bytes, int offset, int length) throws FTD2XXException {
        Memory memory = new Memory((long)length);
        memory.write(0L, bytes, offset, length);
        IntByReference wrote = new IntByReference();
        FTDevice.ensureFTStatus(ftd2xx.FT_Write(this.ftHandle, (Pointer)memory, length, wrote));
        return wrote.getValue();
    }

    public int write(byte[] bytes) throws FTD2XXException {
        return this.write(bytes, 0, bytes.length);
    }

    public boolean write(int b) throws FTD2XXException {
        byte[] c = new byte[]{(byte)b};
        return this.write(c) == 1;
    }

    public int read(byte[] bytes, int offset, int lenght) throws FTD2XXException {
        Memory memory = new Memory((long)lenght);
        IntByReference read = new IntByReference();
        FTDevice.ensureFTStatus(ftd2xx.FT_Read(this.ftHandle, (Pointer)memory, lenght, read));
        memory.read(0L, bytes, offset, lenght);
        return read.getValue();
    }

    public int read(byte[] bytes) throws FTD2XXException {
        return this.read(bytes, 0, bytes.length);
    }

    public int read() throws FTD2XXException {
        byte[] c = new byte[1];
        int ret = this.read(c);
        return ret == 1 ? c[0] & 0xFF : -1;
    }

    public byte[] read(int number) throws FTD2XXException {
        byte[] ret = new byte[number];
        int actually = this.read(ret);
        if (actually != number) {
            byte[] shrink = new byte[actually];
            System.arraycopy(ret, 0, shrink, 0, actually);
            return shrink;
        }
        return ret;
    }

    public InputStream getInputStream() {
        if (this.fTDeviceInputStream == null) {
            this.fTDeviceInputStream = new FTDeviceInputStream(this);
        }
        return this.fTDeviceInputStream;
    }

    public OutputStream getOutputStream() {
        if (this.fTDeviceOutputStream == null) {
            this.fTDeviceOutputStream = new FTDeviceOutputStream(this);
        }
        return this.fTDeviceOutputStream;
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        catch (FTD2XXException fTD2XXException) {
            // empty catch block
        }
        super.finalize();
    }
}

