/*
 * Decompiled with CFR 0.152.
 */
package com.ftdi;

import java.util.ArrayList;
import java.util.EnumSet;

public enum DeviceStatus {
    CTS(16, "Clear To Send"),
    DSR(32, "Data Set Ready"),
    RI(64, "Ring Indicator"),
    DCD(128, "Data Carrier Detect"),
    OE(2, "Overrun Error"),
    PE(4, "Parity Error"),
    FE(8, "Framing Error"),
    BI(16, "Break Interrupt");

    private final int constant;
    private final String description;

    private DeviceStatus(int constant, String description) {
        this.constant = constant;
        this.description = description;
    }

    int constant() {
        return this.constant;
    }

    static EnumSet<DeviceStatus> parseToEnumset(int val) {
        ArrayList<DeviceStatus> enu = new ArrayList<DeviceStatus>();
        for (DeviceStatus curr : DeviceStatus.values()) {
            if ((curr.constant() & val) == 0) continue;
            enu.add(curr);
        }
        return EnumSet.copyOf(enu);
    }

    public String toString() {
        return super.toString() + " (" + this.description + ")";
    }
}

