package com.sun.jna.platform.unix;

import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.ptr.PointerByReference;

public interface LibPThread extends Library {

    String NAME = "pthread";

    LibPThread INSTANCE = Native.load(NAME, LibPThread.class);

    @Structure.FieldOrder({ "eCondVar", "eMutex", "iVar" })
    public class EVENT_HANDLE {
        public pthread_cond_t eCondVar;

        public pthread_mutex_t eMutex;

        public int iVar;
    }

    @Structure.FieldOrder({ "queue" })
    public class pthread_mutex_t {
        list_node_t queue;
    }

    @Structure.FieldOrder({ "next" })
    public class list_node_t {
        Pointer /* list_node */ next;
    }

    @Structure.FieldOrder({ "queue" })
    public class pthread_cond_t {
        priority_queue_t queue;
    }

    @Structure.FieldOrder({ "next", "priority", "data" })
    public class priority_queue_node_t {
        Pointer /* priority_queue_node */ next;

        int priority;

        int data;
    };

    @Structure.FieldOrder({ "first" })
    public class priority_queue_t {
        Pointer /* priority_queue_node_t */ first;
    }

    int pthread_mutex_init(PointerByReference mutex, Pointer attr);

    int pthread_mutex_destroy(PointerByReference mutex);

    int pthread_cond_init(PointerByReference cond, Pointer attr);

    int pthread_cond_destroy(PointerByReference cond);

}
