/*
 * Decompiled with CFR 0.152.
 */
package com.ftdi;

import com.sun.jna.Library;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.ptr.ByteByReference;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import com.sun.jna.ptr.ShortByReference;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.StringTokenizer;

interface FTD2XX
extends Library {
    public static final FTD2XX INSTANCE = (FTD2XX)Native.load((String)Loader.getNative(), FTD2XX.class);
    public static final int FT_FLAGS_OPENED = 1;
    public static final int FT_LIST_NUMBER_ONLY = 524288;
    public static final int FT_LIST_BY_INDEX = 0x40000000;
    public static final int FT_LIST_ALL = 0x20000000;
    public static final int FT_OPEN_BY_SERIAL_NUMBER = 1;
    public static final int FT_OPEN_BY_DESCRIPTION = 2;
    public static final int FT_OPEN_BY_LOCATION = 4;

    public int FT_SetVIDPID(int var1, int var2);

    public int FT_GetVIDPID(IntByReference var1, IntByReference var2);

    public int FT_CreateDeviceInfoList(IntByReference var1);

    public int FT_GetDeviceInfoList(FT_DEVICE_LIST_INFO_NODE[] var1, IntByReference var2);

    public int FT_GetDeviceInfoDetail(int var1, IntByReference var2, IntByReference var3, IntByReference var4, IntByReference var5, Pointer var6, Pointer var7, PointerByReference var8);

    public int FT_ListDevices(Pointer var1, Pointer var2, int var3);

    public int FT_Open(int var1, PointerByReference var2);

    public int FT_OpenEx(Pointer var1, int var2, PointerByReference var3);

    public int FT_Close(Pointer var1);

    public int FT_Read(Pointer var1, Pointer var2, int var3, IntByReference var4);

    public int FT_Write(Pointer var1, Pointer var2, int var3, IntByReference var4);

    public int FT_SetBaudRate(Pointer var1, int var2);

    public int FT_SetDivisor(Pointer var1, short var2);

    public int FT_SetDataCharacteristics(Pointer var1, byte var2, byte var3, byte var4);

    public int FT_SetTimeouts(Pointer var1, int var2, int var3);

    public int FT_SetFlowControl(Pointer var1, short var2, byte var3, byte var4);

    public int FT_SetDtr(Pointer var1);

    public int FT_ClrDtr(Pointer var1);

    public int FT_SetRts(Pointer var1);

    public int FT_ClrRts(Pointer var1);

    public int FT_GetModemStatus(Pointer var1, IntByReference var2);

    public int FT_GetQueueStatus(Pointer var1, IntByReference var2);

    public int FT_GetDeviceInfo(Pointer var1, IntByReference var2, IntByReference var3, Pointer var4, Pointer var5, Pointer var6);

    public int FT_GetDriverVersion(Pointer var1, IntByReference var2);

    public int FT_GetLibraryVersion(IntByReference var1);

    public int FT_GetComPortNumber(Pointer var1, IntByReference var2);

    public int FT_GetStatus(Pointer var1, IntByReference var2, IntByReference var3, IntByReference var4);

    public int FT_SetEventNotification(Pointer var1, int var2, Pointer var3);

    public int FT_SetChars(Pointer var1, byte var2, byte var3, byte var4, byte var5);

    public int FT_SetBreakOn(Pointer var1);

    public int FT_SetBreakOff(Pointer var1);

    public int FT_Purge(Pointer var1, int var2);

    public int FT_ResetDevice(Pointer var1);

    public int FT_ResetPort(Pointer var1);

    public int FT_CyclePort(Pointer var1);

    public int FT_Rescan();

    public int FT_Reload(short var1, short var2);

    public int FT_SetResetPipeRetryCount(Pointer var1, int var2);

    public int FT_StopInTask(Pointer var1);

    public int FT_RestartInTask(Pointer var1);

    public int FT_SetDeadmanTimeout(Pointer var1, int var2);

    public int FT_ReadEE(Pointer var1, int var2, ShortByReference var3);

    public int FT_WriteEE(Pointer var1, int var2, short var3);

    public int FT_EraseEE(Pointer var1);

    public int FT_EE_Read(Pointer var1, FT_PROGRAM_DATA.ByReference var2);

    public int FT_EE_ReadEx(Pointer var1, FT_PROGRAM_DATA.ByReference var2, String var3, String var4, String var5, String var6);

    public int FT_EEPROM_Read(Pointer var1, Structure var2, int var3, Pointer var4, Pointer var5, Pointer var6, Pointer var7);

    public int FT_EEPROM_Program(Pointer var1, Structure var2, int var3, Pointer var4, Pointer var5, Pointer var6, Pointer var7);

    public int FT_EE_Program(Pointer var1, FT_PROGRAM_DATA.ByReference var2);

    public int FT_EE_ProgramEx(Pointer var1, FT_PROGRAM_DATA.ByReference var2, String var3, String var4, String var5, String var6);

    public int FT_EE_UASize(Pointer var1, IntByReference var2);

    public int FT_EE_UARead(Pointer var1, Pointer var2, int var3, IntByReference var4);

    public int FT_EE_UAWrite(Pointer var1, Pointer var2, int var3);

    public int FT_SetLatencyTimer(Pointer var1, byte var2);

    public int FT_GetLatencyTimer(Pointer var1, ByteByReference var2);

    public int FT_SetBitMode(Pointer var1, byte var2, byte var3);

    public int FT_GetBitMode(Pointer var1, ByteByReference var2);

    public int FT_SetUSBParameters(Pointer var1, int var2, int var3);

    @Structure.FieldOrder(value={"Signature1", "Signature2", "Version", "VendorId", "ProductId", "Manufacturer", "ManufacturerId", "Description", "SerialNumber", "MaxPower", "PnP", "SelfPowered", "RemoteWakeup", "Rev4", "IsoIn", "IsoOut", "PullDownEnable", "SerNumEnable", "USBVersionEnable", "USBVersion", "Rev5", "IsoInA", "IsoInB", "IsoOutA", "IsoOutB", "PullDownEnable5", "SerNumEnable5", "USBVersionEnable5", "USBVersion5", "AIsHighCurrent", "BIsHighCurrent", "IFAIsFifo", "IFAIsFifoTar", "IFAIsFastSer", "AIsVCP", "IFBIsFifo", "IFBIsFifoTar", "IFBIsFastSer", "BIsVCP", "UseExtOsc", "HighDriveIOs", "EndpointSize", "PullDownEnableR", "SerNumEnableR", "InvertTXD", "InvertRXD", "InvertRTS", "InvertCTS", "InvertDTR", "InvertDSR", "InvertDCD", "InvertRI", "Cbus0", "Cbus1", "Cbus2", "Cbus3", "Cbus4", "RIsD2XX", "PullDownEnable7", "SerNumEnable7", "ALSlowSlew", "ALSchmittInput", "ALDriveCurrent", "AHSlowSlew", "AHSchmittInput", "AHDriveCurrent", "BLSlowSlew", "BLSchmittInput", "BLDriveCurrent", "BHSlowSlew", "BHSchmittInput", "BHDriveCurrent", "IFAIsFifo7", "IFAIsFifoTar7", "IFAIsFastSer7", "AIsVCP7", "IFBIsFifo7", "IFBIsFifoTar7", "IFBIsFastSer7", "BIsVCP7", "PowerSaveEnable", "PullDownEnable8", "SerNumEnable8", "ASlowSlew", "ASchmittInput", "ADriveCurrent", "BSlowSlew", "BSchmittInput", "BDriveCurrent", "CSlowSlew", "CSchmittInput", "CDriveCurrent", "DSlowSlew", "DSchmittInput", "DDriveCurrent", "ARIIsTXDEN", "BRIIsTXDEN", "CRIIsTXDEN", "DRIIsTXDEN", "AIsVCP8", "BIsVCP8", "CIsVCP8", "DIsVCP8", "PullDownEnableH", "SerNumEnableH", "ACSlowSlewH", "ACSchmittInputH", "ACDriveCurrentH", "ADSlowSlewH", "ADSchmittInputH", "ADDriveCurrentH", "Cbus0H", "Cbus1H", "Cbus2H", "Cbus3H", "Cbus4H", "Cbus5H", "Cbus6H", "Cbus7H", "Cbus8H", "Cbus9H", "IsFifoH", "IsFifoTarH", "IsFastSerH", "IsFT1248H", "FT1248CpolH", "FT1248LsbH", "FT1248FlowControlH", "IsVCPH", "PowerSaveEnableH"})
    public static class FT_PROGRAM_DATA
    extends Structure {
        public int Signature1 = 0;
        public int Signature2 = -1;
        public int Version = 0;
        public short VendorId;
        public short ProductId;
        public Pointer Manufacturer = new Memory(32L);
        public Pointer ManufacturerId = new Memory(16L);
        public Pointer Description = new Memory(64L);
        public Pointer SerialNumber = new Memory(16L);
        public short MaxPower;
        public short PnP;
        public short SelfPowered;
        public short RemoteWakeup;
        public byte Rev4;
        public byte IsoIn;
        public byte IsoOut;
        public byte PullDownEnable;
        public byte SerNumEnable;
        public byte USBVersionEnable;
        public short USBVersion;
        public byte Rev5;
        public byte IsoInA;
        public byte IsoInB;
        public byte IsoOutA;
        public byte IsoOutB;
        public byte PullDownEnable5;
        public byte SerNumEnable5;
        public byte USBVersionEnable5;
        public short USBVersion5;
        public byte AIsHighCurrent;
        public byte BIsHighCurrent;
        public byte IFAIsFifo;
        public byte IFAIsFifoTar;
        public byte IFAIsFastSer;
        public byte AIsVCP;
        public byte IFBIsFifo;
        public byte IFBIsFifoTar;
        public byte IFBIsFastSer;
        public byte BIsVCP;
        public byte UseExtOsc;
        public byte HighDriveIOs;
        public byte EndpointSize;
        public byte PullDownEnableR;
        public byte SerNumEnableR;
        public byte InvertTXD;
        public byte InvertRXD;
        public byte InvertRTS;
        public byte InvertCTS;
        public byte InvertDTR;
        public byte InvertDSR;
        public byte InvertDCD;
        public byte InvertRI;
        public byte Cbus0;
        public byte Cbus1;
        public byte Cbus2;
        public byte Cbus3;
        public byte Cbus4;
        public byte RIsD2XX;
        public byte PullDownEnable7;
        public byte SerNumEnable7;
        public byte ALSlowSlew;
        public byte ALSchmittInput;
        public byte ALDriveCurrent;
        public byte AHSlowSlew;
        public byte AHSchmittInput;
        public byte AHDriveCurrent;
        public byte BLSlowSlew;
        public byte BLSchmittInput;
        public byte BLDriveCurrent;
        public byte BHSlowSlew;
        public byte BHSchmittInput;
        public byte BHDriveCurrent;
        public byte IFAIsFifo7;
        public byte IFAIsFifoTar7;
        public byte IFAIsFastSer7;
        public byte AIsVCP7;
        public byte IFBIsFifo7;
        public byte IFBIsFifoTar7;
        public byte IFBIsFastSer7;
        public byte BIsVCP7;
        public byte PowerSaveEnable;
        public byte PullDownEnable8;
        public byte SerNumEnable8;
        public byte ASlowSlew;
        public byte ASchmittInput;
        public byte ADriveCurrent;
        public byte BSlowSlew;
        public byte BSchmittInput;
        public byte BDriveCurrent;
        public byte CSlowSlew;
        public byte CSchmittInput;
        public byte CDriveCurrent;
        public byte DSlowSlew;
        public byte DSchmittInput;
        public byte DDriveCurrent;
        public byte ARIIsTXDEN;
        public byte BRIIsTXDEN;
        public byte CRIIsTXDEN;
        public byte DRIIsTXDEN;
        public byte AIsVCP8;
        public byte BIsVCP8;
        public byte CIsVCP8;
        public byte DIsVCP8;
        public byte PullDownEnableH;
        public byte SerNumEnableH;
        public byte ACSlowSlewH;
        public byte ACSchmittInputH;
        public byte ACDriveCurrentH;
        public byte ADSlowSlewH;
        public byte ADSchmittInputH;
        public byte ADDriveCurrentH;
        public byte Cbus0H;
        public byte Cbus1H;
        public byte Cbus2H;
        public byte Cbus3H;
        public byte Cbus4H;
        public byte Cbus5H;
        public byte Cbus6H;
        public byte Cbus7H;
        public byte Cbus8H;
        public byte Cbus9H;
        public byte IsFifoH;
        public byte IsFifoTarH;
        public byte IsFastSerH;
        public byte IsFT1248H;
        public byte FT1248CpolH;
        public byte FT1248LsbH;
        public byte FT1248FlowControlH;
        public byte IsVCPH;
        public byte PowerSaveEnableH;

        public static class ByReference
        extends FT_PROGRAM_DATA
        implements Structure.ByReference {
        }
    }

    @Structure.FieldOrder(value={"Flags", "Type", "ID", "LocId", "SerialNumber", "Description", "ftHandle"})
    public static class FT_DEVICE_LIST_INFO_NODE
    extends Structure {
        public int Flags;
        public int Type;
        public int ID;
        public int LocId;
        public Memory SerialNumber = new Memory(16L);
        public Memory Description = new Memory(64L);
        public Pointer ftHandle;
    }

    public static class NotificationEvents {
        public static final int FT_EVENT_RXCHAR = 1;
        public static final int FT_EVENT_MODEM_STATUS = 2;
        public static final int FT_EVENT_LINE_STATUS = 4;
    }

    public static class Loader {
        private Loader() {
        }

        private static String getDriverPath() {
            String libraryName = "ftd2xx";
            StringBuilder libraryPathBuilder = new StringBuilder("/natives/");
            if (Platform.isWindows()) {
                libraryPathBuilder.append("win32-");
                libraryPathBuilder.append(Platform.ARCH);
            } else if (Platform.isLinux()) {
                libraryPathBuilder.append("linux-");
                libraryPathBuilder.append(Platform.ARCH);
            } else if (Platform.isMac()) {
                libraryPathBuilder.append("darwin");
            }
            libraryPathBuilder.append('/');
            return libraryPathBuilder.toString() + System.mapLibraryName(libraryName);
        }

        static String getNative() {
            InputStream in = null;
            FileOutputStream fos = null;
            File fileOut = null;
            System.setProperty("jna.library.path", System.getProperty("java.io.tmpdir"));
            in = Loader.class.getResourceAsStream(Loader.getDriverPath());
            if (in != null) {
                String res;
                try {
                    int count;
                    fileOut = File.createTempFile(Platform.isMac() ? "lib" : "ftd2xx", Platform.isWindows() ? ".dll" : (Platform.isLinux() ? ".so" : ".dylib"));
                    fileOut.deleteOnExit();
                    fos = new FileOutputStream(fileOut);
                    byte[] buf = new byte[1024];
                    while ((count = in.read(buf, 0, buf.length)) > 0) {
                        fos.write(buf, 0, count);
                    }
                }
                catch (IOException ex) {
                    throw new Error("Failed to create temporary file for d2xx library: " + ex);
                }
                finally {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (fos != null) {
                        try {
                            fos.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                if (Platform.isMac()) {
                    StringTokenizer st = new StringTokenizer(fileOut.getName(), ".");
                    res = st.nextToken().substring(3);
                } else {
                    res = fileOut.getName();
                }
                return res;
            }
            throw new Error("Not supported OS");
        }
    }
}

