/*
 * Decompiled with CFR 0.152.
 */
package com.ftdi.handler;

import com.ftdi.AbstractEventNotificationHandler;
import com.ftdi.FTD2XXException;
import com.ftdi.FTDevice;
import com.sun.jna.Pointer;
import com.sun.jna.platform.unix.LibPThread;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventNotificationHandlerLinux
extends AbstractEventNotificationHandler<LibPThread.EVENT_HANDLE> {
    private static final Logger LOGGER = LoggerFactory.getLogger(EventNotificationHandlerLinux.class);
    private static final LibPThread libPThreadExt = LibPThread.INSTANCE;

    @Override
    protected void createEventHandle() {
        LibPThread.EVENT_HANDLE hEvent = new LibPThread.EVENT_HANDLE();
        int retVal = libPThreadExt.pthread_mutex_init(hEvent.eMutex.getPointer(), Pointer.NULL);
        LOGGER.info("Initialized the mutex: {} @ {}", (Object)retVal, (Object)hEvent.eMutex.getPointer());
        retVal = libPThreadExt.pthread_cond_init(hEvent.eCondVar.getPointer(), Pointer.NULL);
        LOGGER.info("Initialized the condVar: {} @ {}", (Object)retVal, (Object)hEvent.eCondVar.getPointer());
        this.setEventHandle(hEvent);
    }

    @Override
    protected void registerEventHandle(FTDevice ftDevice, int eventMask) throws FTD2XXException {
        LOGGER.info("SetEventNotification for event-handle @ {}", (Object)((LibPThread.EVENT_HANDLE)((Object)this.eventHandle)).getPointer());
        ftDevice.SetEventNotification(((LibPThread.EVENT_HANDLE)((Object)this.eventHandle)).getPointer(), eventMask);
    }

    @Override
    protected void waitForNotificationEvent(FTDevice ftDevice) throws FTD2XXException {
        int retVal = libPThreadExt.pthread_mutex_lock(((LibPThread.EVENT_HANDLE)((Object)this.eventHandle)).eMutex.getPointer());
        LOGGER.trace("Locked the mutex: {}", (Object)retVal);
        retVal = libPThreadExt.pthread_cond_wait(((LibPThread.EVENT_HANDLE)((Object)this.eventHandle)).eCondVar.getPointer(), ((LibPThread.EVENT_HANDLE)((Object)this.eventHandle)).eMutex.getPointer());
        LOGGER.trace("Wait on cond: {}", (Object)retVal);
        if (this.eventHandle != null) {
            retVal = libPThreadExt.pthread_mutex_unlock(((LibPThread.EVENT_HANDLE)((Object)this.eventHandle)).eMutex.getPointer());
            LOGGER.trace("Unlocked the mutex: {}", (Object)retVal);
        }
    }

    @Override
    protected void closeHandle() {
        LOGGER.info("Close the handle: {}", this.eventHandle);
        if (this.eventHandle != null) {
            LibPThread.EVENT_HANDLE hEvent = (LibPThread.EVENT_HANDLE)((Object)this.eventHandle);
            this.eventHandle = null;
            int retVal = libPThreadExt.pthread_cond_signal(hEvent.eCondVar.getPointer());
            LOGGER.info("Signal the cond: {}", (Object)retVal);
            libPThreadExt.pthread_cond_destroy(hEvent.eCondVar.getPointer());
            libPThreadExt.pthread_mutex_destroy(hEvent.eMutex.getPointer());
            this.eventHandle = null;
        }
    }

    @Override
    protected void processMessages(byte[] bytes) {
    }
}

