/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna.platform.unix;

import com.sun.jna.Library;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;

public interface LibPThread
extends Library {
    public static final String NAME = "pthread";
    public static final LibPThread INSTANCE = (LibPThread)Native.load((String)"pthread", LibPThread.class);

    public int pthread_mutex_init(Pointer var1, Pointer var2);

    public int pthread_mutex_lock(Pointer var1);

    public int pthread_mutex_unlock(Pointer var1);

    public int pthread_mutex_destroy(Pointer var1);

    public int pthread_cond_init(Pointer var1, Pointer var2);

    public int pthread_cond_wait(Pointer var1, Pointer var2);

    public int pthread_cond_signal(Pointer var1);

    public int pthread_cond_destroy(Pointer var1);

    @Structure.FieldOrder(value={"cond"})
    public static class pthread_cond_t
    extends Structure {
        public byte[] cond;

        public static int condSize() {
            return 6 * Native.LONG_SIZE;
        }

        public pthread_cond_t(Memory mem, long offset) {
            this.cond = mem.getByteArray(offset, pthread_cond_t.condSize());
            this.useMemory((Pointer)mem, (int)offset);
        }

        public static class ByReference
        extends pthread_cond_t
        implements Structure.ByReference {
            public ByReference(Memory mem, long offset) {
                super(mem, offset);
            }
        }
    }

    @Structure.FieldOrder(value={"mutex"})
    public static class pthread_mutex_t
    extends Structure {
        public byte[] mutex;

        public static int mutexSize() {
            return 5 * Native.LONG_SIZE;
        }

        public pthread_mutex_t(Memory mem, long offset) {
            this.mutex = mem.getByteArray(offset, pthread_mutex_t.mutexSize());
            this.useMemory((Pointer)mem, (int)offset);
        }

        public static class ByReference
        extends pthread_mutex_t
        implements Structure.ByReference {
            public ByReference(Memory mem, long offset) {
                super(mem, offset);
            }
        }
    }

    @Structure.FieldOrder(value={"eCondVar", "eMutex", "iVar"})
    public static class EVENT_HANDLE
    extends Structure {
        public pthread_cond_t.ByReference eCondVar;
        public pthread_mutex_t.ByReference eMutex;
        public int iVar;

        public EVENT_HANDLE() {
            this.setAlignType(1);
            Memory mem = new Memory((long)(pthread_cond_t.condSize() + pthread_mutex_t.mutexSize() + 4));
            this.useMemory((Pointer)mem);
            this.eCondVar = new pthread_cond_t.ByReference(mem, 0L);
            this.eMutex = new pthread_mutex_t.ByReference(mem, pthread_cond_t.condSize());
        }
    }
}

