/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.vfsjfilechooser2.utils;

import com.googlecode.vfsjfilechooser2.accessories.connection.Protocol;
import com.googlecode.vfsjfilechooser2.utils.VFSURIParser;
import java.util.logging.Logger;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class VFSURIParserTest {
    private static final Logger logger = Logger.getLogger(VFSURIParserTest.class.getName());

    @Test
    public void testParseLocalFiles() {
        logger.info("Testing VFSURIParser for local files\n");
        VFSURIParser parser = new VFSURIParser("file:///C:/home/birdman");
        Assertions.assertEquals((Object)Protocol.FILE, (Object)parser.getProtocol());
        Assertions.assertEquals((Object)"C:/home/birdman", (Object)parser.getPath());
        Assertions.assertNull((Object)parser.getHostname());
        Assertions.assertNull((Object)parser.getPortnumber());
        Assertions.assertNull((Object)parser.getUsername());
        Assertions.assertNull((Object)parser.getPassword());
        parser = new VFSURIParser("file:///home/birdman");
        Assertions.assertEquals((Object)Protocol.FILE, (Object)parser.getProtocol());
        Assertions.assertEquals((Object)"/home/birdman", (Object)parser.getPath());
        Assertions.assertNull((Object)parser.getHostname());
        Assertions.assertNull((Object)parser.getPortnumber());
        Assertions.assertNull((Object)parser.getUsername());
        Assertions.assertNull((Object)parser.getPassword());
    }

    @Test
    public void testParseDefaultPort() {
        logger.info("Testing VFSURIParser for remote files(default port)\n");
        try {
            VFSURIParser parser = new VFSURIParser("sftp://shell.sf.net");
            Assertions.assertEquals((Object)Protocol.SFTP, (Object)parser.getProtocol());
            Assertions.assertEquals((Object)"/", (Object)parser.getPath());
            Assertions.assertEquals((Object)"shell.sf.net", (Object)parser.getHostname());
            Assertions.assertEquals((int)Protocol.SFTP.getPort(), (int)Integer.parseInt(parser.getPortnumber()));
            Assertions.assertNull((Object)parser.getUsername());
            Assertions.assertNull((Object)parser.getPassword());
            parser = new VFSURIParser("ftp://ftp.ca.freebsd.org/");
            Assertions.assertEquals((Object)Protocol.FTP, (Object)parser.getProtocol());
            Assertions.assertEquals((Object)"/", (Object)parser.getPath());
            Assertions.assertEquals((Object)"ftp.ca.freebsd.org", (Object)parser.getHostname());
            Assertions.assertEquals((int)Protocol.FTP.getPort(), (int)Integer.parseInt(parser.getPortnumber()));
            Assertions.assertNull((Object)parser.getUsername());
            Assertions.assertNull((Object)parser.getPassword());
            parser = new VFSURIParser("webdav://myserver.net/home/yves");
            Assertions.assertEquals((Object)Protocol.WEBDAV, (Object)parser.getProtocol());
            Assertions.assertEquals((Object)"/home/yves", (Object)parser.getPath());
            Assertions.assertEquals((Object)"myserver.net", (Object)parser.getHostname());
            Assertions.assertEquals((int)Protocol.WEBDAV.getPort(), (int)Integer.parseInt(parser.getPortnumber()));
            Assertions.assertNull((Object)parser.getUsername());
            Assertions.assertNull((Object)parser.getPassword());
            parser = new VFSURIParser("sftp://yves@shell.sf.net");
            Assertions.assertEquals((Object)Protocol.SFTP, (Object)parser.getProtocol());
            Assertions.assertEquals((Object)"/", (Object)parser.getPath());
            Assertions.assertEquals((Object)"shell.sf.net", (Object)parser.getHostname());
            Assertions.assertEquals((int)Protocol.SFTP.getPort(), (int)Integer.parseInt(parser.getPortnumber()));
            Assertions.assertEquals((Object)"yves", (Object)parser.getUsername());
            Assertions.assertNull((Object)parser.getPassword());
            parser = new VFSURIParser("sftp://yves:yves@shell.sf.net/");
            Assertions.assertEquals((Object)Protocol.SFTP, (Object)parser.getProtocol());
            Assertions.assertEquals((Object)"/", (Object)parser.getPath());
            Assertions.assertEquals((Object)"shell.sf.net", (Object)parser.getHostname());
            Assertions.assertEquals((int)Protocol.SFTP.getPort(), (int)Integer.parseInt(parser.getPortnumber()));
            Assertions.assertEquals((Object)"yves", (Object)parser.getUsername());
            Assertions.assertEquals((Object)"yves", (Object)parser.getPassword());
            parser = new VFSURIParser("sftp://yves@shell.sf.net/home/yves");
            Assertions.assertEquals((Object)Protocol.SFTP, (Object)parser.getProtocol());
            Assertions.assertEquals((Object)"/home/yves", (Object)parser.getPath());
            Assertions.assertEquals((Object)"shell.sf.net", (Object)parser.getHostname());
            Assertions.assertEquals((int)Protocol.SFTP.getPort(), (int)Integer.parseInt(parser.getPortnumber()));
            Assertions.assertEquals((Object)"yves", (Object)parser.getUsername());
            Assertions.assertNull((Object)parser.getPassword());
            parser = new VFSURIParser("sftp://yves:yves@shell.sf.net/home/yves");
            Assertions.assertEquals((Object)Protocol.SFTP, (Object)parser.getProtocol());
            Assertions.assertEquals((Object)"/home/yves", (Object)parser.getPath());
            Assertions.assertEquals((Object)"shell.sf.net", (Object)parser.getHostname());
            Assertions.assertEquals((int)Protocol.SFTP.getPort(), (int)Integer.parseInt(parser.getPortnumber()));
            Assertions.assertEquals((Object)"yves", (Object)parser.getUsername());
            Assertions.assertEquals((Object)"yves", (Object)parser.getPassword());
        }
        catch (Exception ex) {
            Assertions.fail((String)("Error in the parser\n" + ex.getMessage()));
        }
    }

    @Test
    public void testParseCustomPort() {
        logger.info("Testing VFSURIParser for remote files(custom port)\n");
        VFSURIParser parser = new VFSURIParser("sftp://shell.sf.net:28");
        Assertions.assertEquals((Object)Protocol.SFTP, (Object)parser.getProtocol());
        Assertions.assertEquals((Object)"/", (Object)parser.getPath());
        Assertions.assertEquals((Object)"shell.sf.net", (Object)parser.getHostname());
        Assertions.assertEquals((Object)"28", (Object)parser.getPortnumber());
        Assertions.assertNull((Object)parser.getUsername());
        Assertions.assertNull((Object)parser.getPassword());
        parser = new VFSURIParser("sftp://shell.sf.net:28/");
        Assertions.assertEquals((Object)Protocol.SFTP, (Object)parser.getProtocol());
        Assertions.assertEquals((Object)"/", (Object)parser.getPath());
        Assertions.assertEquals((Object)"shell.sf.net", (Object)parser.getHostname());
        Assertions.assertEquals((Object)"28", (Object)parser.getPortnumber());
        Assertions.assertNull((Object)parser.getUsername());
        Assertions.assertNull((Object)parser.getPassword());
        parser = new VFSURIParser("sftp://shell.sf.net:28/home/yves");
        Assertions.assertEquals((Object)Protocol.SFTP, (Object)parser.getProtocol());
        Assertions.assertEquals((Object)"/home/yves", (Object)parser.getPath());
        Assertions.assertEquals((Object)"shell.sf.net", (Object)parser.getHostname());
        Assertions.assertEquals((Object)"28", (Object)parser.getPortnumber());
        Assertions.assertNull((Object)parser.getUsername());
        Assertions.assertNull((Object)parser.getPassword());
        parser = new VFSURIParser("sftp://yves@shell.sf.net:28");
        Assertions.assertEquals((Object)Protocol.SFTP, (Object)parser.getProtocol());
        Assertions.assertEquals((Object)"/", (Object)parser.getPath());
        Assertions.assertEquals((Object)"shell.sf.net", (Object)parser.getHostname());
        Assertions.assertEquals((Object)"28", (Object)parser.getPortnumber());
        Assertions.assertEquals((Object)"yves", (Object)parser.getUsername());
        Assertions.assertNull((Object)parser.getPassword());
        parser = new VFSURIParser("sftp://yves:yves@shell.sf.net:28/");
        Assertions.assertEquals((Object)Protocol.SFTP, (Object)parser.getProtocol());
        Assertions.assertEquals((Object)"/", (Object)parser.getPath());
        Assertions.assertEquals((Object)"shell.sf.net", (Object)parser.getHostname());
        Assertions.assertEquals((Object)"28", (Object)parser.getPortnumber());
        Assertions.assertEquals((Object)"yves", (Object)parser.getUsername());
        Assertions.assertEquals((Object)"yves", (Object)parser.getPassword());
        parser = new VFSURIParser("sftp://yves@shell.sf.net:28/home/yves");
        Assertions.assertEquals((Object)Protocol.SFTP, (Object)parser.getProtocol());
        Assertions.assertEquals((Object)"/home/yves", (Object)parser.getPath());
        Assertions.assertEquals((Object)"shell.sf.net", (Object)parser.getHostname());
        Assertions.assertEquals((Object)"28", (Object)parser.getPortnumber());
        Assertions.assertEquals((Object)"yves", (Object)parser.getUsername());
        Assertions.assertNull((Object)parser.getPassword());
        parser = new VFSURIParser("sftp://yves:yves@shell.sf.net:28/home/yves");
        Assertions.assertEquals((Object)Protocol.SFTP, (Object)parser.getProtocol());
        Assertions.assertEquals((Object)"/home/yves", (Object)parser.getPath());
        Assertions.assertEquals((Object)"shell.sf.net", (Object)parser.getHostname());
        Assertions.assertEquals((Object)"28", (Object)parser.getPortnumber());
        Assertions.assertEquals((Object)"yves", (Object)parser.getUsername());
        Assertions.assertEquals((Object)"yves", (Object)parser.getPassword());
    }
}

