/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.vfsjfilechooser2.accessories.connection;

import com.googlecode.vfsjfilechooser2.VFSJFileChooser;
import com.googlecode.vfsjfilechooser2.accessories.bookmarks.BookmarksDialog;
import com.googlecode.vfsjfilechooser2.accessories.bookmarks.TitledURLEntry;
import com.googlecode.vfsjfilechooser2.accessories.connection.Credentials;
import com.googlecode.vfsjfilechooser2.accessories.connection.Protocol;
import com.googlecode.vfsjfilechooser2.filechooser.PopupHandler;
import com.googlecode.vfsjfilechooser2.utils.VFSResources;
import com.googlecode.vfsjfilechooser2.utils.VFSUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.NumberFormat;
import java.text.ParseException;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import org.apache.commons.vfs2.FileObject;

public final class ConnectionDialog
extends JDialog {
    private static final String DIALOG_TITLE = VFSResources.getMessage("VFSJFileChooser.connectionButtonText");
    private JLabel usernameLabel;
    private JLabel defaultRemotePathLabel;
    private JLabel passwordLabel;
    private JLabel protocolLabel;
    private JLabel portLabel;
    private JLabel hostnameLabel;
    private JTextField hostnameTextField;
    private JTextField defaultRemotePathTextField;
    private JTextField usernameTextField;
    private JPasswordField passwordTextField;
    private JFormattedTextField portTextField;
    private boolean isPortTextFieldDirty;
    private JComboBox protocolList;
    private JComponent buttonsPanel;
    private JButton connectButton;
    private DefaultComboBoxModel protocolModel;
    private JButton cancelButton;
    private JComponent centerPanel;
    private VFSJFileChooser fileChooser;
    private BookmarksDialog bookmarksDialog;
    private Thread currentWorker;

    public ConnectionDialog(Frame parent, BookmarksDialog m_dialog, VFSJFileChooser chooser) {
        super(parent, DIALOG_TITLE, true);
        this.fileChooser = chooser;
        this.bookmarksDialog = m_dialog;
        this.initComponents();
        this.initListeners();
    }

    private void initComponents() {
        this.initCenterPanelComponents();
        this.initBottomPanelComponents();
        this.getContentPane().add((Component)this.buttonsPanel, "South");
        this.getContentPane().add((Component)this.centerPanel, "Center");
        this.pack();
    }

    private void initCenterPanelComponents() {
        this.centerPanel = new JPanel(new GridBagLayout());
        this.centerPanel.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.hostnameLabel = new JLabel(VFSResources.getMessage("VFSJFileChooser.hostnameLabelText"));
        this.hostnameLabel.setForeground(Color.RED);
        this.hostnameTextField = new JTextField(25);
        this.portLabel = new JLabel(VFSResources.getMessage("VFSJFileChooser.portLabelText"));
        this.portTextField = new JFormattedTextField(NumberFormat.getInstance());
        this.isPortTextFieldDirty = false;
        this.protocolLabel = new JLabel(VFSResources.getMessage("VFSJFileChooser.protocolLabelText"));
        this.protocolModel = new DefaultComboBoxModel<Protocol>(Protocol.values());
        this.protocolList = new JComboBox(this.protocolModel);
        this.protocolList.setRenderer(new ProtocolRenderer());
        this.usernameLabel = new JLabel(VFSResources.getMessage("VFSJFileChooser.usernameLabelText"));
        this.usernameTextField = new JTextField(20);
        this.passwordLabel = new JLabel(VFSResources.getMessage("VFSJFileChooser.passwordLabelText"));
        this.passwordTextField = new JPasswordField(12);
        this.defaultRemotePathLabel = new JLabel(VFSResources.getMessage("VFSJFileChooser.pathLabelText"));
        this.defaultRemotePathTextField = new JTextField(20);
        this.makeGridPanel(new Component[]{this.hostnameLabel, this.hostnameTextField, this.portLabel, this.portTextField, this.protocolLabel, this.protocolList, this.usernameLabel, this.usernameTextField, this.passwordLabel, this.passwordTextField, this.defaultRemotePathLabel, this.defaultRemotePathTextField});
    }

    private void makeGridPanel(Component[] components) {
        Insets insets = new Insets(5, 5, 5, 5);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = insets;
        gbc.ipadx = 0;
        gbc.ipady = 0;
        gbc.anchor = 13;
        gbc.fill = 2;
        int i = 0;
        int j = 0;
        for (Component component : components) {
            gbc.gridx = i++;
            gbc.gridy = j++;
            gbc.gridwidth = 1;
            gbc.gridheight = 1;
            this.centerPanel.add(component, gbc);
            if (i % 2 != 0) continue;
            i = 0;
        }
    }

    private void initListeners() {
        this.portTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                char c = e.getKeyChar();
                if (!Character.isDigit(c) && c != '\b' && c != '\u007f') {
                    ConnectionDialog.this.getToolkit().beep();
                    e.consume();
                } else {
                    ConnectionDialog.this.setPortTextFieldDirty(true);
                }
            }
        });
        this.portTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                JFormattedTextField f = (JFormattedTextField)e.getSource();
                String text = f.getText();
                if (text.length() == 0) {
                    f.setValue(null);
                }
                try {
                    f.commitEdit();
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ConnectionDialog.this.currentWorker != null && ConnectionDialog.this.currentWorker.isAlive()) {
                    ConnectionDialog.this.currentWorker.interrupt();
                    ConnectionDialog.this.setCursor(Cursor.getDefaultCursor());
                }
                ConnectionDialog.this.setVisible(false);
            }
        });
        this.connectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConnectionDialog.this.currentWorker = new Thread(){

                    @Override
                    public void run() {
                        StringBuilder error = new StringBuilder();
                        FileObject fo = null;
                        ConnectionDialog.this.setCursor(Cursor.getPredefinedCursor(3));
                        try {
                            String m_username = ConnectionDialog.this.usernameTextField.getText();
                            String m_defaultRemotePath = ConnectionDialog.this.defaultRemotePathTextField.getText();
                            char[] m_password = ConnectionDialog.this.passwordTextField.getPassword();
                            String m_hostname = ConnectionDialog.this.hostnameTextField.getText();
                            String m_protocol = ConnectionDialog.this.protocolList.getSelectedItem().toString();
                            int m_port = -1;
                            if (ConnectionDialog.this.portTextField.isEditValid() && ConnectionDialog.this.portTextField.getValue() != null) {
                                String s = ConnectionDialog.this.portTextField.getValue().toString();
                                m_port = Integer.valueOf(s);
                            }
                            Credentials.Builder credentialsBuilder = Credentials.newBuilder(m_hostname).defaultRemotePath(m_defaultRemotePath).username(m_username).password(m_password).protocol(m_protocol).port(m_port);
                            Credentials credentials = credentialsBuilder.build();
                            String uri = credentials.toFileObjectURL();
                            if (this.isInterrupted()) {
                                ConnectionDialog.this.setPortTextFieldDirty(false);
                                return;
                            }
                            fo = VFSUtils.resolveFileObject(uri);
                            if (fo != null && !fo.exists()) {
                                fo = null;
                            }
                        }
                        catch (Exception err) {
                            error.append(err.getMessage());
                            ConnectionDialog.this.setCursor(Cursor.getDefaultCursor());
                        }
                        if (error.length() > 0 || fo == null) {
                            error.delete(0, error.length());
                            error.append("Failed to connect!");
                            error.append("\n");
                            error.append("Please check parameters and try again.");
                            JOptionPane.showMessageDialog(ConnectionDialog.this, error, "Error", 0);
                            ConnectionDialog.this.setCursor(Cursor.getDefaultCursor());
                            return;
                        }
                        if (this.isInterrupted()) {
                            return;
                        }
                        ConnectionDialog.this.fileChooser.setCurrentDirectoryObject(fo);
                        ConnectionDialog.this.setCursor(Cursor.getDefaultCursor());
                        ConnectionDialog.this.resetFields();
                        if (ConnectionDialog.this.bookmarksDialog != null) {
                            String bTitle = fo.getName().getBaseName();
                            if (bTitle.trim().equals("")) {
                                bTitle = fo.getName().toString();
                            }
                            String bURL = fo.getName().getURI();
                            ConnectionDialog.this.bookmarksDialog.getBookmarks().add(new TitledURLEntry(bTitle, bURL));
                            ConnectionDialog.this.bookmarksDialog.getBookmarks().save();
                        }
                        ConnectionDialog.this.setVisible(false);
                    }
                };
                ConnectionDialog.this.currentWorker.setPriority(1);
                ConnectionDialog.this.currentWorker.start();
            }
        });
        PopupHandler.installDefaultMouseListener(this.hostnameTextField);
        PopupHandler.installDefaultMouseListener(this.portTextField);
        PopupHandler.installDefaultMouseListener(this.usernameTextField);
        PopupHandler.installDefaultMouseListener(this.passwordTextField);
        PopupHandler.installDefaultMouseListener(this.defaultRemotePathTextField);
        this.protocolList.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    ConnectionDialog.this.selectPortNumber();
                }
            }
        });
        this.protocolList.setSelectedItem((Object)Protocol.FTP);
    }

    private void selectPortNumber() {
        Protocol protocol = (Protocol)((Object)this.protocolList.getSelectedItem());
        if (protocol.toString().equals("FILE")) {
            this.enableFields(false);
            this.isPortTextFieldDirty = false;
            return;
        }
        this.enableFields(true);
        if (this.isPortTextFieldDirty() && this.portTextField.isEditValid()) {
            return;
        }
        this.portTextField.setValue(protocol.getPort());
    }

    private void setPortTextFieldDirty(boolean b) {
        this.isPortTextFieldDirty = b;
    }

    private boolean isPortTextFieldDirty() {
        return this.isPortTextFieldDirty;
    }

    private void enableFields(boolean b) {
        Component[] components;
        for (Component component : components = new Component[]{this.hostnameLabel, this.hostnameTextField, this.usernameLabel, this.usernameTextField, this.passwordLabel, this.passwordTextField, this.portLabel, this.portTextField}) {
            component.setVisible(b);
        }
    }

    private void resetFields() {
        this.isPortTextFieldDirty = false;
        this.hostnameTextField.setText("");
        this.protocolList.setSelectedItem((Object)Protocol.FTP);
        this.usernameTextField.setText("");
        this.passwordTextField.setText("");
        this.defaultRemotePathTextField.setText("");
    }

    private void initBottomPanelComponents() {
        this.buttonsPanel = new JPanel(new FlowLayout(1));
        this.cancelButton = new JButton(VFSResources.getMessage("VFSJFileChooser.cancelButtonText"));
        this.connectButton = new JButton(VFSResources.getMessage("VFSJFileChooser.connectionButtonText"));
        this.buttonsPanel.add(this.connectButton);
        this.buttonsPanel.add(this.cancelButton);
    }

    private static class ProtocolRenderer
    extends BasicComboBoxRenderer {
        private ProtocolRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
                if (-1 < index) {
                    Protocol aProtocol = (Protocol)((Object)value);
                    list.setToolTipText(aProtocol.getDescription());
                }
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setFont(list.getFont());
            this.setText(value == null ? "" : value.toString());
            return this;
        }
    }
}

