/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.vfsjfilechooser2.utils;

import com.googlecode.vfsjfilechooser2.utils.VFSUtils;
import java.util.Comparator;
import org.apache.commons.vfs2.FileObject;

public final class FileObjectComparatorFactory {
    private FileObjectComparatorFactory() {
        throw new AssertionError((Object)"Trying to instanciate FileObjectComparatorFactory");
    }

    public static Comparator<FileObject> newFileNameComparator(boolean isSortAsc) {
        return new DirectoriesFirstComparatorWrapper(new FileNameComparator(isSortAsc));
    }

    public static Comparator<FileObject> newSizeComparator(boolean isSortAsc) {
        return new DirectoriesFirstComparatorWrapper(new SizeComparator(isSortAsc));
    }

    public static Comparator<FileObject> newDateComparator(boolean isSortAsc) {
        return new DirectoriesFirstComparatorWrapper(new DateComparator(isSortAsc));
    }

    private static class DateComparator
    implements Comparator<FileObject> {
        private boolean isSortAsc = true;

        DateComparator(boolean isSortAsc) {
            this.isSortAsc = isSortAsc;
        }

        @Override
        public int compare(FileObject a, FileObject b) {
            try {
                int result = new Long(a.getContent().getLastModifiedTime()).compareTo(new Long(b.getContent().getLastModifiedTime()));
                if (!this.isSortAsc) {
                    result = -result;
                }
                return result;
            }
            catch (Exception err) {
                return -1;
            }
        }
    }

    private static class SizeComparator
    implements Comparator<FileObject> {
        private boolean isSortAsc = true;

        SizeComparator(boolean isSortAsc) {
            this.isSortAsc = isSortAsc;
        }

        @Override
        public int compare(FileObject a, FileObject b) {
            try {
                int result = new Long(a.getContent().getSize()).compareTo(new Long(b.getContent().getSize()));
                if (!this.isSortAsc) {
                    result = -result;
                }
                return result;
            }
            catch (Exception err) {
                return -1;
            }
        }
    }

    private static class DirectoriesFirstComparatorWrapper
    implements Comparator<FileObject> {
        private Comparator<FileObject> delegate;

        public DirectoriesFirstComparatorWrapper(Comparator<FileObject> comparator) {
            this.delegate = comparator;
        }

        @Override
        public int compare(FileObject f1, FileObject f2) {
            if (f1 != null && f2 != null) {
                boolean traversable1 = VFSUtils.isDirectory(f1);
                boolean traversable2 = VFSUtils.isDirectory(f2);
                if (traversable1 && !traversable2) {
                    return -1;
                }
                if (!traversable1 && traversable2) {
                    return 1;
                }
            }
            return this.delegate.compare(f1, f2);
        }
    }

    private static class FileNameComparator
    implements Comparator<FileObject> {
        private boolean isSortAsc = true;

        FileNameComparator(boolean isSortAsc) {
            this.isSortAsc = isSortAsc;
        }

        @Override
        public int compare(FileObject a, FileObject b) {
            try {
                int result = a.getName().toString().toLowerCase().compareTo(b.getName().toString().toLowerCase());
                if (!this.isSortAsc) {
                    result = -result;
                }
                return result;
            }
            catch (Exception err) {
                return -1;
            }
        }
    }
}

