/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.vfsjfilechooser2.utils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class VFSURIValidator {
    private String local_uri;
    private String local_protocol;
    private String local_user;
    private String local_pass;
    private String local_hostname;
    private String local_port;
    private String local_file;

    public boolean assertEquals(String _s1, String _s2) {
        Exception e;
        if (_s1 == null || _s2 == null) {
            System.out.println("FATAL assertEquals -- _s1 || _s2 == null");
            System.out.println("_s1=" + _s1 + "=");
            System.out.println("_s2=" + _s2 + "=");
            e = new Exception("");
            e.printStackTrace();
            System.exit(10);
        }
        if (!_s1.equals(_s2)) {
            System.out.println("FATAL assertEquals -- _s1 != _s2 ");
            System.out.println("_s1=" + _s1 + "=");
            System.out.println("_s2=" + _s2 + "=");
            e = new Exception("");
            e.printStackTrace();
            System.exit(10);
        }
        return false;
    }

    public boolean assertNull(String _s1) {
        if (_s1 != null) {
            System.out.println("FATAL assertNull -- _s1  != null");
            Exception e = new Exception("");
            e.printStackTrace();
            System.exit(10);
        }
        return false;
    }

    public boolean assertnotNull(String _s1) {
        if (_s1 == null) {
            System.out.println("FATAL assertnoNull -- _s1  != null");
            Exception e = new Exception("");
            e.printStackTrace();
            System.exit(10);
        }
        return false;
    }

    public String getUri() {
        if (this.local_uri.equals("")) {
            this.local_uri = null;
        }
        return this.local_uri;
    }

    public String getProtocol() {
        if (this.local_protocol != null && this.local_protocol.equals("")) {
            this.local_protocol = null;
        }
        return this.local_protocol;
    }

    public String getUser() {
        if (this.local_user != null && this.local_user.equals("")) {
            this.local_user = null;
        }
        return this.local_user;
    }

    public String getPassword() {
        if (this.local_pass != null && this.local_pass.equals("")) {
            this.local_pass = null;
        }
        return this.local_pass;
    }

    public String getHostname() {
        if (this.local_hostname != null && this.local_hostname.equals("")) {
            this.local_hostname = null;
        }
        return this.local_hostname;
    }

    public String getPort() {
        if (this.local_port == null) {
            return this.local_port;
        }
        if (this.local_port.startsWith(":")) {
            this.local_port = this.local_port.substring(1);
        }
        if (this.local_port != null && this.local_port.equals("")) {
            this.local_port = null;
        }
        return this.local_port;
    }

    public String getFile() {
        if (this.local_file != null && this.local_file.equals("")) {
            this.local_file = null;
        }
        return this.local_file;
    }

    public boolean isValid(String _uri) {
        boolean ret = false;
        boolean ends_with_slash = false;
        String protocol = null;
        String user_pass = null;
        String hostname = null;
        String port = null;
        String bad_port = null;
        String drive = null;
        String file = null;
        this.local_uri = null;
        this.local_protocol = null;
        this.local_user = null;
        this.local_pass = null;
        this.local_hostname = null;
        this.local_port = null;
        this.local_file = null;
        Pattern p_file1 = Pattern.compile("(file|FILE)://(/*)([a-zA-Z][ \t]*:)*(.*)");
        Matcher m_file1 = p_file1.matcher(_uri);
        if (m_file1.matches()) {
            protocol = m_file1.group(1);
            String path_start = m_file1.group(2);
            drive = m_file1.group(3);
            file = m_file1.group(4);
            this.local_uri = _uri;
            this.local_protocol = protocol;
            this.local_user = null;
            this.local_pass = null;
            this.local_hostname = null;
            this.local_port = null;
            this.local_file = drive != null && file != null ? drive + file : (path_start != null && drive == null && file != null ? path_start + file : (drive != null && file == null ? drive : file));
            return true;
        }
        if (_uri.endsWith("/")) {
            int iend = _uri.length();
            _uri = _uri.substring(0, iend - 1);
            ends_with_slash = true;
        }
        Pattern p_ftp2 = Pattern.compile("(ftp|FTP|sftp|SFTP|http|HTTP|https|HTTPS|webdav|WEBDAV|smb|SMB)://(.+:.+@)*([^:]+?/*)([ \t]*:[0-9]+)*([ \t]*:)*(/.*)");
        Matcher m_ftp2 = p_ftp2.matcher(_uri);
        Pattern p_ftp3 = Pattern.compile("(ftp|FTP|sftp|SFTP|http|HTTP|https|HTTPS|webdav|WEBDAV|smb|SMB)://(.+:.+@)*([^:]+)([ \t]*:[0-9]+)*([ \t]*:)*(/*?.*)");
        Matcher m_ftp3 = p_ftp3.matcher(_uri);
        if (m_ftp2.matches()) {
            ret = true;
            protocol = m_ftp2.group(1);
            user_pass = m_ftp2.group(2);
            hostname = m_ftp2.group(3);
            port = m_ftp2.group(4);
            bad_port = m_ftp2.group(5);
            file = m_ftp2.group(6);
            if (ends_with_slash) {
                file = file + "/";
            }
            if (hostname == null) {
                protocol = null;
                user_pass = null;
                port = null;
                bad_port = null;
                file = null;
                ret = false;
            }
        } else if (m_ftp3.matches()) {
            ret = true;
            protocol = m_ftp3.group(1);
            user_pass = m_ftp3.group(2);
            hostname = m_ftp3.group(3);
            port = m_ftp3.group(4);
            bad_port = m_ftp3.group(5);
            file = m_ftp3.group(6);
            if (ends_with_slash) {
                file = file + "/";
            }
            if (hostname == null) {
                protocol = null;
                user_pass = null;
                port = null;
                bad_port = null;
                file = null;
                ret = false;
            }
        }
        if (ret) {
            // empty if block
        }
        if (hostname != null && hostname.contains("@")) {
            user_pass = hostname.substring(0, hostname.indexOf(64));
            hostname = hostname.substring(hostname.indexOf(64) + 1);
        }
        if (hostname != null && (hostname.startsWith(":") || hostname.endsWith(":") || hostname.contains(":"))) {
            ret = false;
        }
        if (bad_port != null) {
            ret = false;
        }
        if (!ret) {
            return ret;
        }
        this.local_uri = _uri;
        this.local_protocol = protocol;
        int colon_position = -1;
        colon_position = user_pass == null || user_pass.equals("") ? -1 : user_pass.indexOf(58);
        if (user_pass == null || user_pass.equals("")) {
            this.local_user = null;
            this.local_pass = null;
        } else if (colon_position == -1) {
            this.local_user = user_pass;
            this.local_pass = null;
        } else {
            this.local_user = user_pass.substring(0, colon_position);
            this.local_pass = user_pass.substring(colon_position);
        }
        if (this.local_pass != null) {
            if (this.local_pass.endsWith("@")) {
                this.local_pass = this.local_pass.substring(0, this.local_pass.length() - 1);
            }
            if (this.local_pass.startsWith(":")) {
                this.local_pass = this.local_pass.substring(1);
            }
        }
        this.local_hostname = hostname;
        this.local_port = port;
        this.local_file = file;
        return ret;
    }

    public void error_msg(String _s) {
        System.out.println("Error in test=" + _s + "=");
        Exception e = new Exception("");
        e.printStackTrace();
        System.exit(10);
    }

    public static void main(String[] args) {
        VFSURIValidator v = new VFSURIValidator();
        String s = "files://c:";
        if (v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertNull(v.getProtocol());
        v.assertNull(v.getUser());
        v.assertNull(v.getHostname());
        v.assertNull(v.getPassword());
        v.assertNull(v.getPort());
        v.assertNull(v.getFile());
        s = "files://c:";
        if (v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertNull(v.getProtocol());
        v.assertNull(v.getUser());
        v.assertNull(v.getHostname());
        v.assertNull(v.getPassword());
        v.assertNull(v.getPort());
        v.assertNull(v.getFile());
        s = "FTPS://c:";
        if (v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertNull(v.getProtocol());
        v.assertNull(v.getUser());
        v.assertNull(v.getHostname());
        v.assertNull(v.getPassword());
        v.assertNull(v.getPort());
        v.assertNull(v.getFile());
        s = "ftps://c:";
        if (v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertNull(v.getProtocol());
        v.assertNull(v.getUser());
        v.assertNull(v.getHostname());
        v.assertNull(v.getPassword());
        v.assertNull(v.getPort());
        v.assertNull(v.getFile());
        s = "files123://c:";
        if (v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertNull(v.getProtocol());
        v.assertNull(v.getUser());
        v.assertNull(v.getHostname());
        v.assertNull(v.getPassword());
        v.assertNull(v.getPort());
        v.assertNull(v.getFile());
        s = "fiLE://c:";
        if (v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertNull(v.getProtocol());
        v.assertNull(v.getUser());
        v.assertNull(v.getHostname());
        v.assertNull(v.getPassword());
        v.assertNull(v.getPort());
        v.assertNull(v.getFile());
        s = "file://c:";
        if (!v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertEquals(v.getProtocol(), "file");
        v.assertNull(v.getUser());
        v.assertNull(v.getHostname());
        v.assertNull(v.getPassword());
        v.assertNull(v.getPort());
        v.assertEquals(v.getFile(), "c:");
        s = "file://d:";
        if (!v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertEquals(v.getProtocol(), "file");
        v.assertNull(v.getUser());
        v.assertNull(v.getHostname());
        v.assertNull(v.getPassword());
        v.assertNull(v.getPort());
        v.assertEquals(v.getFile(), "d:");
        s = "file://e:";
        if (!v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertEquals(v.getProtocol(), "file");
        v.assertNull(v.getUser());
        v.assertNull(v.getHostname());
        v.assertNull(v.getPassword());
        v.assertNull(v.getPort());
        v.assertEquals(v.getFile(), "e:");
        s = "file://z:";
        if (!v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertEquals(v.getProtocol(), "file");
        v.assertNull(v.getUser());
        v.assertNull(v.getHostname());
        v.assertNull(v.getPassword());
        v.assertNull(v.getPort());
        v.assertEquals(v.getFile(), "z:");
        s = "file://c:/";
        if (!v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertEquals(v.getProtocol(), "file");
        v.assertNull(v.getUser());
        v.assertNull(v.getHostname());
        v.assertNull(v.getPassword());
        v.assertNull(v.getPort());
        v.assertEquals(v.getFile(), "c:/");
        s = "file://d:/";
        if (!v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertEquals(v.getProtocol(), "file");
        v.assertNull(v.getUser());
        v.assertNull(v.getHostname());
        v.assertNull(v.getPassword());
        v.assertNull(v.getPort());
        v.assertEquals(v.getFile(), "d:/");
        s = "file://e:/";
        if (!v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertEquals(v.getProtocol(), "file");
        v.assertNull(v.getUser());
        v.assertNull(v.getHostname());
        v.assertNull(v.getPassword());
        v.assertNull(v.getPort());
        v.assertEquals(v.getFile(), "e:/");
        s = "file://z:/";
        if (!v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertEquals(v.getProtocol(), "file");
        v.assertNull(v.getUser());
        v.assertNull(v.getHostname());
        v.assertNull(v.getPassword());
        v.assertNull(v.getPort());
        v.assertEquals(v.getFile(), "z:/");
        s = "file://c:/a";
        if (!v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertEquals(v.getProtocol(), "file");
        v.assertNull(v.getUser());
        v.assertNull(v.getHostname());
        v.assertNull(v.getPassword());
        v.assertNull(v.getPort());
        v.assertEquals(v.getFile(), "c:/a");
        s = "file://d:/a";
        if (!v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertEquals(v.getProtocol(), "file");
        v.assertNull(v.getUser());
        v.assertNull(v.getHostname());
        v.assertNull(v.getPassword());
        v.assertNull(v.getPort());
        v.assertEquals(v.getFile(), "d:/a");
        s = "file://e:/b";
        if (!v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertEquals(v.getProtocol(), "file");
        v.assertNull(v.getUser());
        v.assertNull(v.getHostname());
        v.assertNull(v.getPassword());
        v.assertNull(v.getPort());
        v.assertEquals(v.getFile(), "e:/b");
        s = "file://z:/b";
        if (!v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertEquals(v.getProtocol(), "file");
        v.assertNull(v.getUser());
        v.assertNull(v.getHostname());
        v.assertNull(v.getPassword());
        v.assertNull(v.getPort());
        v.assertEquals(v.getFile(), "z:/b");
        s = "FILE://c:";
        if (!v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertEquals(v.getProtocol(), "FILE");
        v.assertNull(v.getUser());
        v.assertNull(v.getHostname());
        v.assertNull(v.getPassword());
        v.assertNull(v.getPort());
        v.assertEquals(v.getFile(), "c:");
        s = "FILE://d:";
        if (!v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertEquals(v.getProtocol(), "FILE");
        v.assertNull(v.getUser());
        v.assertNull(v.getHostname());
        v.assertNull(v.getPassword());
        v.assertNull(v.getPort());
        v.assertEquals(v.getFile(), "d:");
        s = "FILE://e:";
        if (!v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertEquals(v.getProtocol(), "FILE");
        v.assertNull(v.getUser());
        v.assertNull(v.getHostname());
        v.assertNull(v.getPassword());
        v.assertNull(v.getPort());
        v.assertEquals(v.getFile(), "e:");
        s = "FILE://z:";
        if (!v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertEquals(v.getProtocol(), "FILE");
        v.assertNull(v.getUser());
        v.assertNull(v.getHostname());
        v.assertNull(v.getPassword());
        v.assertNull(v.getPort());
        v.assertEquals(v.getFile(), "z:");
        s = "FILE://c:/";
        if (!v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertEquals(v.getProtocol(), "FILE");
        v.assertNull(v.getUser());
        v.assertNull(v.getHostname());
        v.assertNull(v.getPassword());
        v.assertNull(v.getPort());
        v.assertEquals(v.getFile(), "c:/");
        s = "FILE://d:/";
        if (!v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertEquals(v.getProtocol(), "FILE");
        v.assertNull(v.getUser());
        v.assertNull(v.getHostname());
        v.assertNull(v.getPassword());
        v.assertNull(v.getPort());
        v.assertEquals(v.getFile(), "d:/");
        s = "FILE://e:/";
        if (!v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertEquals(v.getProtocol(), "FILE");
        v.assertNull(v.getUser());
        v.assertNull(v.getHostname());
        v.assertNull(v.getPassword());
        v.assertNull(v.getPort());
        v.assertEquals(v.getFile(), "e:/");
        s = "FILE://z:/";
        if (!v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertEquals(v.getProtocol(), "FILE");
        v.assertNull(v.getUser());
        v.assertNull(v.getHostname());
        v.assertNull(v.getPassword());
        v.assertNull(v.getPort());
        v.assertEquals(v.getFile(), "z:/");
        s = "FILE://c:/a";
        if (!v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertEquals(v.getProtocol(), "FILE");
        v.assertNull(v.getUser());
        v.assertNull(v.getHostname());
        v.assertNull(v.getPassword());
        v.assertNull(v.getPort());
        v.assertEquals(v.getFile(), "c:/a");
        s = "FILE://d:/a";
        if (!v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertEquals(v.getProtocol(), "FILE");
        v.assertNull(v.getUser());
        v.assertNull(v.getHostname());
        v.assertNull(v.getPassword());
        v.assertNull(v.getPort());
        v.assertEquals(v.getFile(), "d:/a");
        s = "FILE://e:/b";
        if (!v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertEquals(v.getProtocol(), "FILE");
        v.assertNull(v.getUser());
        v.assertNull(v.getHostname());
        v.assertNull(v.getPassword());
        v.assertNull(v.getPort());
        v.assertEquals(v.getFile(), "e:/b");
        s = "FILE://z:/b";
        if (!v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertEquals(v.getProtocol(), "FILE");
        v.assertNull(v.getUser());
        v.assertNull(v.getHostname());
        v.assertNull(v.getPassword());
        v.assertNull(v.getPort());
        v.assertEquals(v.getFile(), "z:/b");
        s = "ftp://machine/the_file";
        if (!v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertEquals(v.getProtocol(), "ftp");
        v.assertNull(v.getUser());
        v.assertEquals(v.getHostname(), "machine");
        v.assertNull(v.getPassword());
        v.assertNull(v.getPort());
        v.assertEquals(v.getFile(), "/the_file");
        s = "ftp://machine:1/the_file";
        if (!v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertEquals(v.getProtocol(), "ftp");
        v.assertNull(v.getUser());
        v.assertEquals(v.getHostname(), "machine");
        v.assertNull(v.getPassword());
        v.assertEquals(v.getPort(), "1");
        v.assertEquals(v.getFile(), "/the_file");
        s = "ftp://machine:12345/the_file";
        if (!v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertEquals(v.getProtocol(), "ftp");
        v.assertNull(v.getUser());
        v.assertEquals(v.getHostname(), "machine");
        v.assertNull(v.getPassword());
        v.assertEquals(v.getPort(), "12345");
        v.assertEquals(v.getFile(), "/the_file");
        s = "ftp://machine:/the_file";
        if (v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertNull(v.getProtocol());
        v.assertNull(v.getUser());
        v.assertNull(v.getHostname());
        v.assertNull(v.getPassword());
        v.assertNull(v.getPort());
        v.assertNull(v.getFile());
        s = "ftp://user:pass@machine/the_file";
        if (!v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertEquals(v.getProtocol(), "ftp");
        v.assertEquals(v.getUser(), "user");
        v.assertEquals(v.getPassword(), "pass");
        v.assertEquals(v.getHostname(), "machine");
        v.assertNull(v.getPort());
        v.assertEquals(v.getFile(), "/the_file");
        s = "ftp://user:pass@machine:123/the_file";
        if (!v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertEquals(v.getProtocol(), "ftp");
        v.assertEquals(v.getUser(), "user");
        v.assertEquals(v.getPassword(), "pass");
        v.assertEquals(v.getHostname(), "machine");
        v.assertEquals(v.getPort(), "123");
        v.assertEquals(v.getFile(), "/the_file");
        s = "ftp://user:pass@machine:/the_file";
        if (v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertNull(v.getProtocol());
        v.assertNull(v.getUser());
        v.assertNull(v.getHostname());
        v.assertNull(v.getPassword());
        v.assertNull(v.getPort());
        v.assertNull(v.getFile());
        s = "ftp://user:pass:@machine/the_file";
        if (!v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertEquals(v.getProtocol(), "ftp");
        v.assertEquals(v.getUser(), "user");
        v.assertEquals(v.getPassword(), "pass:");
        v.assertEquals(v.getHostname(), "machine");
        v.assertNull(v.getPort());
        v.assertEquals(v.getFile(), "/the_file");
        s = "ftp://user:pass:@machine/the_dir/";
        if (!v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertEquals(v.getProtocol(), "ftp");
        v.assertEquals(v.getUser(), "user");
        v.assertEquals(v.getPassword(), "pass:");
        v.assertEquals(v.getHostname(), "machine");
        v.assertNull(v.getPort());
        v.assertEquals(v.getFile(), "/the_dir/");
        s = "ftp: //user:pass:@machine/the_file";
        if (v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertNull(v.getProtocol());
        v.assertNull(v.getUser());
        v.assertNull(v.getHostname());
        v.assertNull(v.getPassword());
        v.assertNull(v.getPort());
        v.assertNull(v.getFile());
        s = "ftp:/ /user:pass:@machine/the_file";
        if (v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertNull(v.getProtocol());
        v.assertNull(v.getUser());
        v.assertNull(v.getHostname());
        v.assertNull(v.getPassword());
        v.assertNull(v.getPort());
        v.assertNull(v.getFile());
        s = "ftp:/ /user:pass:@machine";
        if (v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertNull(v.getProtocol());
        v.assertNull(v.getUser());
        v.assertNull(v.getHostname());
        v.assertNull(v.getPassword());
        v.assertNull(v.getPort());
        v.assertNull(v.getFile());
        s = "ftp://user:pass:@:123/a";
        if (v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertNull(v.getProtocol());
        v.assertNull(v.getUser());
        v.assertNull(v.getHostname());
        v.assertNull(v.getPassword());
        v.assertNull(v.getPort());
        v.assertNull(v.getFile());
        s = "ftp://user:pass:@machine:a/the_file";
        if (v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertNull(v.getProtocol());
        v.assertNull(v.getUser());
        v.assertNull(v.getHostname());
        v.assertNull(v.getPassword());
        v.assertNull(v.getPort());
        v.assertNull(v.getFile());
        s = "FTP://machine/the_file";
        if (!v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertEquals(v.getProtocol(), "FTP");
        v.assertNull(v.getUser());
        v.assertNull(v.getPassword());
        v.assertEquals(v.getHostname(), "machine");
        v.assertNull(v.getPort());
        v.assertEquals(v.getFile(), "/the_file");
        s = "FTP://machine:1/the_file";
        if (!v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertEquals(v.getProtocol(), "FTP");
        v.assertNull(v.getUser());
        v.assertNull(v.getPassword());
        v.assertEquals(v.getHostname(), "machine");
        v.assertEquals(v.getPort(), "1");
        v.assertEquals(v.getFile(), "/the_file");
        s = "FTP://machine:12345/the_file";
        if (!v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertEquals(v.getProtocol(), "FTP");
        v.assertNull(v.getUser());
        v.assertNull(v.getPassword());
        v.assertEquals(v.getHostname(), "machine");
        v.assertEquals(v.getPort(), "12345");
        v.assertEquals(v.getFile(), "/the_file");
        s = "FTP://machine:/the_file";
        if (v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertNull(v.getProtocol());
        v.assertNull(v.getUser());
        v.assertNull(v.getHostname());
        v.assertNull(v.getPassword());
        v.assertNull(v.getPort());
        v.assertNull(v.getFile());
        s = "FTP://user:pass@machine/the_file";
        if (!v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertEquals(v.getProtocol(), "FTP");
        v.assertEquals(v.getUser(), "user");
        v.assertEquals(v.getPassword(), "pass");
        v.assertEquals(v.getHostname(), "machine");
        v.assertNull(v.getPort());
        v.assertEquals(v.getFile(), "/the_file");
        s = "FTP://user:pass@machine:123/the_file";
        if (!v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertEquals(v.getProtocol(), "FTP");
        v.assertEquals(v.getUser(), "user");
        v.assertEquals(v.getPassword(), "pass");
        v.assertEquals(v.getHostname(), "machine");
        v.assertEquals(v.getPort(), "123");
        v.assertEquals(v.getFile(), "/the_file");
        s = "FTP://user:pass@machine:/the_file";
        if (v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertNull(v.getProtocol());
        v.assertNull(v.getUser());
        v.assertNull(v.getHostname());
        v.assertNull(v.getPassword());
        v.assertNull(v.getPort());
        v.assertNull(v.getFile());
        s = "FTP://user:pass:@machine/the_file";
        if (!v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertEquals(v.getProtocol(), "FTP");
        v.assertEquals(v.getUser(), "user");
        v.assertEquals(v.getPassword(), "pass:");
        v.assertEquals(v.getHostname(), "machine");
        v.assertNull(v.getPort());
        v.assertEquals(v.getFile(), "/the_file");
        s = "FTP://user:pass:@machine/the_dir/";
        if (!v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertEquals(v.getProtocol(), "FTP");
        v.assertEquals(v.getUser(), "user");
        v.assertEquals(v.getPassword(), "pass:");
        v.assertEquals(v.getHostname(), "machine");
        v.assertNull(v.getPort());
        v.assertEquals(v.getFile(), "/the_dir/");
        s = "FTP: //user:pass:@machine/the_file";
        if (v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertNull(v.getProtocol());
        v.assertNull(v.getUser());
        v.assertNull(v.getHostname());
        v.assertNull(v.getPassword());
        v.assertNull(v.getPort());
        v.assertNull(v.getFile());
        s = "FTP:/ /user:pass:@machine/the_file";
        if (v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertNull(v.getProtocol());
        v.assertNull(v.getUser());
        v.assertNull(v.getHostname());
        v.assertNull(v.getPassword());
        v.assertNull(v.getPort());
        v.assertNull(v.getFile());
        s = "FTP:/ /user:pass:@machine";
        if (v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertNull(v.getProtocol());
        v.assertNull(v.getUser());
        v.assertNull(v.getHostname());
        v.assertNull(v.getPassword());
        v.assertNull(v.getPort());
        v.assertNull(v.getFile());
        s = "FTP://user:pass:@:123/a";
        if (v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertNull(v.getProtocol());
        v.assertNull(v.getUser());
        v.assertNull(v.getHostname());
        v.assertNull(v.getPassword());
        v.assertNull(v.getPort());
        v.assertNull(v.getFile());
        s = "FTP://user:pass:@machine:a/the_file";
        if (v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertNull(v.getProtocol());
        v.assertNull(v.getUser());
        v.assertNull(v.getHostname());
        v.assertNull(v.getPassword());
        v.assertNull(v.getPort());
        v.assertNull(v.getFile());
        s = "sftp://machine/the_file";
        if (!v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertEquals(v.getProtocol(), "sftp");
        v.assertNull(v.getUser());
        v.assertNull(v.getPassword());
        v.assertEquals(v.getHostname(), "machine");
        v.assertNull(v.getPort());
        v.assertEquals(v.getFile(), "/the_file");
        s = "sftp://machine:1/the_file";
        if (!v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertEquals(v.getProtocol(), "sftp");
        v.assertNull(v.getUser());
        v.assertNull(v.getPassword());
        v.assertEquals(v.getHostname(), "machine");
        v.assertEquals(v.getPort(), "1");
        v.assertEquals(v.getFile(), "/the_file");
        s = "sftp://machine:12345/the_file";
        if (!v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertEquals(v.getProtocol(), "sftp");
        v.assertNull(v.getUser());
        v.assertNull(v.getPassword());
        v.assertEquals(v.getHostname(), "machine");
        v.assertEquals(v.getPort(), "12345");
        v.assertEquals(v.getFile(), "/the_file");
        s = "sftp://machine:/the_file";
        if (v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertNull(v.getProtocol());
        v.assertNull(v.getUser());
        v.assertNull(v.getHostname());
        v.assertNull(v.getPassword());
        v.assertNull(v.getPort());
        v.assertNull(v.getFile());
        s = "sftp://user:pass@machine/the_file";
        if (!v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertEquals(v.getProtocol(), "sftp");
        v.assertEquals(v.getUser(), "user");
        v.assertEquals(v.getPassword(), "pass");
        v.assertEquals(v.getHostname(), "machine");
        v.assertNull(v.getPort());
        v.assertEquals(v.getFile(), "/the_file");
        s = "sftp://user:pass@machine:123/the_file";
        if (!v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertEquals(v.getProtocol(), "sftp");
        v.assertEquals(v.getUser(), "user");
        v.assertEquals(v.getPassword(), "pass");
        v.assertEquals(v.getHostname(), "machine");
        v.assertEquals(v.getPort(), "123");
        v.assertEquals(v.getFile(), "/the_file");
        s = "sftp://user:pass@machine:/the_file";
        if (v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertNull(v.getProtocol());
        v.assertNull(v.getUser());
        v.assertNull(v.getHostname());
        v.assertNull(v.getPassword());
        v.assertNull(v.getPort());
        v.assertNull(v.getFile());
        s = "sftp://user:pass:@machine/the_file";
        if (!v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertEquals(v.getProtocol(), "sftp");
        v.assertEquals(v.getUser(), "user");
        v.assertEquals(v.getPassword(), "pass:");
        v.assertEquals(v.getHostname(), "machine");
        v.assertNull(v.getPort());
        v.assertEquals(v.getFile(), "/the_file");
        s = "sftp://user:pass:@machine/the_dir/";
        if (!v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertEquals(v.getProtocol(), "sftp");
        v.assertEquals(v.getUser(), "user");
        v.assertEquals(v.getPassword(), "pass:");
        v.assertEquals(v.getHostname(), "machine");
        v.assertNull(v.getPort());
        v.assertEquals(v.getFile(), "/the_dir/");
        s = "sftp: //user:pass:@machine/the_file";
        if (v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertNull(v.getProtocol());
        v.assertNull(v.getUser());
        v.assertNull(v.getHostname());
        v.assertNull(v.getPassword());
        v.assertNull(v.getPort());
        v.assertNull(v.getFile());
        s = "sftp:/ /user:pass:@machine/the_file";
        if (v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertNull(v.getProtocol());
        v.assertNull(v.getUser());
        v.assertNull(v.getHostname());
        v.assertNull(v.getPassword());
        v.assertNull(v.getPort());
        v.assertNull(v.getFile());
        s = "sftp:/ /user:pass:@machine";
        if (v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertNull(v.getProtocol());
        v.assertNull(v.getUser());
        v.assertNull(v.getHostname());
        v.assertNull(v.getPassword());
        v.assertNull(v.getPort());
        v.assertNull(v.getFile());
        s = "sftp://user:pass:@:123/a";
        if (v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertNull(v.getProtocol());
        v.assertNull(v.getUser());
        v.assertNull(v.getHostname());
        v.assertNull(v.getPassword());
        v.assertNull(v.getPort());
        v.assertNull(v.getFile());
        s = "sftp://user:pass:@machine:a/the_file";
        if (v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertNull(v.getProtocol());
        v.assertNull(v.getUser());
        v.assertNull(v.getHostname());
        v.assertNull(v.getPassword());
        v.assertNull(v.getPort());
        v.assertNull(v.getFile());
        s = "SFTP://machine/the_file";
        if (!v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertEquals(v.getProtocol(), "SFTP");
        v.assertNull(v.getUser());
        v.assertNull(v.getPassword());
        v.assertEquals(v.getHostname(), "machine");
        v.assertNull(v.getPort());
        v.assertEquals(v.getFile(), "/the_file");
        s = "SFTP://machine:1/the_file";
        if (!v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertEquals(v.getProtocol(), "SFTP");
        v.assertNull(v.getUser());
        v.assertNull(v.getPassword());
        v.assertEquals(v.getHostname(), "machine");
        v.assertEquals(v.getPort(), "1");
        v.assertEquals(v.getFile(), "/the_file");
        s = "SFTP://machine:12345/the_file";
        if (!v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertEquals(v.getProtocol(), "SFTP");
        v.assertNull(v.getUser());
        v.assertNull(v.getPassword());
        v.assertEquals(v.getHostname(), "machine");
        v.assertEquals(v.getPort(), "12345");
        v.assertEquals(v.getFile(), "/the_file");
        s = "SFTP://machine:/the_file";
        if (v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertNull(v.getProtocol());
        v.assertNull(v.getUser());
        v.assertNull(v.getHostname());
        v.assertNull(v.getPassword());
        v.assertNull(v.getPort());
        v.assertNull(v.getFile());
        s = "SFTP://user:pass@machine/the_file";
        if (!v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertEquals(v.getProtocol(), "SFTP");
        v.assertEquals(v.getUser(), "user");
        v.assertEquals(v.getPassword(), "pass");
        v.assertEquals(v.getHostname(), "machine");
        v.assertNull(v.getPort());
        v.assertEquals(v.getFile(), "/the_file");
        s = "SFTP://user:pass@machine:123/the_file";
        if (!v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertEquals(v.getProtocol(), "SFTP");
        v.assertEquals(v.getUser(), "user");
        v.assertEquals(v.getPassword(), "pass");
        v.assertEquals(v.getHostname(), "machine");
        v.assertEquals(v.getPort(), "123");
        v.assertEquals(v.getFile(), "/the_file");
        s = "SFTP://user:pass@machine:/the_file";
        if (v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertNull(v.getProtocol());
        v.assertNull(v.getUser());
        v.assertNull(v.getHostname());
        v.assertNull(v.getPassword());
        v.assertNull(v.getPort());
        v.assertNull(v.getFile());
        s = "SFTP://user:pass:@machine/the_file";
        if (!v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertEquals(v.getProtocol(), "SFTP");
        v.assertEquals(v.getUser(), "user");
        v.assertEquals(v.getPassword(), "pass:");
        v.assertEquals(v.getHostname(), "machine");
        v.assertNull(v.getPort());
        v.assertEquals(v.getFile(), "/the_file");
        s = "SFTP://user:pass:@machine/the_dir/";
        if (!v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertEquals(v.getProtocol(), "SFTP");
        v.assertEquals(v.getUser(), "user");
        v.assertEquals(v.getPassword(), "pass:");
        v.assertEquals(v.getHostname(), "machine");
        v.assertNull(v.getPort());
        v.assertEquals(v.getFile(), "/the_dir/");
        s = "SFTP: //user:pass:@machine/the_file";
        if (v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertNull(v.getProtocol());
        v.assertNull(v.getUser());
        v.assertNull(v.getHostname());
        v.assertNull(v.getPassword());
        v.assertNull(v.getPort());
        v.assertNull(v.getFile());
        s = "SFTP:/ /user:pass:@machine/the_file";
        if (v.isValid(s)) {
            v.error_msg(s);
        }
        s = "SFTP:/ /user:pass:@machine";
        v.assertNull(v.getProtocol());
        v.assertNull(v.getUser());
        v.assertNull(v.getHostname());
        v.assertNull(v.getPassword());
        v.assertNull(v.getPort());
        v.assertNull(v.getFile());
        if (v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertNull(v.getProtocol());
        v.assertNull(v.getUser());
        v.assertNull(v.getHostname());
        v.assertNull(v.getPassword());
        v.assertNull(v.getPort());
        v.assertNull(v.getFile());
        s = "SFTP://user:pass:@:123/a";
        if (v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertNull(v.getProtocol());
        v.assertNull(v.getUser());
        v.assertNull(v.getHostname());
        v.assertNull(v.getPassword());
        v.assertNull(v.getPort());
        v.assertNull(v.getFile());
        s = "SFTP://user:pass:@machine:a/the_file";
        if (v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertNull(v.getProtocol());
        v.assertNull(v.getUser());
        v.assertNull(v.getHostname());
        v.assertNull(v.getPassword());
        v.assertNull(v.getPort());
        v.assertNull(v.getFile());
        s = "http://machine/the_file";
        if (!v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertEquals(v.getProtocol(), "http");
        v.assertNull(v.getUser());
        v.assertNull(v.getPassword());
        v.assertEquals(v.getHostname(), "machine");
        v.assertNull(v.getPort());
        v.assertEquals(v.getFile(), "/the_file");
        s = "http://machine:1/the_file";
        if (!v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertEquals(v.getProtocol(), "http");
        v.assertNull(v.getUser());
        v.assertNull(v.getPassword());
        v.assertEquals(v.getHostname(), "machine");
        v.assertEquals(v.getPort(), "1");
        v.assertEquals(v.getFile(), "/the_file");
        s = "http://machine:12345/the_file";
        if (!v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertEquals(v.getProtocol(), "http");
        v.assertNull(v.getUser());
        v.assertNull(v.getPassword());
        v.assertEquals(v.getHostname(), "machine");
        v.assertEquals(v.getPort(), "12345");
        v.assertEquals(v.getFile(), "/the_file");
        s = "http://machine:/the_file";
        if (v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertNull(v.getProtocol());
        v.assertNull(v.getUser());
        v.assertNull(v.getHostname());
        v.assertNull(v.getPassword());
        v.assertNull(v.getPort());
        v.assertNull(v.getFile());
        s = "http://user:pass@machine/the_file";
        if (!v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertEquals(v.getProtocol(), "http");
        v.assertEquals(v.getUser(), "user");
        v.assertEquals(v.getPassword(), "pass");
        v.assertEquals(v.getHostname(), "machine");
        v.assertNull(v.getPort());
        v.assertEquals(v.getFile(), "/the_file");
        s = "http://user:pass@machine:123/the_file";
        if (!v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertEquals(v.getProtocol(), "http");
        v.assertEquals(v.getUser(), "user");
        v.assertEquals(v.getPassword(), "pass");
        v.assertEquals(v.getHostname(), "machine");
        v.assertEquals(v.getPort(), "123");
        v.assertEquals(v.getFile(), "/the_file");
        s = "http://user:pass@machine:/the_file";
        if (v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertNull(v.getProtocol());
        v.assertNull(v.getUser());
        v.assertNull(v.getHostname());
        v.assertNull(v.getPassword());
        v.assertNull(v.getPort());
        v.assertNull(v.getFile());
        s = "http://user:pass:@machine/the_file";
        if (!v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertEquals(v.getProtocol(), "http");
        v.assertEquals(v.getUser(), "user");
        v.assertEquals(v.getPassword(), "pass:");
        v.assertEquals(v.getHostname(), "machine");
        v.assertNull(v.getPort());
        v.assertEquals(v.getFile(), "/the_file");
        s = "http://user:pass:@machine/the_dir/";
        if (!v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertEquals(v.getProtocol(), "http");
        v.assertEquals(v.getUser(), "user");
        v.assertEquals(v.getPassword(), "pass:");
        v.assertEquals(v.getHostname(), "machine");
        v.assertNull(v.getPort());
        v.assertEquals(v.getFile(), "/the_dir/");
        s = "http: //user:pass:@machine/the_file";
        if (v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertNull(v.getProtocol());
        v.assertNull(v.getUser());
        v.assertNull(v.getHostname());
        v.assertNull(v.getPassword());
        v.assertNull(v.getPort());
        v.assertNull(v.getFile());
        s = "http:/ /user:pass:@machine/the_file";
        if (v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertNull(v.getProtocol());
        v.assertNull(v.getUser());
        v.assertNull(v.getHostname());
        v.assertNull(v.getPassword());
        v.assertNull(v.getPort());
        v.assertNull(v.getFile());
        s = "http:/ /user:pass:@machine";
        if (v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertNull(v.getProtocol());
        v.assertNull(v.getUser());
        v.assertNull(v.getHostname());
        v.assertNull(v.getPassword());
        v.assertNull(v.getPort());
        v.assertNull(v.getFile());
        s = "http://user:pass:@:123/a";
        if (v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertNull(v.getProtocol());
        v.assertNull(v.getUser());
        v.assertNull(v.getHostname());
        v.assertNull(v.getPassword());
        v.assertNull(v.getPort());
        v.assertNull(v.getFile());
        s = "http://user:pass:@machine:a/the_file";
        if (v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertNull(v.getProtocol());
        v.assertNull(v.getUser());
        v.assertNull(v.getHostname());
        v.assertNull(v.getPassword());
        v.assertNull(v.getPort());
        v.assertNull(v.getFile());
        s = "HTTP://machine/the_file";
        if (!v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertEquals(v.getProtocol(), "HTTP");
        v.assertNull(v.getUser());
        v.assertNull(v.getPassword());
        v.assertEquals(v.getHostname(), "machine");
        v.assertNull(v.getPort());
        v.assertEquals(v.getFile(), "/the_file");
        s = "HTTP://machine:1/the_file";
        if (!v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertEquals(v.getProtocol(), "HTTP");
        v.assertNull(v.getUser());
        v.assertNull(v.getPassword());
        v.assertEquals(v.getHostname(), "machine");
        v.assertEquals(v.getPort(), "1");
        v.assertEquals(v.getFile(), "/the_file");
        s = "HTTP://machine:12345/the_file";
        if (!v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertEquals(v.getProtocol(), "HTTP");
        v.assertNull(v.getUser());
        v.assertNull(v.getPassword());
        v.assertEquals(v.getHostname(), "machine");
        v.assertEquals(v.getPort(), "12345");
        v.assertEquals(v.getFile(), "/the_file");
        s = "HTTP://machine:/the_file";
        if (v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertNull(v.getProtocol());
        v.assertNull(v.getUser());
        v.assertNull(v.getHostname());
        v.assertNull(v.getPassword());
        v.assertNull(v.getPort());
        v.assertNull(v.getFile());
        s = "HTTP://user:pass@machine/the_file";
        if (!v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertEquals(v.getProtocol(), "HTTP");
        v.assertEquals(v.getUser(), "user");
        v.assertEquals(v.getPassword(), "pass");
        v.assertEquals(v.getHostname(), "machine");
        v.assertNull(v.getPort());
        v.assertEquals(v.getFile(), "/the_file");
        s = "HTTP://user:pass@machine:123/the_file";
        if (!v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertEquals(v.getProtocol(), "HTTP");
        v.assertEquals(v.getUser(), "user");
        v.assertEquals(v.getPassword(), "pass");
        v.assertEquals(v.getHostname(), "machine");
        v.assertEquals(v.getPort(), "123");
        v.assertEquals(v.getFile(), "/the_file");
        s = "HTTP://user:pass@machine:/the_file";
        if (v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertNull(v.getProtocol());
        v.assertNull(v.getUser());
        v.assertNull(v.getHostname());
        v.assertNull(v.getPassword());
        v.assertNull(v.getPort());
        v.assertNull(v.getFile());
        s = "HTTP://user:pass:@machine/the_file";
        if (!v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertEquals(v.getProtocol(), "HTTP");
        v.assertEquals(v.getUser(), "user");
        v.assertEquals(v.getPassword(), "pass:");
        v.assertEquals(v.getHostname(), "machine");
        v.assertNull(v.getPort());
        v.assertEquals(v.getFile(), "/the_file");
        s = "HTTP://user:pass:@machine/the_dir/";
        if (!v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertEquals(v.getProtocol(), "HTTP");
        v.assertEquals(v.getUser(), "user");
        v.assertEquals(v.getPassword(), "pass:");
        v.assertEquals(v.getHostname(), "machine");
        v.assertNull(v.getPort());
        v.assertEquals(v.getFile(), "/the_dir/");
        s = "HTTP: //user:pass:@machine/the_file";
        if (v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertNull(v.getProtocol());
        v.assertNull(v.getUser());
        v.assertNull(v.getHostname());
        v.assertNull(v.getPassword());
        v.assertNull(v.getPort());
        v.assertNull(v.getFile());
        s = "HTTP:/ /user:pass:@machine/the_file";
        if (v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertNull(v.getProtocol());
        v.assertNull(v.getUser());
        v.assertNull(v.getHostname());
        v.assertNull(v.getPassword());
        v.assertNull(v.getPort());
        v.assertNull(v.getFile());
        s = "HTTP:/ /user:pass:@machine";
        if (v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertNull(v.getProtocol());
        v.assertNull(v.getUser());
        v.assertNull(v.getHostname());
        v.assertNull(v.getPassword());
        v.assertNull(v.getPort());
        v.assertNull(v.getFile());
        s = "HTTP://user:pass:@:123/a";
        if (v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertNull(v.getProtocol());
        v.assertNull(v.getUser());
        v.assertNull(v.getHostname());
        v.assertNull(v.getPassword());
        v.assertNull(v.getPort());
        v.assertNull(v.getFile());
        s = "HTTP://user:pass:@machine:a/the_file";
        if (v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertNull(v.getProtocol());
        v.assertNull(v.getUser());
        v.assertNull(v.getHostname());
        v.assertNull(v.getPassword());
        v.assertNull(v.getPort());
        v.assertNull(v.getFile());
        s = "https://machine/the_file";
        if (!v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertEquals(v.getProtocol(), "https");
        v.assertNull(v.getUser());
        v.assertNull(v.getPassword());
        v.assertEquals(v.getHostname(), "machine");
        v.assertNull(v.getPort());
        v.assertEquals(v.getFile(), "/the_file");
        s = "https://machine:1/the_file";
        if (!v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertEquals(v.getProtocol(), "https");
        v.assertNull(v.getUser());
        v.assertNull(v.getPassword());
        v.assertEquals(v.getHostname(), "machine");
        v.assertEquals(v.getPort(), "1");
        v.assertEquals(v.getFile(), "/the_file");
        s = "https://machine:12345/the_file";
        if (!v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertEquals(v.getProtocol(), "https");
        v.assertNull(v.getUser());
        v.assertNull(v.getPassword());
        v.assertEquals(v.getHostname(), "machine");
        v.assertEquals(v.getPort(), "12345");
        v.assertEquals(v.getFile(), "/the_file");
        s = "https://machine:/the_file";
        if (v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertNull(v.getProtocol());
        v.assertNull(v.getUser());
        v.assertNull(v.getHostname());
        v.assertNull(v.getPassword());
        v.assertNull(v.getPort());
        v.assertNull(v.getFile());
        s = "https://user:pass@machine/the_file";
        if (!v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertEquals(v.getProtocol(), "https");
        v.assertEquals(v.getUser(), "user");
        v.assertEquals(v.getPassword(), "pass");
        v.assertEquals(v.getHostname(), "machine");
        v.assertNull(v.getPort());
        v.assertEquals(v.getFile(), "/the_file");
        s = "https://user:pass@machine:123/the_file";
        if (!v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertEquals(v.getProtocol(), "https");
        v.assertEquals(v.getUser(), "user");
        v.assertEquals(v.getPassword(), "pass");
        v.assertEquals(v.getHostname(), "machine");
        v.assertEquals(v.getPort(), "123");
        v.assertEquals(v.getFile(), "/the_file");
        s = "https://user:pass@machine:/the_file";
        if (v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertNull(v.getProtocol());
        v.assertNull(v.getUser());
        v.assertNull(v.getHostname());
        v.assertNull(v.getPassword());
        v.assertNull(v.getPort());
        v.assertNull(v.getFile());
        s = "https://user:pass:@machine/the_file";
        if (!v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertEquals(v.getProtocol(), "https");
        v.assertEquals(v.getUser(), "user");
        v.assertEquals(v.getPassword(), "pass:");
        v.assertEquals(v.getHostname(), "machine");
        v.assertNull(v.getPort());
        v.assertEquals(v.getFile(), "/the_file");
        s = "https://user:pass:@machine/the_dir/";
        if (!v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertEquals(v.getProtocol(), "https");
        v.assertEquals(v.getUser(), "user");
        v.assertEquals(v.getPassword(), "pass:");
        v.assertEquals(v.getHostname(), "machine");
        v.assertNull(v.getPort());
        v.assertEquals(v.getFile(), "/the_dir/");
        s = "https: //user:pass:@machine/the_file";
        if (v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertNull(v.getProtocol());
        v.assertNull(v.getUser());
        v.assertNull(v.getHostname());
        v.assertNull(v.getPassword());
        v.assertNull(v.getPort());
        v.assertNull(v.getFile());
        s = "https:/ /user:pass:@machine/the_file";
        if (v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertNull(v.getProtocol());
        v.assertNull(v.getUser());
        v.assertNull(v.getHostname());
        v.assertNull(v.getPassword());
        v.assertNull(v.getPort());
        v.assertNull(v.getFile());
        s = "https:/ /user:pass:@machine";
        if (v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertNull(v.getProtocol());
        v.assertNull(v.getUser());
        v.assertNull(v.getHostname());
        v.assertNull(v.getPassword());
        v.assertNull(v.getPort());
        v.assertNull(v.getFile());
        s = "https://user:pass:@:123/a";
        if (v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertNull(v.getProtocol());
        v.assertNull(v.getUser());
        v.assertNull(v.getHostname());
        v.assertNull(v.getPassword());
        v.assertNull(v.getPort());
        v.assertNull(v.getFile());
        s = "https://user:pass:@machine:a/the_file";
        if (v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertNull(v.getProtocol());
        v.assertNull(v.getUser());
        v.assertNull(v.getHostname());
        v.assertNull(v.getPassword());
        v.assertNull(v.getPort());
        v.assertNull(v.getFile());
        s = "HTTPS://machine/the_file";
        if (!v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertEquals(v.getProtocol(), "HTTPS");
        v.assertNull(v.getUser());
        v.assertNull(v.getPassword());
        v.assertEquals(v.getHostname(), "machine");
        v.assertNull(v.getPort());
        v.assertEquals(v.getFile(), "/the_file");
        s = "HTTPS://machine:1/the_file";
        if (!v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertEquals(v.getProtocol(), "HTTPS");
        v.assertNull(v.getUser());
        v.assertNull(v.getPassword());
        v.assertEquals(v.getHostname(), "machine");
        v.assertEquals(v.getPort(), "1");
        v.assertEquals(v.getFile(), "/the_file");
        s = "HTTPS://machine:12345/the_file";
        if (!v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertEquals(v.getProtocol(), "HTTPS");
        v.assertNull(v.getUser());
        v.assertNull(v.getPassword());
        v.assertEquals(v.getHostname(), "machine");
        v.assertEquals(v.getPort(), "12345");
        v.assertEquals(v.getFile(), "/the_file");
        s = "HTTPS://machine:/the_file";
        if (v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertNull(v.getProtocol());
        v.assertNull(v.getUser());
        v.assertNull(v.getHostname());
        v.assertNull(v.getPassword());
        v.assertNull(v.getPort());
        v.assertNull(v.getFile());
        s = "HTTPS://user:pass@machine/the_file";
        if (!v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertEquals(v.getProtocol(), "HTTPS");
        v.assertEquals(v.getUser(), "user");
        v.assertEquals(v.getPassword(), "pass");
        v.assertEquals(v.getHostname(), "machine");
        v.assertNull(v.getPort());
        v.assertEquals(v.getFile(), "/the_file");
        s = "HTTPS://user:pass@machine:123/the_file";
        if (!v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertEquals(v.getProtocol(), "HTTPS");
        v.assertEquals(v.getUser(), "user");
        v.assertEquals(v.getPassword(), "pass");
        v.assertEquals(v.getHostname(), "machine");
        v.assertEquals(v.getPort(), "123");
        v.assertEquals(v.getFile(), "/the_file");
        s = "HTTPS://user:pass@machine:/the_file";
        if (v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertNull(v.getProtocol());
        v.assertNull(v.getUser());
        v.assertNull(v.getHostname());
        v.assertNull(v.getPassword());
        v.assertNull(v.getPort());
        v.assertNull(v.getFile());
        s = "HTTPS://user:pass:@machine/the_file";
        if (!v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertEquals(v.getProtocol(), "HTTPS");
        v.assertEquals(v.getUser(), "user");
        v.assertEquals(v.getPassword(), "pass:");
        v.assertEquals(v.getHostname(), "machine");
        v.assertNull(v.getPort());
        v.assertEquals(v.getFile(), "/the_file");
        s = "HTTPS://user:pass:@machine/the_dir/";
        if (!v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertEquals(v.getProtocol(), "HTTPS");
        v.assertEquals(v.getUser(), "user");
        v.assertEquals(v.getPassword(), "pass:");
        v.assertEquals(v.getHostname(), "machine");
        v.assertNull(v.getPort());
        v.assertEquals(v.getFile(), "/the_dir/");
        s = "HTTPS: //user:pass:@machine/the_file";
        if (v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertNull(v.getProtocol());
        v.assertNull(v.getUser());
        v.assertNull(v.getHostname());
        v.assertNull(v.getPassword());
        v.assertNull(v.getPort());
        v.assertNull(v.getFile());
        s = "HTTPS:/ /user:pass:@machine/the_file";
        if (v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertNull(v.getProtocol());
        v.assertNull(v.getUser());
        v.assertNull(v.getHostname());
        v.assertNull(v.getPassword());
        v.assertNull(v.getPort());
        v.assertNull(v.getFile());
        s = "HTTPS:/ /user:pass:@machine";
        if (v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertNull(v.getProtocol());
        v.assertNull(v.getUser());
        v.assertNull(v.getHostname());
        v.assertNull(v.getPassword());
        v.assertNull(v.getPort());
        v.assertNull(v.getFile());
        s = "HTTPS://user:pass:@:123/a";
        if (v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertNull(v.getProtocol());
        v.assertNull(v.getUser());
        v.assertNull(v.getHostname());
        v.assertNull(v.getPassword());
        v.assertNull(v.getPort());
        v.assertNull(v.getFile());
        s = "HTTPS://user:pass:@machine:a/the_file";
        if (v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertNull(v.getProtocol());
        v.assertNull(v.getUser());
        v.assertNull(v.getHostname());
        v.assertNull(v.getPassword());
        v.assertNull(v.getPort());
        v.assertNull(v.getFile());
        s = "webdav://machine/the_file";
        if (!v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertEquals(v.getProtocol(), "webdav");
        v.assertNull(v.getUser());
        v.assertNull(v.getPassword());
        v.assertEquals(v.getHostname(), "machine");
        v.assertNull(v.getPort());
        v.assertEquals(v.getFile(), "/the_file");
        s = "webdav://machine:1/the_file";
        if (!v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertEquals(v.getProtocol(), "webdav");
        v.assertNull(v.getUser());
        v.assertNull(v.getPassword());
        v.assertEquals(v.getHostname(), "machine");
        v.assertEquals(v.getPort(), "1");
        v.assertEquals(v.getFile(), "/the_file");
        s = "webdav://machine:12345/the_file";
        if (!v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertEquals(v.getProtocol(), "webdav");
        v.assertNull(v.getUser());
        v.assertNull(v.getPassword());
        v.assertEquals(v.getHostname(), "machine");
        v.assertEquals(v.getPort(), "12345");
        v.assertEquals(v.getFile(), "/the_file");
        s = "webdav://machine:/the_file";
        if (v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertNull(v.getProtocol());
        v.assertNull(v.getUser());
        v.assertNull(v.getHostname());
        v.assertNull(v.getPassword());
        v.assertNull(v.getPort());
        v.assertNull(v.getFile());
        s = "webdav://user:pass@machine/the_file";
        if (!v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertEquals(v.getProtocol(), "webdav");
        v.assertEquals(v.getUser(), "user");
        v.assertEquals(v.getPassword(), "pass");
        v.assertEquals(v.getHostname(), "machine");
        v.assertNull(v.getPort());
        v.assertEquals(v.getFile(), "/the_file");
        s = "webdav://user:pass@machine:123/the_file";
        if (!v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertEquals(v.getProtocol(), "webdav");
        v.assertEquals(v.getUser(), "user");
        v.assertEquals(v.getPassword(), "pass");
        v.assertEquals(v.getHostname(), "machine");
        v.assertEquals(v.getPort(), "123");
        v.assertEquals(v.getFile(), "/the_file");
        s = "webdav://user:pass@machine:/the_file";
        if (v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertNull(v.getProtocol());
        v.assertNull(v.getUser());
        v.assertNull(v.getHostname());
        v.assertNull(v.getPassword());
        v.assertNull(v.getPort());
        v.assertNull(v.getFile());
        s = "webdav://user:pass:@machine/the_file";
        if (!v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertEquals(v.getProtocol(), "webdav");
        v.assertEquals(v.getUser(), "user");
        v.assertEquals(v.getPassword(), "pass:");
        v.assertEquals(v.getHostname(), "machine");
        v.assertNull(v.getPort());
        v.assertEquals(v.getFile(), "/the_file");
        s = "webdav://user:pass:@machine/the_dir/";
        if (!v.isValid(s)) {
            v.error_msg(s);
        }
        if (v.isValid(s = "webdav: //user:pass:@machine/the_file")) {
            v.error_msg(s);
        }
        v.assertNull(v.getProtocol());
        v.assertNull(v.getUser());
        v.assertNull(v.getHostname());
        v.assertNull(v.getPassword());
        v.assertNull(v.getPort());
        v.assertNull(v.getFile());
        s = "webdav:/ /user:pass:@machine/the_file";
        if (v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertNull(v.getProtocol());
        v.assertNull(v.getUser());
        v.assertNull(v.getHostname());
        v.assertNull(v.getPassword());
        v.assertNull(v.getPort());
        v.assertNull(v.getFile());
        s = "webdav:/ /user:pass:@machine";
        if (v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertNull(v.getProtocol());
        v.assertNull(v.getUser());
        v.assertNull(v.getHostname());
        v.assertNull(v.getPassword());
        v.assertNull(v.getPort());
        v.assertNull(v.getFile());
        s = "webdav://user:pass:@:123/a";
        if (v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertNull(v.getProtocol());
        v.assertNull(v.getUser());
        v.assertNull(v.getHostname());
        v.assertNull(v.getPassword());
        v.assertNull(v.getPort());
        v.assertNull(v.getFile());
        s = "webdav://user:pass:@machine:a/the_file";
        if (v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertNull(v.getProtocol());
        v.assertNull(v.getUser());
        v.assertNull(v.getHostname());
        v.assertNull(v.getPassword());
        v.assertNull(v.getPort());
        v.assertNull(v.getFile());
        s = "WEBDAV://machine/the_file";
        if (!v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertEquals(v.getProtocol(), "WEBDAV");
        v.assertNull(v.getUser());
        v.assertNull(v.getPassword());
        v.assertEquals(v.getHostname(), "machine");
        v.assertNull(v.getPort());
        v.assertEquals(v.getFile(), "/the_file");
        s = "WEBDAV://machine:1/the_file";
        if (!v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertEquals(v.getProtocol(), "WEBDAV");
        v.assertNull(v.getUser());
        v.assertNull(v.getPassword());
        v.assertEquals(v.getHostname(), "machine");
        v.assertEquals(v.getPort(), "1");
        v.assertEquals(v.getFile(), "/the_file");
        s = "WEBDAV://machine:12345/the_file";
        if (!v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertEquals(v.getProtocol(), "WEBDAV");
        v.assertNull(v.getUser());
        v.assertNull(v.getPassword());
        v.assertEquals(v.getHostname(), "machine");
        v.assertEquals(v.getPort(), "12345");
        v.assertEquals(v.getFile(), "/the_file");
        s = "WEBDAV://machine:/the_file";
        if (v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertNull(v.getProtocol());
        v.assertNull(v.getUser());
        v.assertNull(v.getHostname());
        v.assertNull(v.getPassword());
        v.assertNull(v.getPort());
        v.assertNull(v.getFile());
        s = "WEBDAV://user:pass@machine/the_file";
        if (!v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertEquals(v.getProtocol(), "WEBDAV");
        v.assertEquals(v.getUser(), "user");
        v.assertEquals(v.getPassword(), "pass");
        v.assertEquals(v.getHostname(), "machine");
        v.assertNull(v.getPort());
        v.assertEquals(v.getFile(), "/the_file");
        s = "WEBDAV://user:pass@machine:123/the_file";
        if (!v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertEquals(v.getProtocol(), "WEBDAV");
        v.assertEquals(v.getUser(), "user");
        v.assertEquals(v.getPassword(), "pass");
        v.assertEquals(v.getHostname(), "machine");
        v.assertEquals(v.getPort(), "123");
        v.assertEquals(v.getFile(), "/the_file");
        s = "WEBDAV://user:pass@machine:/the_file";
        if (v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertNull(v.getProtocol());
        v.assertNull(v.getUser());
        v.assertNull(v.getHostname());
        v.assertNull(v.getPassword());
        v.assertNull(v.getPort());
        v.assertNull(v.getFile());
        s = "WEBDAV://user:pass:@machine/the_file";
        if (!v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertEquals(v.getProtocol(), "WEBDAV");
        v.assertEquals(v.getUser(), "user");
        v.assertEquals(v.getPassword(), "pass:");
        v.assertEquals(v.getHostname(), "machine");
        v.assertNull(v.getPort());
        v.assertEquals(v.getFile(), "/the_file");
        s = "WEBDAV://user:pass:@machine/the_dir/";
        if (!v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertEquals(v.getProtocol(), "WEBDAV");
        v.assertEquals(v.getUser(), "user");
        v.assertEquals(v.getPassword(), "pass:");
        v.assertEquals(v.getHostname(), "machine");
        v.assertNull(v.getPort());
        v.assertEquals(v.getFile(), "/the_dir/");
        s = "WEBDAV: //user:pass:@machine/the_file";
        if (v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertNull(v.getProtocol());
        v.assertNull(v.getUser());
        v.assertNull(v.getHostname());
        v.assertNull(v.getPassword());
        v.assertNull(v.getPort());
        v.assertNull(v.getFile());
        s = "WEBDAV:/ /user:pass:@machine/the_file";
        if (v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertNull(v.getProtocol());
        v.assertNull(v.getUser());
        v.assertNull(v.getHostname());
        v.assertNull(v.getPassword());
        v.assertNull(v.getPort());
        v.assertNull(v.getFile());
        s = "WEBDAV:/ /user:pass:@machine";
        if (v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertNull(v.getProtocol());
        v.assertNull(v.getUser());
        v.assertNull(v.getHostname());
        v.assertNull(v.getPassword());
        v.assertNull(v.getPort());
        v.assertNull(v.getFile());
        s = "WEBDAV://user:pass:@:123/a";
        if (v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertNull(v.getProtocol());
        v.assertNull(v.getUser());
        v.assertNull(v.getHostname());
        v.assertNull(v.getPassword());
        v.assertNull(v.getPort());
        v.assertNull(v.getFile());
        s = "WEBDAV://user:pass:@machine:a/the_file";
        if (v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertNull(v.getProtocol());
        v.assertNull(v.getUser());
        v.assertNull(v.getHostname());
        v.assertNull(v.getPassword());
        v.assertNull(v.getPort());
        v.assertNull(v.getFile());
        s = "smb://machine/the_file";
        if (!v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertEquals(v.getProtocol(), "smb");
        v.assertNull(v.getUser());
        v.assertNull(v.getPassword());
        v.assertEquals(v.getHostname(), "machine");
        v.assertNull(v.getPort());
        v.assertEquals(v.getFile(), "/the_file");
        s = "smb://machine:1/the_file";
        if (!v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertEquals(v.getProtocol(), "smb");
        v.assertNull(v.getUser());
        v.assertNull(v.getPassword());
        v.assertEquals(v.getHostname(), "machine");
        v.assertEquals(v.getPort(), "1");
        v.assertEquals(v.getFile(), "/the_file");
        s = "smb://machine:12345/the_file";
        if (!v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertEquals(v.getProtocol(), "smb");
        v.assertNull(v.getUser());
        v.assertNull(v.getPassword());
        v.assertEquals(v.getHostname(), "machine");
        v.assertEquals(v.getPort(), "12345");
        v.assertEquals(v.getFile(), "/the_file");
        s = "smb://machine:/the_file";
        if (v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertNull(v.getProtocol());
        v.assertNull(v.getUser());
        v.assertNull(v.getHostname());
        v.assertNull(v.getPassword());
        v.assertNull(v.getPort());
        v.assertNull(v.getFile());
        s = "smb://user:pass@machine/the_file";
        if (!v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertEquals(v.getProtocol(), "smb");
        v.assertEquals(v.getUser(), "user");
        v.assertEquals(v.getPassword(), "pass");
        v.assertEquals(v.getHostname(), "machine");
        v.assertNull(v.getPort());
        v.assertEquals(v.getFile(), "/the_file");
        s = "smb://user:pass@machine:123/the_file";
        if (!v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertEquals(v.getProtocol(), "smb");
        v.assertEquals(v.getUser(), "user");
        v.assertEquals(v.getPassword(), "pass");
        v.assertEquals(v.getHostname(), "machine");
        v.assertEquals(v.getPort(), "123");
        v.assertEquals(v.getFile(), "/the_file");
        s = "smb://user:pass@machine:/the_file";
        if (v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertNull(v.getProtocol());
        v.assertNull(v.getUser());
        v.assertNull(v.getHostname());
        v.assertNull(v.getPassword());
        v.assertNull(v.getPort());
        v.assertNull(v.getFile());
        s = "smb://user:pass:@machine/the_file";
        if (!v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertEquals(v.getProtocol(), "smb");
        v.assertEquals(v.getUser(), "user");
        v.assertEquals(v.getPassword(), "pass:");
        v.assertEquals(v.getHostname(), "machine");
        v.assertNull(v.getPort());
        v.assertEquals(v.getFile(), "/the_file");
        s = "smb://user:pass:@machine/the_dir/";
        if (!v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertEquals(v.getProtocol(), "smb");
        v.assertEquals(v.getUser(), "user");
        v.assertEquals(v.getPassword(), "pass:");
        v.assertEquals(v.getHostname(), "machine");
        v.assertNull(v.getPort());
        v.assertEquals(v.getFile(), "/the_dir/");
        s = "smb: //user:pass:@machine/the_file";
        if (v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertNull(v.getProtocol());
        v.assertNull(v.getUser());
        v.assertNull(v.getHostname());
        v.assertNull(v.getPassword());
        v.assertNull(v.getPort());
        v.assertNull(v.getFile());
        s = "smb:/ /user:pass:@machine/the_file";
        if (v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertNull(v.getProtocol());
        v.assertNull(v.getUser());
        v.assertNull(v.getHostname());
        v.assertNull(v.getPassword());
        v.assertNull(v.getPort());
        v.assertNull(v.getFile());
        s = "smb:/ /user:pass:@machine";
        if (v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertNull(v.getProtocol());
        v.assertNull(v.getUser());
        v.assertNull(v.getHostname());
        v.assertNull(v.getPassword());
        v.assertNull(v.getPort());
        v.assertNull(v.getFile());
        s = "smb://user:pass:@:123/a";
        if (v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertNull(v.getProtocol());
        v.assertNull(v.getUser());
        v.assertNull(v.getHostname());
        v.assertNull(v.getPassword());
        v.assertNull(v.getPort());
        v.assertNull(v.getFile());
        s = "smb://user:pass:@machine:a/the_file";
        if (v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertNull(v.getProtocol());
        v.assertNull(v.getUser());
        v.assertNull(v.getHostname());
        v.assertNull(v.getPassword());
        v.assertNull(v.getPort());
        v.assertNull(v.getFile());
        s = "SMB://machine/the_file";
        if (!v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertEquals(v.getProtocol(), "SMB");
        v.assertNull(v.getUser());
        v.assertNull(v.getPassword());
        v.assertEquals(v.getHostname(), "machine");
        v.assertNull(v.getPort());
        v.assertEquals(v.getFile(), "/the_file");
        s = "SMB://machine:1/the_file";
        if (!v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertEquals(v.getProtocol(), "SMB");
        v.assertNull(v.getUser());
        v.assertNull(v.getPassword());
        v.assertEquals(v.getHostname(), "machine");
        v.assertEquals(v.getPort(), "1");
        v.assertEquals(v.getFile(), "/the_file");
        s = "SMB://machine:12345/the_file";
        if (!v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertEquals(v.getProtocol(), "SMB");
        v.assertNull(v.getUser());
        v.assertNull(v.getPassword());
        v.assertEquals(v.getHostname(), "machine");
        v.assertEquals(v.getPort(), "12345");
        v.assertEquals(v.getFile(), "/the_file");
        s = "SMB://machine:/the_file";
        if (v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertNull(v.getProtocol());
        v.assertNull(v.getUser());
        v.assertNull(v.getHostname());
        v.assertNull(v.getPassword());
        v.assertNull(v.getPort());
        v.assertNull(v.getFile());
        s = "SMB://user:pass@machine/the_file";
        if (!v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertEquals(v.getProtocol(), "SMB");
        v.assertEquals(v.getUser(), "user");
        v.assertEquals(v.getPassword(), "pass");
        v.assertEquals(v.getHostname(), "machine");
        v.assertNull(v.getPort());
        v.assertEquals(v.getFile(), "/the_file");
        s = "SMB://user:pass@machine:123/the_file";
        if (!v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertEquals(v.getProtocol(), "SMB");
        v.assertEquals(v.getUser(), "user");
        v.assertEquals(v.getPassword(), "pass");
        v.assertEquals(v.getHostname(), "machine");
        v.assertEquals(v.getPort(), "123");
        v.assertEquals(v.getFile(), "/the_file");
        s = "SMB://user:pass@machine:/the_file";
        if (v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertNull(v.getProtocol());
        v.assertNull(v.getUser());
        v.assertNull(v.getHostname());
        v.assertNull(v.getPassword());
        v.assertNull(v.getPort());
        v.assertNull(v.getFile());
        s = "SMB://user:pass:@machine/the_file";
        if (!v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertEquals(v.getProtocol(), "SMB");
        v.assertEquals(v.getUser(), "user");
        v.assertEquals(v.getPassword(), "pass:");
        v.assertEquals(v.getHostname(), "machine");
        v.assertNull(v.getPort());
        v.assertEquals(v.getFile(), "/the_file");
        s = "SMB://user:pass:@machine/the_dir/";
        if (!v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertEquals(v.getProtocol(), "SMB");
        v.assertEquals(v.getUser(), "user");
        v.assertEquals(v.getPassword(), "pass:");
        v.assertEquals(v.getHostname(), "machine");
        v.assertNull(v.getPort());
        v.assertEquals(v.getFile(), "/the_dir/");
        s = "SMB: //user:pass:@machine/the_file";
        if (v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertNull(v.getProtocol());
        v.assertNull(v.getUser());
        v.assertNull(v.getHostname());
        v.assertNull(v.getPassword());
        v.assertNull(v.getPort());
        v.assertNull(v.getFile());
        s = "SMB:/ /user:pass:@machine/the_file";
        if (v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertNull(v.getProtocol());
        v.assertNull(v.getUser());
        v.assertNull(v.getHostname());
        v.assertNull(v.getPassword());
        v.assertNull(v.getPort());
        v.assertNull(v.getFile());
        s = "SMB:/ /user:pass:@machine";
        if (v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertNull(v.getProtocol());
        v.assertNull(v.getUser());
        v.assertNull(v.getHostname());
        v.assertNull(v.getPassword());
        v.assertNull(v.getPort());
        v.assertNull(v.getFile());
        s = "SMB://user:pass:@:123/a";
        if (v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertNull(v.getProtocol());
        v.assertNull(v.getUser());
        v.assertNull(v.getHostname());
        v.assertNull(v.getPassword());
        v.assertNull(v.getPort());
        v.assertNull(v.getFile());
        s = "SMB://user:pass:@machine:a/the_file";
        if (v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertNull(v.getProtocol());
        v.assertNull(v.getUser());
        v.assertNull(v.getHostname());
        v.assertNull(v.getPassword());
        v.assertNull(v.getPort());
        v.assertNull(v.getFile());
        s = "sftp://shell.sf.net";
        if (!v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertEquals(v.getProtocol(), "sftp");
        v.assertNull(v.getUser());
        v.assertNull(v.getPassword());
        v.assertEquals(v.getHostname(), "shell.sf.net");
        v.assertNull(v.getPort());
        v.assertNull(v.getFile());
        s = "file:///C:/home/birdman";
        if (!v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertEquals(v.getProtocol(), "file");
        v.assertNull(v.getUser());
        v.assertNull(v.getPassword());
        v.assertNull(v.getHostname());
        v.assertNull(v.getPort());
        v.assertEquals(v.getFile(), "C:/home/birdman");
        s = "file:///home/birdman";
        if (!v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertEquals(v.getProtocol(), "file");
        v.assertNull(v.getUser());
        v.assertNull(v.getPassword());
        v.assertNull(v.getHostname());
        v.assertNull(v.getPort());
        v.assertEquals(v.getFile(), "/home/birdman");
        s = "file://home/birdman";
        if (!v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertEquals(v.getProtocol(), "file");
        v.assertNull(v.getUser());
        v.assertNull(v.getPassword());
        v.assertNull(v.getHostname());
        v.assertNull(v.getPort());
        v.assertEquals(v.getFile(), "home/birdman");
        s = "webdav://myserver.net/home/yves";
        if (!v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertEquals(v.getProtocol(), "webdav");
        v.assertNull(v.getUser());
        v.assertNull(v.getPassword());
        v.assertEquals(v.getHostname(), "myserver.net");
        v.assertNull(v.getPort());
        v.assertEquals(v.getFile(), "/home/yves");
        s = "ftp://ftp.ca.freebsd.org";
        if (!v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertEquals(v.getProtocol(), "ftp");
        v.assertNull(v.getUser());
        v.assertNull(v.getPassword());
        v.assertEquals(v.getHostname(), "ftp.ca.freebsd.org");
        v.assertNull(v.getPort());
        v.assertNull(v.getFile());
        s = "sftp://yves@shell.sf.net:28";
        if (!v.isValid(s)) {
            v.error_msg(s);
        }
        v.assertEquals(v.getProtocol(), "sftp");
        v.assertEquals(v.getUser(), "yves");
        v.assertNull(v.getPassword());
        v.assertEquals(v.getHostname(), "shell.sf.net");
        v.assertEquals(v.getPort(), "28");
        v.assertNull(v.getFile());
        System.out.println("all done");
    }
}

