/*
 * Decompiled with CFR 0.152.
 */
package com.github.markusbernhardt.proxy.search.browser;

import com.github.markusbernhardt.proxy.TestUtil;
import com.github.markusbernhardt.proxy.search.browser.ie.IELocalByPassFilter;
import com.github.markusbernhardt.proxy.search.desktop.win.WinProxyConfig;
import com.github.markusbernhardt.proxy.search.desktop.win.WinProxySearchStrategy;
import com.github.markusbernhardt.proxy.util.ProxyException;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.EnabledIf;
import org.junit.jupiter.api.condition.EnabledOnOs;
import org.junit.jupiter.api.condition.OS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IeTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(IeTest.class);

    @Test
    @EnabledOnOs(value={OS.WINDOWS})
    public void testInvoke() {
        WinProxySearchStrategy st = new WinProxySearchStrategy();
        Assertions.assertThatCode(() -> st.getProxySelector()).doesNotThrowAnyException();
    }

    @Test
    @EnabledOnOs(value={OS.WINDOWS})
    @EnabledIf(value="isWinHttpProxyConfigured")
    public void testWinHttpProxy() throws ProxyException {
        WinProxySearchStrategy st = new WinProxySearchStrategy();
        ProxySelector ps = st.getProxySelector();
        List<Proxy> result = ps.select(TestUtil.HTTPS_TEST_URI);
        org.junit.jupiter.api.Assertions.assertEquals((Object)Proxy.NO_PROXY, (Object)result.get(0));
    }

    boolean isWinHttpProxyConfigured() {
        WinProxySearchStrategy st = new WinProxySearchStrategy();
        WinProxyConfig windowsProxyConfig = st.readWindowsProxyConfig();
        boolean isWinHttpProxyConfigured = windowsProxyConfig.getAccessType() != 1;
        LOGGER.info("WinHttp proxy configured: {}", (Object)isWinHttpProxyConfigured);
        return isWinHttpProxyConfigured;
    }

    @Test
    public void testLocalByPassFilter() throws ProxyException, MalformedURLException, URISyntaxException {
        IELocalByPassFilter filter = new IELocalByPassFilter();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)filter.accept(TestUtil.LOCAL_TEST_URI));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)filter.accept(TestUtil.HTTP_TEST_URI));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)filter.accept(new URL("http://123.45.55.6").toURI()));
    }
}

