/*
 * Decompiled with CFR 0.152.
 */
package com.github.markusbernhardt.proxy.search.gnome;

import com.github.markusbernhardt.proxy.TestUtil;
import com.github.markusbernhardt.proxy.search.desktop.gnome.GnomeProxySearchStrategy;
import com.github.markusbernhardt.proxy.util.ProxyException;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URISyntaxException;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class GnomeProxySearchTest {
    @Test
    public void testNone() throws ProxyException {
        TestUtil.setTestDataFolder("gnome_none");
        ProxySelector ps = new GnomeProxySearchStrategy().getProxySelector();
        List<Proxy> result = ps.select(TestUtil.HTTP_TEST_URI);
        Assertions.assertEquals((Object)Proxy.NO_PROXY, (Object)result.get(0));
    }

    @Test
    public void testManualHttp() throws ProxyException, URISyntaxException {
        TestUtil.setTestDataFolder("gnome_manual");
        ProxySelector ps = new GnomeProxySearchStrategy().getProxySelector();
        List<Proxy> result = ps.select(TestUtil.HTTP_TEST_URI);
        Assertions.assertEquals((Object)TestUtil.HTTP_TEST_PROXY, (Object)result.get(0));
    }

    @Test
    public void testManualHttps() throws ProxyException, URISyntaxException {
        TestUtil.setTestDataFolder("gnome_manual");
        ProxySelector ps = new GnomeProxySearchStrategy().getProxySelector();
        List<Proxy> result = ps.select(TestUtil.HTTPS_TEST_URI);
        Assertions.assertEquals((Object)TestUtil.HTTPS_TEST_PROXY, (Object)result.get(0));
    }

    @Test
    public void testManualFtp() throws ProxyException, URISyntaxException {
        TestUtil.setTestDataFolder("gnome_manual");
        ProxySelector ps = new GnomeProxySearchStrategy().getProxySelector();
        List<Proxy> result = ps.select(TestUtil.FTP_TEST_URI);
        Assertions.assertEquals((Object)TestUtil.FTP_TEST_PROXY, (Object)result.get(0));
    }

    @Test
    public void testPac() throws ProxyException, URISyntaxException {
        TestUtil.setTestDataFolder("gnome_pac_script");
        ProxySelector ps = new GnomeProxySearchStrategy().getProxySelector();
        List<Proxy> result = ps.select(TestUtil.HTTP_TEST_URI);
        Assertions.assertEquals((Object)TestUtil.HTTP_TEST_PROXY, (Object)result.get(0));
    }

    @Test
    public void testWhiteList() throws ProxyException, URISyntaxException {
        TestUtil.setTestDataFolder("gnome_white_list");
        ProxySelector ps = new GnomeProxySearchStrategy().getProxySelector();
        List<Proxy> result = ps.select(TestUtil.NO_PROXY_TEST_URI);
        Assertions.assertEquals((Object)Proxy.NO_PROXY, (Object)result.get(0));
    }
}

