/*
 * Decompiled with CFR 0.152.
 */
package com.github.markusbernhardt.proxy.search.browser;

import com.github.markusbernhardt.proxy.TestUtil;
import com.github.markusbernhardt.proxy.search.browser.firefox.FirefoxProxySearchStrategy;
import com.github.markusbernhardt.proxy.util.ProxyException;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URISyntaxException;
import java.util.List;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class FirefoxTest {
    private static String orgOS;

    @BeforeAll
    public static void setup() {
        orgOS = System.setProperty("os.name", "Linux");
    }

    @AfterAll
    public static void cleanup() {
        System.setProperty("os.name", orgOS);
    }

    @Test
    public void testNone() throws ProxyException {
        TestUtil.setTestDataFolder("ff3_none");
        FirefoxProxySearchStrategy ff = new FirefoxProxySearchStrategy();
        ProxySelector ps = ff.getProxySelector();
        List<Proxy> result = ps.select(TestUtil.HTTPS_TEST_URI);
        Assertions.assertEquals((Object)Proxy.NO_PROXY, (Object)result.get(0));
    }

    @Test
    public void testManualHttp() throws ProxyException, URISyntaxException {
        TestUtil.setTestDataFolder("ff3_manual");
        ProxySelector ps = new FirefoxProxySearchStrategy().getProxySelector();
        List<Proxy> result = ps.select(TestUtil.HTTP_TEST_URI);
        Assertions.assertEquals((Object)TestUtil.HTTP_TEST_PROXY, (Object)result.get(0));
    }

    @Test
    public void testManualHttps() throws ProxyException, URISyntaxException {
        TestUtil.setTestDataFolder("ff3_manual");
        ProxySelector ps = new FirefoxProxySearchStrategy().getProxySelector();
        List<Proxy> result = ps.select(TestUtil.HTTPS_TEST_URI);
        Assertions.assertEquals((Object)TestUtil.HTTPS_TEST_PROXY, (Object)result.get(0));
    }

    @Test
    public void testManualFtp() throws ProxyException, URISyntaxException {
        TestUtil.setTestDataFolder("ff3_manual");
        ProxySelector ps = new FirefoxProxySearchStrategy().getProxySelector();
        List<Proxy> result = ps.select(TestUtil.FTP_TEST_URI);
        Assertions.assertEquals((Object)TestUtil.FTP_TEST_PROXY, (Object)result.get(0));
    }

    @Test
    public void testManualSocks() throws ProxyException, URISyntaxException {
        TestUtil.setTestDataFolder("ff3_manual");
        ProxySelector ps = new FirefoxProxySearchStrategy().getProxySelector();
        List<Proxy> result = ps.select(TestUtil.SOCKS_TEST_URI);
        Assertions.assertEquals((Object)TestUtil.SOCKS_TEST_PROXY, (Object)result.get(0));
    }

    @Test
    public void testPac() throws ProxyException, URISyntaxException {
        TestUtil.setTestDataFolder("ff3_pac_script");
        ProxySelector ps = new FirefoxProxySearchStrategy().getProxySelector();
        List<Proxy> result = ps.select(TestUtil.HTTP_TEST_URI);
        Assertions.assertEquals((Object)TestUtil.HTTP_TEST_PROXY, (Object)result.get(0));
    }

    @Test
    public void testWhiteList() throws ProxyException, URISyntaxException {
        TestUtil.setTestDataFolder("ff3_white_list");
        ProxySelector ps = new FirefoxProxySearchStrategy().getProxySelector();
        List<Proxy> result = ps.select(TestUtil.NO_PROXY_TEST_URI);
        Assertions.assertEquals((Object)Proxy.NO_PROXY, (Object)result.get(0));
    }

    @Test
    public void testManualHttpFF67() throws ProxyException, URISyntaxException {
        TestUtil.setTestDataFolder("ff67_manual");
        ProxySelector ps = new FirefoxProxySearchStrategy().getProxySelector();
        List<Proxy> result = ps.select(TestUtil.HTTP_TEST_URI);
        Assertions.assertEquals((Object)TestUtil.HTTP_TEST_PROXY, (Object)result.get(0));
    }
}

