/*
 * Decompiled with CFR 0.152.
 */
package com.github.markusbernhardt.proxy.selector.pac;

import com.github.markusbernhardt.proxy.TestUtil;
import com.github.markusbernhardt.proxy.selector.pac.PacProxySelector;
import com.github.markusbernhardt.proxy.selector.pac.PacScriptSource;
import com.github.markusbernhardt.proxy.selector.pac.UrlPacScriptSource;
import com.github.markusbernhardt.proxy.util.ProxyException;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class PacProxySelectorTest {
    @Test
    public void testScriptExecution() throws ProxyException, MalformedURLException {
        List result = new PacProxySelector((PacScriptSource)new UrlPacScriptSource(this.toUrl("test1.pac"))).select(TestUtil.HTTP_TEST_URI);
        Assertions.assertEquals((Object)TestUtil.HTTP_TEST_PROXY, result.get(0));
    }

    @Test
    public void testScriptExecution2() throws ProxyException, MalformedURLException {
        PacProxySelector pacProxySelector = new PacProxySelector((PacScriptSource)new UrlPacScriptSource(this.toUrl("test2.pac")));
        List result = pacProxySelector.select(TestUtil.HTTP_TEST_URI);
        Assertions.assertEquals((Object)Proxy.NO_PROXY, result.get(0));
        result = pacProxySelector.select(TestUtil.HTTPS_TEST_URI);
        Assertions.assertEquals((Object)Proxy.NO_PROXY, result.get(0));
    }

    @Test
    public void pacDownloadFromURLShouldNotUseProxy() throws ProxyException, MalformedURLException {
        ProxySelector oldOne = ProxySelector.getDefault();
        try {
            ProxySelector.setDefault(new ProxySelector(){

                @Override
                public List<Proxy> select(URI uri) {
                    throw new IllegalStateException("Should not download via proxy");
                }

                @Override
                public void connectFailed(URI uri, SocketAddress sa, IOException ioe) {
                }
            });
            PacProxySelector pacProxySelector = new PacProxySelector((PacScriptSource)new UrlPacScriptSource("http://www.test.invalid/wpad.pac"));
            pacProxySelector.select(TestUtil.HTTPS_TEST_URI);
        }
        finally {
            ProxySelector.setDefault(oldOne);
        }
    }

    @Test
    public void testScriptMuliProxy() throws ProxyException, MalformedURLException {
        PacProxySelector pacProxySelector = new PacProxySelector((PacScriptSource)new UrlPacScriptSource(this.toUrl("testMultiProxy.pac")));
        List result = pacProxySelector.select(TestUtil.HTTP_TEST_URI);
        Assertions.assertEquals((int)4, (int)result.size());
        Assertions.assertEquals((Object)new Proxy(Proxy.Type.HTTP, InetSocketAddress.createUnresolved("my-proxy.com", 80)), result.get(0));
        Assertions.assertEquals((Object)new Proxy(Proxy.Type.HTTP, InetSocketAddress.createUnresolved("my-proxy2.com", 8080)), result.get(1));
        Assertions.assertEquals((Object)new Proxy(Proxy.Type.HTTP, InetSocketAddress.createUnresolved("my-proxy3.com", 8080)), result.get(2));
        Assertions.assertEquals((Object)new Proxy(Proxy.Type.HTTP, InetSocketAddress.createUnresolved("my-proxy4.com", 80)), result.get(3));
    }

    @Test
    public void testScriptProxyTypes() throws ProxyException, MalformedURLException {
        PacProxySelector pacProxySelector = new PacProxySelector((PacScriptSource)new UrlPacScriptSource(this.toUrl("testProxyTypes.pac")));
        List result = pacProxySelector.select(TestUtil.HTTP_TEST_URI);
        Assertions.assertEquals((int)6, (int)result.size());
        Assertions.assertEquals((Object)new Proxy(Proxy.Type.HTTP, InetSocketAddress.createUnresolved("my-proxy.com", 80)), result.get(0));
        Assertions.assertEquals((Object)new Proxy(Proxy.Type.HTTP, InetSocketAddress.createUnresolved("my-proxy2.com", 80)), result.get(1));
        Assertions.assertEquals((Object)new Proxy(Proxy.Type.HTTP, InetSocketAddress.createUnresolved("my-proxy3.com", 486)), result.get(2));
        Assertions.assertEquals((Object)new Proxy(Proxy.Type.SOCKS, InetSocketAddress.createUnresolved("my-proxy4.com", 80)), result.get(3));
        Assertions.assertEquals((Object)new Proxy(Proxy.Type.SOCKS, InetSocketAddress.createUnresolved("my-proxy5.com", 80)), result.get(4));
        Assertions.assertEquals((Object)new Proxy(Proxy.Type.SOCKS, InetSocketAddress.createUnresolved("my-proxy6.com", 80)), result.get(5));
    }

    @Test
    public void testLocalIPOverride() throws ProxyException, MalformedURLException {
        System.setProperty("com.btr.proxy.pac.overrideLocalIP", "123.123.123.123");
        try {
            PacProxySelector pacProxySelector = new PacProxySelector((PacScriptSource)new UrlPacScriptSource(this.toUrl("testLocalIP.pac")));
            List result = pacProxySelector.select(TestUtil.HTTP_TEST_URI);
            Assertions.assertEquals(result.get(0), (Object)new Proxy(Proxy.Type.HTTP, InetSocketAddress.createUnresolved("123.123.123.123", 8080)));
        }
        finally {
            System.setProperty("com.btr.proxy.pac.overrideLocalIP", "");
        }
    }

    private String toUrl(String testFile) throws MalformedURLException {
        return new File(TestUtil.TEST_DATA_FOLDER + "pac", testFile).toURI().toURL().toString();
    }
}

