/*
 * Decompiled with CFR 0.152.
 */
package com.github.markusbernhardt.proxy.selector.misc;

import com.github.markusbernhardt.proxy.TestUtil;
import com.github.markusbernhardt.proxy.selector.fixed.FixedProxySelector;
import com.github.markusbernhardt.proxy.selector.misc.ProtocolDispatchSelector;
import java.net.ProxySelector;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class ProtocolDispatchTest {
    private static ProtocolDispatchSelector ps;

    @BeforeAll
    public static void setup() {
        ps = new ProtocolDispatchSelector();
        ps.setSelector("http", (ProxySelector)new FixedProxySelector(TestUtil.HTTP_TEST_PROXY));
        ps.setSelector("https", (ProxySelector)new FixedProxySelector(TestUtil.HTTPS_TEST_PROXY));
        ps.setSelector("ftp", (ProxySelector)new FixedProxySelector(TestUtil.FTP_TEST_PROXY));
    }

    @Test
    public void testDispatchHttp() {
        List result = ps.select(TestUtil.HTTP_TEST_URI);
        Assertions.assertEquals((Object)TestUtil.HTTP_TEST_PROXY, result.get(0));
    }

    @Test
    public void testDispatchHttps() {
        List result = ps.select(TestUtil.HTTPS_TEST_URI);
        Assertions.assertEquals((Object)TestUtil.HTTPS_TEST_PROXY, result.get(0));
    }

    @Test
    public void testDispatchFtp() {
        List result = ps.select(TestUtil.FTP_TEST_URI);
        Assertions.assertEquals((Object)TestUtil.FTP_TEST_PROXY, result.get(0));
    }

    @Test
    public void testRemove() {
        ProtocolDispatchSelector px = new ProtocolDispatchSelector();
        FixedProxySelector selector = new FixedProxySelector(TestUtil.HTTP_TEST_PROXY);
        px.setSelector("http", (ProxySelector)selector);
        Assertions.assertEquals((Object)selector, (Object)px.getSelector("http"));
        px.removeSelector("http");
        Assertions.assertNull((Object)px.getSelector("http"));
    }

    @Test
    public void testFallback() {
        ProtocolDispatchSelector px = new ProtocolDispatchSelector();
        FixedProxySelector selector = new FixedProxySelector(TestUtil.HTTP_TEST_PROXY);
        px.setFallbackSelector((ProxySelector)selector);
        List proxies = px.select(TestUtil.HTTP_TEST_URI);
        Assertions.assertEquals((Object)TestUtil.HTTP_TEST_PROXY, proxies.get(0));
    }
}

