/*
 * Decompiled with CFR 0.152.
 */
package com.github.markusbernhardt.proxy.selector.misc;

import com.github.markusbernhardt.proxy.TestUtil;
import com.github.markusbernhardt.proxy.selector.misc.ProxyListFallbackSelector;
import java.io.IOException;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class ProxyListFallbackSelectorTest {
    private ProxyListFallbackSelector selector;

    @BeforeAll
    public void setup() {
        this.selector = new ProxyListFallbackSelector(new ProxySelector(){

            @Override
            public List<Proxy> select(URI uri) {
                return Arrays.asList(TestUtil.HTTP_TEST_PROXY, TestUtil.HTTPS_TEST_PROXY);
            }

            @Override
            public void connectFailed(URI uri, SocketAddress sa, IOException ioe) {
            }
        });
    }

    @Test
    public void testList() {
        List result = this.selector.select(TestUtil.HTTP_TEST_URI);
        Assertions.assertEquals((int)2, (int)result.size());
        Assertions.assertEquals((Object)TestUtil.HTTP_TEST_PROXY, result.get(0));
        Assertions.assertEquals((Object)TestUtil.HTTPS_TEST_PROXY, result.get(1));
    }

    @Test
    public void testFailedProxy() {
        this.selector.connectFailed(TestUtil.HTTP_TEST_URI, TestUtil.HTTP_TEST_PROXY.address(), new IOException("TEST"));
        List result = this.selector.select(TestUtil.HTTP_TEST_URI);
        Assertions.assertEquals((int)1, (int)result.size());
        Assertions.assertEquals((Object)TestUtil.HTTPS_TEST_PROXY, result.get(0));
    }

    @Test
    public void testFailedProxyRetry() throws InterruptedException {
        this.selector.setRetryAfterMs(100L);
        this.selector.connectFailed(TestUtil.HTTP_TEST_URI, TestUtil.HTTP_TEST_PROXY.address(), new IOException("TEST"));
        List result = this.selector.select(TestUtil.HTTP_TEST_URI);
        Assertions.assertEquals((int)1, (int)result.size());
        Assertions.assertEquals((Object)TestUtil.HTTPS_TEST_PROXY, result.get(0));
        Thread.sleep(200L);
        result = this.selector.select(TestUtil.HTTP_TEST_URI);
        Assertions.assertEquals((int)2, (int)result.size());
        Assertions.assertEquals((Object)TestUtil.HTTP_TEST_PROXY, result.get(0));
        Assertions.assertEquals((Object)TestUtil.HTTPS_TEST_PROXY, result.get(1));
    }

    @Test
    public void testFailedProxyFallbackToNoProxy() throws InterruptedException {
        this.selector.setRetryAfterMs(100L);
        this.selector.connectFailed(TestUtil.HTTP_TEST_URI, TestUtil.HTTP_TEST_PROXY.address(), new IOException("TEST"));
        List result = this.selector.select(TestUtil.HTTP_TEST_URI);
        Assertions.assertEquals((int)1, (int)result.size());
        Assertions.assertEquals((Object)TestUtil.HTTPS_TEST_PROXY, result.get(0));
        this.selector.connectFailed(TestUtil.HTTPS_TEST_URI, TestUtil.HTTPS_TEST_PROXY.address(), new IOException("TEST"));
        result = this.selector.select(TestUtil.HTTP_TEST_URI);
        Assertions.assertEquals((int)1, (int)result.size());
        Assertions.assertEquals((Object)Proxy.NO_PROXY, result.get(0));
        Thread.sleep(200L);
        result = this.selector.select(TestUtil.HTTP_TEST_URI);
        Assertions.assertEquals((int)2, (int)result.size());
        Assertions.assertEquals((Object)TestUtil.HTTP_TEST_PROXY, result.get(0));
        Assertions.assertEquals((Object)TestUtil.HTTPS_TEST_PROXY, result.get(1));
    }
}

