/*
 * Decompiled with CFR 0.152.
 */
package com.github.markusbernhardt.proxy.util;

import com.github.markusbernhardt.proxy.TestUtil;
import com.github.markusbernhardt.proxy.selector.whitelist.HostnameFilter;
import com.github.markusbernhardt.proxy.selector.whitelist.IpRangeFilter;
import java.net.URI;
import java.net.URISyntaxException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class UriFilterTest {
    @Test
    public void testBeginsWithFilter1() {
        HostnameFilter filter = new HostnameFilter(HostnameFilter.Mode.BEGINS_WITH, "no_proxy");
        Assertions.assertTrue((boolean)filter.accept(TestUtil.NO_PROXY_TEST_URI));
    }

    @Test
    public void testBeginsWithFilter2() {
        HostnameFilter filter = new HostnameFilter(HostnameFilter.Mode.BEGINS_WITH, "no_proxy");
        Assertions.assertFalse((boolean)filter.accept(TestUtil.HTTP_TEST_URI));
    }

    @Test
    public void testBeginsWithFilter3() throws URISyntaxException {
        HostnameFilter filter = new HostnameFilter(HostnameFilter.Mode.BEGINS_WITH, "192.168.0");
        Assertions.assertTrue((boolean)filter.accept(new URI("http://192.168.0.100:81/test.data")));
    }

    @Test
    public void testBeginsWithFilter4() throws URISyntaxException {
        HostnameFilter filter = new HostnameFilter(HostnameFilter.Mode.BEGINS_WITH, "192.168.0");
        Assertions.assertFalse((boolean)filter.accept(new URI("http://192.168.1.100:81/test.data")));
    }

    @Test
    public void testBeginsWithFilter() {
        HostnameFilter filter = new HostnameFilter(HostnameFilter.Mode.BEGINS_WITH, "no_proxy");
        Assertions.assertTrue((boolean)filter.accept(TestUtil.NO_PROXY_TEST_URI));
        Assertions.assertFalse((boolean)filter.accept(TestUtil.HTTP_TEST_URI));
    }

    @Test
    public void testEndsWithFilter() throws URISyntaxException {
        HostnameFilter filter = new HostnameFilter(HostnameFilter.Mode.ENDS_WITH, ".unit-test.invalid");
        Assertions.assertTrue((boolean)filter.accept(TestUtil.NO_PROXY_TEST_URI));
    }

    @Test
    public void testEndsWithFilter2() throws URISyntaxException {
        HostnameFilter filter = new HostnameFilter(HostnameFilter.Mode.ENDS_WITH, ".unit-test.invalid");
        Assertions.assertFalse((boolean)filter.accept(new URI("http://test.no-host.invalid:81/test.data")));
    }

    @Test
    public void testEndsWithFilter3() throws URISyntaxException {
        HostnameFilter filter = new HostnameFilter(HostnameFilter.Mode.ENDS_WITH, ".100");
        Assertions.assertTrue((boolean)filter.accept(new URI("http://192.168.1.100:81/test.data")));
    }

    @Test
    public void testIpRangeFilter() throws URISyntaxException {
        IpRangeFilter filter = new IpRangeFilter("192.168.0.0/24");
        Assertions.assertTrue((boolean)filter.accept(new URI("http://192.168.0.100:81/test.data")));
        Assertions.assertFalse((boolean)filter.accept(new URI("http://192.168.1.100:81/test.data")));
    }

    @Test
    public void testIp6RangeFilter() throws URISyntaxException {
        IpRangeFilter filter = new IpRangeFilter("2001:4860:0:2001::/24");
        Assertions.assertTrue((boolean)filter.accept(new URI("http://[2001:4860:0:2001::68]:81/test.data")));
        Assertions.assertFalse((boolean)filter.accept(new URI("http://[3001:4860:0:2001::68]:81/test.data")));
    }

    @Test
    public void testWithProtocolFilter() throws URISyntaxException {
        HostnameFilter filter = new HostnameFilter(HostnameFilter.Mode.BEGINS_WITH, "http://192.168.0.100");
        Assertions.assertTrue((boolean)filter.accept(new URI("http://192.168.0.100:81/test.data")));
        Assertions.assertFalse((boolean)filter.accept(new URI("ftp://192.168.0.100:81/test.data")));
        Assertions.assertFalse((boolean)filter.accept(new URI("http://192.168.1.100:81/test.data")));
    }
}

