/*
 * Decompiled with CFR 0.152.
 */
package com.github.markusbernhardt.proxy;

import com.github.markusbernhardt.proxy.ProxySearch;
import com.github.markusbernhardt.proxy.ProxySearchStrategy;
import com.github.markusbernhardt.proxy.selector.fixed.FixedProxySelector;
import com.github.markusbernhardt.proxy.selector.misc.ProtocolDispatchSelector;
import com.github.markusbernhardt.proxy.util.ProxyException;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ProxySearchTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProxySearchTest.class);

    ProxySearchTest() {
    }

    @Test
    void testAddCustomStrategyFirst() throws URISyntaxException {
        ProxySearchStrategy customStrategy = new ProxySearchStrategy(){

            public ProxySelector getProxySelector() throws ProxyException {
                ProtocolDispatchSelector ps = new ProtocolDispatchSelector();
                ps.setSelector("custom", (ProxySelector)new FixedProxySelector("custom@localhost.com", 1234));
                return ps;
            }

            public String getName() {
                return "custom";
            }
        };
        ProxySearch proxySearch = ProxySearch.getDefaultProxySearch();
        proxySearch.addStrategy(customStrategy, true);
        ProxySelector myProxySelector = proxySearch.getProxySelector();
        Assertions.assertThat((Object)myProxySelector).isNotNull();
        List<Proxy> proxies = myProxySelector.select(new URI("custom://localhost"));
        LOGGER.info("Current proxies: {}", proxies);
        ((ListAssert)Assertions.assertThat(proxies).isNotEmpty()).hasSize(1);
        Assertions.assertThat((String)proxies.get(0).toString()).matches((CharSequence)"HTTP @ custom@localhost\\.com(\\/<unresolved>)?:1234");
    }

    @Test
    void testAddCustomStrategyLast() throws URISyntaxException {
        ProxySearchStrategy customStrategy = new ProxySearchStrategy(){

            public ProxySelector getProxySelector() throws ProxyException {
                ProtocolDispatchSelector ps = new ProtocolDispatchSelector();
                ps.setSelector("custom", (ProxySelector)new FixedProxySelector("custom@localhost.com", 1234));
                return ps;
            }

            public String getName() {
                return "custom";
            }
        };
        ProxySearch proxySearch = ProxySearch.getDefaultProxySearch();
        proxySearch.removeStrategy(ProxySearch.Strategy.BROWSER);
        proxySearch.addStrategy(customStrategy, false);
        ProxySelector myProxySelector = proxySearch.getProxySelector();
        Assertions.assertThat((Object)myProxySelector).isNotNull();
        List<Proxy> proxies = myProxySelector.select(new URI("custom://localhost"));
        LOGGER.info("Current proxies: {}", proxies);
        Assertions.assertThat(proxies).isNotEmpty();
        ((ListAssert)Assertions.assertThat(proxies).isNotEmpty()).hasSize(1);
        Assertions.assertThat((String)proxies.get(0).toString()).matches((CharSequence)"HTTP @ custom@localhost\\.com(\\/<unresolved>)?:1234");
    }
}

