/*
 * Decompiled with CFR 0.152.
 */
package com.github.markusbernhardt.proxy.search.java;

import com.github.markusbernhardt.proxy.TestUtil;
import com.github.markusbernhardt.proxy.search.java.JavaProxySearchStrategy;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class JavaProxySearchTest {
    private ProxySelector selector;

    @BeforeAll
    public static void setupClass() {
        System.setProperty("http.proxyHost", "http_proxy.unit-test.invalid");
        System.setProperty("http.proxyPort", "8090");
        System.setProperty("http.nonProxyHosts", "no_proxy.unit-test.invalid");
        System.setProperty("https.proxyHost", "https_proxy.unit-test.invalid");
        System.setProperty("https.proxyPort", "8091");
        System.setProperty("ftp.proxyHost", "ftp_proxy.unit-test.invalid");
        System.setProperty("ftp.nonProxyHosts", "no_proxy.unit-test.invalid");
        System.setProperty("ftp.proxyPort", "8092");
        System.setProperty("socksProxyHost", "socks_proxy.unit-test.invalid");
        System.setProperty("socksProxyPort", "8095");
    }

    @AfterAll
    public static void teardownClass() {
        System.clearProperty("http.proxyHost");
        System.clearProperty("http.proxyPort");
        System.clearProperty("http.nonProxyHosts");
        System.clearProperty("https.proxyHost");
        System.clearProperty("https.proxyPort");
        System.clearProperty("ftp.proxyHost");
        System.clearProperty("ftp.nonProxyHosts");
        System.clearProperty("ftp.proxyPort");
        System.clearProperty("socksProxyHost");
        System.clearProperty("socksProxyPort");
    }

    @BeforeEach
    public void setup() {
        this.selector = new JavaProxySearchStrategy().getProxySelector();
    }

    @Test
    public void testHTTP() {
        List<Proxy> result = this.selector.select(TestUtil.HTTP_TEST_URI);
        Assertions.assertEquals((Object)TestUtil.HTTP_TEST_PROXY, (Object)result.get(0));
    }

    @Test
    public void testHTTPnoProxy() throws URISyntaxException {
        List<Proxy> result = this.selector.select(new URI("http://no_proxy.unit-test.invalid"));
        Assertions.assertEquals((Object)Proxy.NO_PROXY, (Object)result.get(0));
    }

    @Test
    public void testHTTPS() {
        List<Proxy> result = this.selector.select(TestUtil.HTTPS_TEST_URI);
        Assertions.assertEquals((Object)TestUtil.HTTPS_TEST_PROXY, (Object)result.get(0));
    }

    @Test
    public void testHTTPSnoProxy() throws URISyntaxException {
        List<Proxy> result = this.selector.select(new URI("https://no_proxy.unit-test.invalid"));
        Assertions.assertEquals((Object)Proxy.NO_PROXY, (Object)result.get(0));
    }

    @Test
    public void testFTP() {
        List<Proxy> result = this.selector.select(TestUtil.FTP_TEST_URI);
        Assertions.assertEquals((Object)TestUtil.FTP_TEST_PROXY, (Object)result.get(0));
    }

    @Test
    public void testFTPnoProxy() throws URISyntaxException {
        List<Proxy> result = this.selector.select(new URI("ftp://no_proxy.unit-test.invalid"));
        Assertions.assertEquals((Object)Proxy.NO_PROXY, (Object)result.get(0));
    }

    @Test
    public void testSOCKS() {
        List<Proxy> result = this.selector.select(TestUtil.SOCKS_TEST_URI);
        Assertions.assertEquals((Object)TestUtil.SOCKS_TEST_PROXY, (Object)result.get(0));
    }
}

