/*
 * Decompiled with CFR 0.152.
 */
package com.github.markusbernhardt.proxy.search.kde;

import com.github.markusbernhardt.proxy.TestUtil;
import com.github.markusbernhardt.proxy.search.desktop.kde.KdeProxySearchStrategy;
import com.github.markusbernhardt.proxy.util.Logger;
import com.github.markusbernhardt.proxy.util.ProxyException;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URISyntaxException;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.extension.ExtendWith;
import uk.org.webcompere.systemstubs.environment.EnvironmentVariables;
import uk.org.webcompere.systemstubs.jupiter.SystemStub;
import uk.org.webcompere.systemstubs.jupiter.SystemStubsExtension;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@ExtendWith(value={SystemStubsExtension.class})
public class KdeProxySearchTest {
    @SystemStub
    public final EnvironmentVariables environmentVariables = new EnvironmentVariables();

    @BeforeAll
    public void setupClass() {
        this.environmentVariables.set("HTTP_PROXY", "http://http_proxy.unit-test.invalid:8090");
        this.environmentVariables.set("HTTPS_PROXY", "http://https_proxy.unit-test.invalid:8091");
        this.environmentVariables.set("FTP_PROXY", "http://ftp_proxy.unit-test.invalid:8092");
        Logger.setBackend((Logger.LogBackEnd)new Logger.Slf4jLogBackEnd());
    }

    @Test
    public void testNone() throws ProxyException {
        TestUtil.setTestDataFolder("kde_none");
        ProxySelector ps = new KdeProxySearchStrategy().getProxySelector();
        List<Proxy> result = ps.select(TestUtil.HTTP_TEST_URI);
        Assertions.assertEquals((Object)Proxy.NO_PROXY, (Object)result.get(0));
    }

    @Test
    public void testManualHttp() throws ProxyException, URISyntaxException {
        TestUtil.setTestDataFolder("kde_manual");
        ProxySelector ps = new KdeProxySearchStrategy().getProxySelector();
        List<Proxy> result = ps.select(TestUtil.HTTP_TEST_URI);
        Assertions.assertEquals((Object)TestUtil.HTTP_TEST_PROXY, (Object)result.get(0));
    }

    @Test
    public void testManualHttps() throws ProxyException, URISyntaxException {
        TestUtil.setTestDataFolder("kde_manual");
        ProxySelector ps = new KdeProxySearchStrategy().getProxySelector();
        List<Proxy> result = ps.select(TestUtil.HTTPS_TEST_URI);
        Assertions.assertEquals((Object)TestUtil.HTTPS_TEST_PROXY, (Object)result.get(0));
    }

    @Test
    public void testManualFtp() throws ProxyException, URISyntaxException {
        TestUtil.setTestDataFolder("kde_manual");
        ProxySelector ps = new KdeProxySearchStrategy().getProxySelector();
        List<Proxy> result = ps.select(TestUtil.FTP_TEST_URI);
        Assertions.assertEquals((Object)TestUtil.FTP_TEST_PROXY, (Object)result.get(0));
    }

    @Test
    public void testPac() throws ProxyException, URISyntaxException {
        TestUtil.setTestDataFolder("kde_pac_script");
        ProxySelector ps = new KdeProxySearchStrategy().getProxySelector();
        List<Proxy> result = ps.select(TestUtil.HTTP_TEST_URI);
        Assertions.assertEquals((Object)TestUtil.HTTP_TEST_PROXY, (Object)result.get(0));
    }

    @Test
    public void testEnvHttp() throws ProxyException, URISyntaxException {
        TestUtil.setTestDataFolder("kde_env");
        ProxySelector ps = new KdeProxySearchStrategy().getProxySelector();
        List<Proxy> result = ps.select(TestUtil.HTTP_TEST_URI);
        Assertions.assertEquals((Object)TestUtil.HTTP_TEST_PROXY, (Object)result.get(0));
    }

    @Test
    public void testEnvHttps() throws ProxyException, URISyntaxException {
        TestUtil.setTestDataFolder("kde_env");
        ProxySelector ps = new KdeProxySearchStrategy().getProxySelector();
        List<Proxy> result = ps.select(TestUtil.HTTPS_TEST_URI);
        Assertions.assertEquals((Object)TestUtil.HTTPS_TEST_PROXY, (Object)result.get(0));
    }

    @Test
    public void testEnvFtp() throws ProxyException, URISyntaxException {
        TestUtil.setTestDataFolder("kde_env");
        ProxySelector ps = new KdeProxySearchStrategy().getProxySelector();
        List<Proxy> result = ps.select(TestUtil.FTP_TEST_URI);
        Assertions.assertEquals((Object)TestUtil.FTP_TEST_PROXY, (Object)result.get(0));
    }

    @Test
    public void testWhiteList() throws ProxyException, URISyntaxException {
        TestUtil.setTestDataFolder("kde_white_list");
        ProxySelector ps = new KdeProxySearchStrategy().getProxySelector();
        List<Proxy> result = ps.select(TestUtil.NO_PROXY_TEST_URI);
        Assertions.assertEquals((Object)Proxy.NO_PROXY, (Object)result.get(0));
    }
}

