/*
 * Decompiled with CFR 0.152.
 */
package com.github.markusbernhardt.proxy.search.osx;

import com.github.markusbernhardt.proxy.TestUtil;
import com.github.markusbernhardt.proxy.search.desktop.osx.OsxProxySearchStrategy;
import com.github.markusbernhardt.proxy.util.ProxyException;
import java.io.File;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URISyntaxException;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class OsxProxySearchTest {
    @Test
    public void testManualHttp() throws ProxyException, URISyntaxException {
        System.setProperty("com.github.markusbernhardt.proxy.osx.settingsFile", TestUtil.TEST_DATA_FOLDER + File.separator + "osx" + File.separator + "osx_manual.plist");
        System.setProperty("com.github.markusbernhardt.proxy.osx.acceptedDevices", "en0");
        ProxySelector ps = new OsxProxySearchStrategy().getProxySelector();
        List<Proxy> result = ps.select(TestUtil.HTTP_TEST_URI);
        Assertions.assertEquals((Object)TestUtil.HTTP_TEST_PROXY, (Object)result.get(0));
    }

    @Test
    public void wrongIntfaceShouldBeSkipped() throws ProxyException, URISyntaxException {
        System.setProperty("com.github.markusbernhardt.proxy.osx.settingsFile", TestUtil.TEST_DATA_FOLDER + File.separator + "osx" + File.separator + "osx_manual.plist");
        System.setProperty("com.github.markusbernhardt.proxy.osx.acceptedDevices", "junit");
        ProxySelector ps = new OsxProxySearchStrategy().getProxySelector();
        List<Proxy> result = ps.select(TestUtil.HTTP_TEST_URI);
        Assertions.assertEquals((Object)Proxy.NO_PROXY, (Object)result.get(0));
    }

    @Test
    public void testManualHttps() throws ProxyException, URISyntaxException {
        System.setProperty("com.github.markusbernhardt.proxy.osx.settingsFile", TestUtil.TEST_DATA_FOLDER + "osx" + File.separator + "osx_manual.plist");
        ProxySelector ps = new OsxProxySearchStrategy().getProxySelector();
        List<Proxy> result = ps.select(TestUtil.HTTPS_TEST_URI);
        Assertions.assertEquals((Object)TestUtil.HTTPS_TEST_PROXY, (Object)result.get(0));
    }

    @Test
    public void testManualFtp() throws ProxyException, URISyntaxException {
        System.setProperty("com.github.markusbernhardt.proxy.osx.settingsFile", TestUtil.TEST_DATA_FOLDER + "osx" + File.separator + "osx_manual.plist");
        ProxySelector ps = new OsxProxySearchStrategy().getProxySelector();
        List<Proxy> result = ps.select(TestUtil.FTP_TEST_URI);
        Assertions.assertEquals((Object)TestUtil.FTP_TEST_PROXY, (Object)result.get(0));
    }

    @Test
    public void testManualSocks() throws ProxyException, URISyntaxException {
        System.setProperty("com.github.markusbernhardt.proxy.osx.settingsFile", TestUtil.TEST_DATA_FOLDER + "osx" + File.separator + "osx_manual.plist");
        ProxySelector ps = new OsxProxySearchStrategy().getProxySelector();
        List<Proxy> result = ps.select(TestUtil.SOCKS_TEST_URI);
        Assertions.assertEquals((Object)TestUtil.SOCKS_TEST_PROXY, (Object)result.get(0));
    }

    @Test
    public void testNoProxyList() throws ProxyException, URISyntaxException {
        System.setProperty("com.github.markusbernhardt.proxy.osx.settingsFile", TestUtil.TEST_DATA_FOLDER + "osx" + File.separator + "osx_manual.plist");
        ProxySelector ps = new OsxProxySearchStrategy().getProxySelector();
        List<Proxy> result = ps.select(TestUtil.NO_PROXY_TEST_URI);
        Assertions.assertEquals((Object)Proxy.NO_PROXY, (Object)result.get(0));
    }

    @Test
    public void testSimpleHostTest() throws ProxyException, URISyntaxException {
        System.setProperty("com.github.markusbernhardt.proxy.osx.settingsFile", TestUtil.TEST_DATA_FOLDER + "osx" + File.separator + "osx_manual.plist");
        ProxySelector ps = new OsxProxySearchStrategy().getProxySelector();
        List<Proxy> result = ps.select(TestUtil.LOCAL_TEST_URI);
        Assertions.assertEquals((Object)Proxy.NO_PROXY, (Object)result.get(0));
    }
}

