/*
 * Decompiled with CFR 0.152.
 */
package com.github.markusbernhardt.proxy.selector.pac;

import com.github.markusbernhardt.proxy.TestUtil;
import com.github.markusbernhardt.proxy.selector.pac.JavaxPacScriptParser;
import com.github.markusbernhardt.proxy.selector.pac.PacScriptParser;
import com.github.markusbernhardt.proxy.selector.pac.PacScriptSource;
import com.github.markusbernhardt.proxy.selector.pac.UrlPacScriptSource;
import com.github.markusbernhardt.proxy.util.ProxyException;
import java.io.File;
import java.net.MalformedURLException;
import java.util.Calendar;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class JavaxPacScriptParserTest {
    @BeforeAll
    public static void setup() {
        Calendar cal = Calendar.getInstance();
        cal.set(1, 1994);
        cal.set(2, 11);
        cal.set(5, 15);
        cal.set(11, 12);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
    }

    @AfterAll
    public static void teadDown() {
    }

    @Test
    public void testScriptExecution() throws ProxyException, MalformedURLException {
        JavaxPacScriptParser p = new JavaxPacScriptParser((PacScriptSource)new UrlPacScriptSource(this.toUrl("test1.pac")));
        p.evaluate(TestUtil.HTTP_TEST_URI.toString(), "host1.unit-test.invalid");
    }

    @Test
    public void testBomExecution() throws ProxyException, MalformedURLException {
        JavaxPacScriptParser p = new JavaxPacScriptParser((PacScriptSource)new UrlPacScriptSource(this.toUrl("pacWithBom.pac")));
        String result = p.evaluate(TestUtil.HTTP_TEST_URI.toString(), "host1.test");
        Assertions.assertThat((String)result).contains(new CharSequence[]{"DIRECT"});
    }

    @Test
    public void testCommentsInScript() throws ProxyException, MalformedURLException {
        JavaxPacScriptParser p = new JavaxPacScriptParser((PacScriptSource)new UrlPacScriptSource(this.toUrl("test2.pac")));
        p.evaluate(TestUtil.HTTP_TEST_URI.toString(), "host1.unit-test.invalid");
    }

    @Test
    public void testSpaceInScript() throws ProxyException, MalformedURLException {
        JavaxPacScriptParser p = new JavaxPacScriptParser((PacScriptSource)new UrlPacScriptSource(this.toUrl("test3.pac")));
        String result = p.evaluate(TestUtil.HTTP_TEST_URI.toString(), "host1.unit-test.invalid");
        Assertions.assertThat((String)result).isNull();
    }

    @Test
    public void testScriptWeekDayScript() throws ProxyException, MalformedURLException {
        JavaxPacScriptParser p = new JavaxPacScriptParser((PacScriptSource)new UrlPacScriptSource(this.toUrl("testWeekDay.pac")));
        p.evaluate(TestUtil.HTTP_TEST_URI.toString(), "host1.unit-test.invalid");
    }

    @Test
    public void testDateRangeScript() throws ProxyException, MalformedURLException {
        JavaxPacScriptParser p = new JavaxPacScriptParser((PacScriptSource)new UrlPacScriptSource(this.toUrl("testDateRange.pac")));
        p.evaluate(TestUtil.HTTP_TEST_URI.toString(), "host1.unit-test.invalid");
    }

    @Test
    public void testTimeRangeScript() throws ProxyException, MalformedURLException {
        JavaxPacScriptParser p = new JavaxPacScriptParser((PacScriptSource)new UrlPacScriptSource(this.toUrl("testTimeRange.pac")));
        p.evaluate(TestUtil.HTTP_TEST_URI.toString(), "host1.unit-test.invalid");
    }

    @Test
    public void methodsShouldReturnJsStrings() throws ProxyException, MalformedURLException {
        JavaxPacScriptParser p = new JavaxPacScriptParser((PacScriptSource)new UrlPacScriptSource(this.toUrl("testReturnTypes.pac")));
        String actual = p.evaluate(TestUtil.HTTP_TEST_URI.toString(), "host1.unit-test.invalid");
        Assertions.assertThat((String)actual).isEqualTo("number boolean string");
    }

    @Test
    public void shouldNotExecuteCodeInPac() throws ProxyException, MalformedURLException {
        JavaxPacScriptParser p = new JavaxPacScriptParser((PacScriptSource)new UrlPacScriptSource(this.toUrl("testRemoteCodeExecution.pac")));
        Assertions.assertThatThrownBy(() -> JavaxPacScriptParserTest.lambda$shouldNotExecuteCodeInPac$0((PacScriptParser)p)).isInstanceOf(Exception.class);
    }

    private String toUrl(String testFile) throws MalformedURLException {
        return new File(TestUtil.TEST_DATA_FOLDER + "pac", testFile).toURI().toURL().toString();
    }

    private static /* synthetic */ void lambda$shouldNotExecuteCodeInPac$0(PacScriptParser p) throws Throwable {
        p.evaluate(TestUtil.HTTP_TEST_URI.toString(), "host.does.not.matter");
    }
}

