/*
 * Decompiled with CFR 0.152.
 */
package com.github.markusbernhardt.proxy.selector.pac;

import com.github.markusbernhardt.proxy.TestUtil;
import com.github.markusbernhardt.proxy.selector.pac.PacScriptMethods;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Calendar;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class PacScriptMethodsTest {
    private PacScriptMethods buildParser() {
        PacScriptMethods result = new PacScriptMethods();
        Calendar cal = Calendar.getInstance();
        cal.set(1, 1994);
        cal.set(2, 11);
        cal.set(5, 15);
        cal.set(11, 12);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        result.setCurrentTime(cal);
        return result;
    }

    @Test
    public void testDnsDomainIs() {
        Assertions.assertEquals((Object)true, (Object)this.buildParser().dnsDomainIs("host1.unit-test.invalid", "unit-test.invalid"));
    }

    @Test
    public void testDnsDomainLevels() {
        Assertions.assertEquals((int)2, (int)this.buildParser().dnsDomainLevels(TestUtil.HTTP_TEST_URI.toString()));
    }

    @Test
    public void testDnsResolve() throws UnknownHostException {
        InetAddress adr = Inet4Address.getLocalHost();
        Assertions.assertEquals((Object)adr.getHostAddress(), (Object)this.buildParser().dnsResolve(adr.getHostName()));
    }

    @Test
    public void testIsInNet() {
        Assertions.assertEquals((Object)true, (Object)this.buildParser().isInNet("192.168.0.122", "192.168.0.0", "255.255.255.0"));
    }

    @Test
    public void testIsInNet2() {
        Assertions.assertEquals((Object)true, (Object)this.buildParser().isInNet("10.13.75.47", "10.13.72.0", "255.255.252.0"));
    }

    @Test
    public void testIsInNetExForIP4() {
        Assertions.assertEquals((Object)true, (Object)this.buildParser().isInNetEx("198.95.249.79", "198.95.249.79/32"));
        Assertions.assertEquals((Object)false, (Object)this.buildParser().isInNetEx("198.95.249.80", "198.95.249.79/32"));
        Assertions.assertEquals((Object)true, (Object)this.buildParser().isInNetEx("198.95.249.79", "198.95.0.0/16"));
        Assertions.assertEquals((Object)true, (Object)this.buildParser().isInNetEx("198.95.249.80", "198.95.0.0/16"));
        Assertions.assertEquals((Object)false, (Object)this.buildParser().isInNetEx("198.96.249.80", "198.95.0.0/16"));
    }

    @Test
    public void testIsInNetExForIP6() {
        Assertions.assertEquals((Object)true, (Object)this.buildParser().isInNetEx("3ffe:8311:ffff::", "3ffe:8311:ffff::/48"));
        Assertions.assertEquals((Object)true, (Object)this.buildParser().isInNetEx("3ffe:8311:ffff:1111:0:0:0:0", "3ffe:8311:ffff::/48"));
        Assertions.assertEquals((Object)false, (Object)this.buildParser().isInNetEx("3ffe:8312:ffff:1111:0:0:0:0", "3ffe:8311:ffff::/48"));
    }

    @Test
    public void testSortIpAddressList() {
        Assertions.assertEquals((Object)"fe80::5efe:157.59.139.22;2001:4898:28:3:201:2ff:feea:fc14;157.59.139.22", (Object)this.buildParser().sortIpAddressList("2001:4898:28:3:201:2ff:feea:fc14; 157.59.139.22; fe80::5efe:157.59.139.22"));
    }

    @Test
    public void testIsPlainHostName() {
        Assertions.assertEquals((Object)false, (Object)this.buildParser().isPlainHostName("host1.unit-test.invalid"));
        Assertions.assertEquals((Object)true, (Object)this.buildParser().isPlainHostName("host1"));
    }

    @Test
    public void testIsResolveable() throws UnknownHostException {
        InetAddress adr = Inet4Address.getLocalHost();
        Assertions.assertEquals((Object)true, (Object)this.buildParser().isResolvable(adr.getHostName()));
    }

    @Test
    public void testLocalHostOrDomainIs() {
        Assertions.assertEquals((Object)true, (Object)this.buildParser().localHostOrDomainIs("host1.unit-test.invalid", "host1.unit-test.invalid"));
    }

    @Test
    public void testMyIpAddress() throws UnknownHostException {
        String myIP = this.buildParser().myIpAddress();
        Assertions.assertNotEquals((Object)"127.0.0.1", (Object)myIP);
        Assertions.assertNotEquals((Object)"", (Object)myIP);
        Assertions.assertNotNull((Object)myIP);
    }

    @Test
    public void testShExpMatch() {
        Assertions.assertEquals((Object)true, (Object)this.buildParser().shExpMatch("host1.unit-test.invalid", "host1.unit-test.*"));
        Assertions.assertEquals((Object)true, (Object)this.buildParser().shExpMatch("host1.unit-test.invalid", "*.unit-test.invalid"));
        Assertions.assertEquals((Object)true, (Object)this.buildParser().shExpMatch("host1.unit-test.invalid", "*.unit*.invalid"));
        Assertions.assertEquals((Object)false, (Object)this.buildParser().shExpMatch("202.310.65.6", "10.*"));
        Assertions.assertEquals((Object)false, (Object)this.buildParser().shExpMatch("202.310.65.6", "*.65"));
    }

    @Test
    public void testWeekdayRange() {
        Assertions.assertEquals((Object)true, (Object)this.buildParser().weekdayRange("MON", "SUN", "GMT"));
        Assertions.assertEquals((Object)true, (Object)this.buildParser().weekdayRange("SUN", "SAT", null));
        Assertions.assertEquals((Object)false, (Object)this.buildParser().weekdayRange("MON", "WED", null));
    }

    @Test
    public void testDateRange() {
        Assertions.assertEquals((Object)true, (Object)this.buildParser().dateRange((Object)15, (Object)"undefined", (Object)"undefined", (Object)"undefined", (Object)"undefined", (Object)"undefined", (Object)"undefined"));
        Assertions.assertEquals((Object)true, (Object)this.buildParser().dateRange((Object)15, (Object)"DEC", (Object)"undefined", (Object)"undefined", (Object)"undefined", (Object)"undefined", (Object)"undefined"));
        Assertions.assertEquals((Object)true, (Object)this.buildParser().dateRange((Object)15, (Object)"DEC", (Object)1994, (Object)"undefined", (Object)"undefined", (Object)"undefined", (Object)"undefined"));
        Assertions.assertEquals((Object)true, (Object)this.buildParser().dateRange((Object)15, (Object)17, (Object)"undefined", (Object)"undefined", (Object)"undefined", (Object)"undefined", (Object)"undefined"));
        Assertions.assertEquals((Object)true, (Object)this.buildParser().dateRange((Object)"OCT", (Object)"JAN", (Object)"undefined", (Object)"undefined", (Object)"undefined", (Object)"undefined", (Object)"undefined"));
        Assertions.assertEquals((Object)true, (Object)this.buildParser().dateRange((Object)1994, (Object)1994, (Object)"undefined", (Object)"undefined", (Object)"undefined", (Object)"undefined", (Object)"undefined"));
        Assertions.assertEquals((Object)true, (Object)this.buildParser().dateRange((Object)1, (Object)"DEC", (Object)1994, (Object)1, (Object)"JAN", (Object)1995, (Object)"GTM"));
        Assertions.assertEquals((Object)false, (Object)this.buildParser().dateRange((Object)16, (Object)"DEC", (Object)1994, (Object)1, (Object)"JAN", (Object)1995, (Object)"GTM"));
    }

    @Test
    public void testTimeRange() {
        Assertions.assertEquals((Object)true, (Object)this.buildParser().timeRange((Object)12, (Object)"undefined", (Object)"undefined", (Object)"undefined", (Object)"undefined", (Object)"undefined", (Object)"undefined"));
        Assertions.assertEquals((Object)true, (Object)this.buildParser().timeRange((Object)11, (Object)13, (Object)"undefined", (Object)"undefined", (Object)"undefined", (Object)"undefined", (Object)"undefined"));
        Assertions.assertEquals((Object)true, (Object)this.buildParser().timeRange((Object)11, (Object)13, (Object)"gmt", (Object)"undefined", (Object)"undefined", (Object)"undefined", (Object)"undefined"));
        Assertions.assertEquals((Object)true, (Object)this.buildParser().timeRange((Object)11, (Object)30, (Object)13, (Object)30, (Object)"undefined", (Object)"undefined", (Object)"undefined"));
        Assertions.assertEquals((Object)true, (Object)this.buildParser().timeRange((Object)11, (Object)30, (Object)15, (Object)13, (Object)30, (Object)15, (Object)"undefined"));
        Assertions.assertEquals((Object)true, (Object)this.buildParser().timeRange((Object)11, (Object)30, (Object)15, (Object)13, (Object)30, (Object)15, (Object)"GMT"));
        Assertions.assertEquals((Object)false, (Object)this.buildParser().timeRange((Object)12, (Object)50, (Object)0, (Object)9, (Object)30, (Object)0, (Object)"GMT"));
    }
}

