/*
 * Decompiled with CFR 0.152.
 */
package com.github.markusbernhardt.proxy.selector.pac;

import com.github.markusbernhardt.proxy.selector.pac.UrlPacScriptSource;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class UrlPacScriptSourceTest {
    @Test
    public void testHttpCharsetParser() {
        UrlPacScriptSource scriptSource = new UrlPacScriptSource("");
        String charset = scriptSource.parseCharsetFromHeader("application/x-ns-proxy-autoconfig; charset=ISO-8859-1");
        Assertions.assertEquals((Object)"ISO-8859-1", (Object)charset);
    }

    @Test
    public void testHttpCharsetParserDefault() {
        UrlPacScriptSource scriptSource = new UrlPacScriptSource("");
        String charset = scriptSource.parseCharsetFromHeader("application/octet-stream;");
        Assertions.assertEquals((Object)"UTF-8", (Object)charset);
    }

    @Test
    public void overrideTimeoutShouldWork() {
        System.setProperty("com.btr.proxy.url.connectTimeout", "5000");
        UrlPacScriptSource scriptSource = new UrlPacScriptSource("");
        int timeout = scriptSource.getTimeOut("com.btr.proxy.url.connectTimeout", 1000);
        System.clearProperty("com.btr.proxy.url.connectTimeout");
        Assertions.assertEquals((int)5000, (int)timeout);
    }

    @Test
    public void timeoutShouldUseDefault() {
        System.setProperty("com.btr.proxy.url.connectTimeout", "XXX");
        UrlPacScriptSource scriptSource = new UrlPacScriptSource("");
        int timeout = scriptSource.getTimeOut("com.btr.proxy.url.connectTimeout", 1000);
        System.clearProperty("com.btr.proxy.url.connectTimeout");
        Assertions.assertEquals((int)1000, (int)timeout);
    }
}

