/*
 * Decompiled with CFR 0.152.
 */
package com.github.markusbernhardt.proxy.selector.whitelist;

import com.github.markusbernhardt.proxy.selector.whitelist.DefaultWhiteListParser;
import com.github.markusbernhardt.proxy.util.UriFilter;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DefaultWhiteListParserTest {
    private DefaultWhiteListParser parser = new DefaultWhiteListParser();

    @Test
    public void shouldAllowAllPrefix() throws URISyntaxException {
        List l = this.parser.parseWhiteList("*.mynet.com");
        UriFilter filter = (UriFilter)l.get(0);
        Assertions.assertTrue((boolean)filter.accept(new URI("http://rossi.mynet.com")));
        Assertions.assertFalse((boolean)filter.accept(new URI("http://rossi.mynet.com.test")));
    }

    @Test
    public void shouldAllowAllPostfix() throws URISyntaxException {
        List l = this.parser.parseWhiteList("mynet.*");
        UriFilter filter = (UriFilter)l.get(0);
        Assertions.assertFalse((boolean)filter.accept(new URI("http://rossi.mynet.com")));
        Assertions.assertTrue((boolean)filter.accept(new URI("http://mynet.junit.test")));
    }

    @Test
    public void shouldSplitMultipleEntries() throws URISyntaxException {
        List l = this.parser.parseWhiteList("*.mynet.com; *.rossi.invalid; junit*");
        Assertions.assertEquals((int)3, (int)l.size());
    }

    @Test
    public void shouldAllowIpRange() throws URISyntaxException {
        List l = this.parser.parseWhiteList("192.168.0.0/24");
        UriFilter filter = (UriFilter)l.get(0);
        Assertions.assertTrue((boolean)filter.accept(new URI("http://192.168.0.1")));
        Assertions.assertTrue((boolean)filter.accept(new URI("http://192.168.0.11")));
        Assertions.assertFalse((boolean)filter.accept(new URI("http://rossi.mynet.com")));
        Assertions.assertFalse((boolean)filter.accept(new URI("http://145.5.5.1")));
    }

    @Test
    public void shouldHandleInvalidWithoutException() throws URISyntaxException {
        List l = this.parser.parseWhiteList("http://10.*.*.*");
        UriFilter filter = (UriFilter)l.get(0);
        Assertions.assertFalse((boolean)filter.accept(new URI("http://10.0.0.1")));
    }

    @Test
    public void shouldHandleLocalBypass() throws URISyntaxException {
        List l = this.parser.parseWhiteList("<local>");
        UriFilter filter = (UriFilter)l.get(0);
        Assertions.assertTrue((boolean)filter.accept(new URI("http://localhost")));
    }
}

