/*
 * Decompiled with CFR 0.152.
 */
package com.github.markusbernhardt.proxy.selector.whitelist;

import com.github.markusbernhardt.proxy.TestUtil;
import com.github.markusbernhardt.proxy.selector.fixed.FixedProxySelector;
import com.github.markusbernhardt.proxy.selector.whitelist.ProxyBypassListSelector;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class NoProxyTest {
    @Test
    public void testWhiteList() {
        FixedProxySelector delegate = new FixedProxySelector(TestUtil.HTTP_TEST_PROXY);
        ProxyBypassListSelector ps = new ProxyBypassListSelector("no_prox.*", (ProxySelector)delegate);
        Assertions.assertEquals((Object)delegate.select(TestUtil.HTTP_TEST_URI).get(0), ps.select(TestUtil.HTTP_TEST_URI).get(0));
    }

    @Test
    public void testWhiteList2() {
        FixedProxySelector delegate = new FixedProxySelector(TestUtil.HTTP_TEST_PROXY);
        ProxyBypassListSelector ps = new ProxyBypassListSelector("*.unit-test.invalid", (ProxySelector)delegate);
        List result = ps.select(TestUtil.HTTP_TEST_URI);
        Assertions.assertEquals((Object)Proxy.NO_PROXY, result.get(0));
    }

    @Test
    public void testWhiteList3() throws URISyntaxException {
        FixedProxySelector delegate = new FixedProxySelector(TestUtil.HTTP_TEST_PROXY);
        ProxyBypassListSelector ps = new ProxyBypassListSelector("*.unit-test.invalid, localhost, 127.0.0.1", (ProxySelector)delegate);
        List result = ps.select(new URI("http://localhost:65/getDocument"));
        Assertions.assertEquals((Object)Proxy.NO_PROXY, result.get(0));
        result = ps.select(new URI("http://127.0.0.1:65/getDocument"));
        Assertions.assertEquals((Object)Proxy.NO_PROXY, result.get(0));
    }

    @Test
    public void testWhiteList4() {
        FixedProxySelector delegate = new FixedProxySelector(TestUtil.HTTP_TEST_PROXY);
        ProxyBypassListSelector ps = new ProxyBypassListSelector("*.unit-test.invalid, ", (ProxySelector)delegate);
        List result = ps.select(TestUtil.HTTP_TEST_URI);
        Assertions.assertEquals((Object)Proxy.NO_PROXY, result.get(0));
    }

    @Test
    public void testWhiteList5() throws URISyntaxException {
        FixedProxySelector delegate = new FixedProxySelector(TestUtil.HTTP_TEST_PROXY);
        ProxyBypassListSelector ps = new ProxyBypassListSelector("*.unit-test.invalid localhost 127.0.0.1", (ProxySelector)delegate);
        List result = ps.select(new URI("http://localhost:65/getDocument"));
        Assertions.assertEquals((Object)Proxy.NO_PROXY, result.get(0));
        result = ps.select(new URI("http://127.0.0.1:65/getDocument"));
        Assertions.assertEquals((Object)Proxy.NO_PROXY, result.get(0));
    }

    @Test
    public void testIpRange() throws URISyntaxException {
        FixedProxySelector delegate = new FixedProxySelector(TestUtil.HTTP_TEST_PROXY);
        ProxyBypassListSelector ps = new ProxyBypassListSelector("192.168.0.0/24", (ProxySelector)delegate);
        List result = ps.select(new URI("http://192.168.0.100:81/test.data"));
        Assertions.assertEquals((Object)Proxy.NO_PROXY, result.get(0));
        result = ps.select(new URI("http://192.168.1.100:81/test.data"));
        Assertions.assertEquals((Object)delegate.select(TestUtil.HTTP_TEST_URI).get(0), result.get(0));
    }

    @Test
    public void ipRangeShouldNotMatchHttp() throws URISyntaxException {
        FixedProxySelector delegate = new FixedProxySelector(TestUtil.HTTP_TEST_PROXY);
        ProxyBypassListSelector ps = new ProxyBypassListSelector("http://192.*", (ProxySelector)delegate);
        List result = ps.select(new URI("http://192.168.0.100:81/test.data"));
        Assertions.assertEquals((Object)Proxy.NO_PROXY, result.get(0));
    }
}

