/*
 * Decompiled with CFR 0.152.
 */
package com.github.markusbernhardt.proxy.util;

import com.github.markusbernhardt.proxy.TestUtil;
import com.github.markusbernhardt.proxy.util.PListParser;
import java.io.File;
import java.io.IOException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class PListParserTest {
    private static final String TEST_SETTINGS = TestUtil.TEST_DATA_FOLDER + File.separator + "osx" + File.separator + "osx_all.plist";
    private static PListParser.Dict pList;

    @BeforeAll
    public static void setupClass() throws PListParser.XmlParseException, IOException {
        pList = PListParser.load((File)new File(TEST_SETTINGS));
    }

    @Test
    public void testLoadFile() {
        Assertions.assertTrue((pList.size() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testStructure() {
        String currentSet = (String)pList.get("CurrentSet");
        Assertions.assertNotNull((Object)currentSet);
        Object networkServices = pList.get("NetworkServices");
        Assertions.assertTrue((boolean)(networkServices instanceof PListParser.Dict));
    }

    @Test
    public void testNavigate() {
        Object result = pList.getAtPath("NetworkServices/299B07C0-D0E0-4840-8486-9E77B9ED84DB/AppleTalk");
        Assertions.assertNotNull((Object)result);
        Assertions.assertTrue((boolean)(result instanceof PListParser.Dict));
    }

    @Test
    public void testNavigate2() {
        Object result = pList.getAtPath("/NetworkServices/299B07C0-D0E0-4840-8486-9E77B9ED84DB/AppleTalk");
        Assertions.assertNotNull((Object)result);
        Assertions.assertTrue((boolean)(result instanceof PListParser.Dict));
    }

    @Test
    public void testNavigate3() {
        Object result = pList.getAtPath("/NetworkServices/299B07C0-D0E0-4840-8486-9E77B9ED84DB/AppleTalk/");
        Assertions.assertNotNull((Object)result);
        Assertions.assertTrue((boolean)(result instanceof PListParser.Dict));
    }

    @Test
    public void testNavigate4() {
        Object result = pList.getAtPath("/NetworkServices/299B07C0-D0E0-4840-8486-9E77B9ED84DB/AppleTalkXXX/");
        Assertions.assertNull((Object)result);
    }
}

