/*
 * Decompiled with CFR 0.152.
 */
package com.github.markusbernhardt.proxy.util;

import com.github.markusbernhardt.proxy.TestUtil;
import com.github.markusbernhardt.proxy.selector.fixed.FixedProxySelector;
import com.github.markusbernhardt.proxy.util.ProxyUtil;
import java.net.Proxy;
import java.util.List;
import java.util.regex.Pattern;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class ProxyUtilTest {
    @Test
    public void testParseProxySettings() {
        FixedProxySelector rs = ProxyUtil.parseProxySettings((String)"http://http_proxy.unit-test.invalid/");
        List psList = rs.select(TestUtil.HTTP_TEST_URI);
        Assertions.assertThat((String)((Proxy)psList.get(0)).toString()).matches(Pattern.compile("HTTP @ http_proxy\\.unit-test\\.invalid(\\/<unresolved>)?:80"));
    }

    @Test
    public void testParseProxySettings2() {
        FixedProxySelector rs = ProxyUtil.parseProxySettings((String)"http://http_proxy.unit-test.invalid:8080/");
        List psList = rs.select(TestUtil.HTTP_TEST_URI);
        Assertions.assertThat((String)((Proxy)psList.get(0)).toString()).matches(Pattern.compile("HTTP @ http_proxy\\.unit-test\\.invalid(\\/<unresolved>)?:8080"));
    }

    @Test
    public void testParseProxySettings3() {
        FixedProxySelector rs = ProxyUtil.parseProxySettings((String)"http_proxy.unit-test.invalid");
        List psList = rs.select(TestUtil.HTTP_TEST_URI);
        Assertions.assertThat((String)((Proxy)psList.get(0)).toString()).matches(Pattern.compile("HTTP @ http_proxy\\.unit-test\\.invalid(\\/<unresolved>)?:80"));
    }

    @Test
    public void testParseProxySettings4() {
        FixedProxySelector rs = ProxyUtil.parseProxySettings((String)"http_proxy.unit-test.invalid:8080");
        List psList = rs.select(TestUtil.HTTP_TEST_URI);
        Assertions.assertThat((String)((Proxy)psList.get(0)).toString()).matches(Pattern.compile("HTTP @ http_proxy\\.unit-test\\.invalid(\\/<unresolved>)?:8080"));
    }

    @Test
    public void testParseProxySettings5() {
        FixedProxySelector rs = ProxyUtil.parseProxySettings((String)"192.123.123.1:8080");
        List psList = rs.select(TestUtil.HTTP_TEST_URI);
        Assertions.assertThat((String)((Proxy)psList.get(0)).toString()).matches(Pattern.compile("HTTP @ 192.123.123.1(\\/<unresolved>)?:8080"));
    }

    @Test
    public void testParseIPv6WithoutProtocol() {
        FixedProxySelector rs = ProxyUtil.parseProxySettings((String)"[2001:4860:0:2001::68]:8080");
        List psList = rs.select(TestUtil.HTTP_TEST_URI);
        Assertions.assertThat((String)((Proxy)psList.get(0)).toString()).matches(Pattern.compile("HTTP @ 2001:4860:0:2001::68(\\/<unresolved>)?:8080"));
    }

    @Test
    public void testParseIPv6WithProtocol() {
        FixedProxySelector rs = ProxyUtil.parseProxySettings((String)"http://[2001:4860:0:2001::68]:8080/");
        List psList = rs.select(TestUtil.HTTP_TEST_URI);
        Assertions.assertThat((String)((Proxy)psList.get(0)).toString()).matches(Pattern.compile("HTTP @ 2001:4860:0:2001::68(\\/<unresolved>)?:8080"));
    }
}

