/*
 * Decompiled with CFR 0.152.
 */
package com.github.markusbernhardt.proxy.selector.pac;

import com.github.markusbernhardt.proxy.ProxySearch;
import com.github.markusbernhardt.proxy.util.Logger;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.net.ProxySelector;
import java.net.URL;
import java.net.URLConnection;
import org.slf4j.helpers.MessageFormatter;

public class PacProxyDebugging {
    private static final String TEST_URL = "http://www.asetune.com";

    private void installLogger() {
        Logger.setBackend((Logger.LogBackEnd)new Logger.LogBackEnd(){

            public void log(Class<?> clazz, Logger.LogLevel loglevel, String msg, Object ... params) {
                System.out.println(loglevel + "\t" + MessageFormatter.format((String)msg, (Object)params));
            }
        });
    }

    public static void main(String[] args) {
        PacProxyDebugging pt = new PacProxyDebugging();
        pt.installLogger();
        ProxySearch proxySearch = ProxySearch.getDefaultProxySearch();
        ProxySelector myProxySelector = proxySearch.getProxySelector();
        ProxySelector.setDefault(myProxySelector);
        System.out.println("Using proxy selector: " + myProxySelector);
        String webAddress = TEST_URL;
        try {
            String line;
            URL url = new URL(webAddress);
            System.out.println("Now open a connection to the url: " + webAddress);
            System.out.println("==============================================");
            URLConnection conn = url.openConnection();
            conn.setConnectTimeout(10000);
            InputStream in = conn.getInputStream();
            LineNumberReader lr = new LineNumberReader(new InputStreamReader(in));
            while ((line = lr.readLine()) != null) {
                System.out.println("response line " + lr.getLineNumber() + ": " + line);
            }
            System.out.println("---- END -------------------------------------");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

