/*
 * Decompiled with CFR 0.152.
 */
package com.github.markusbernhardt.proxy.selector.pac;

import com.github.markusbernhardt.proxy.TestUtil;
import com.github.markusbernhardt.proxy.selector.pac.PacProxySelectorTest;
import com.github.markusbernhardt.proxy.selector.pac.PacScriptSource;
import com.github.markusbernhardt.proxy.selector.pac.SafePacProxySelector;
import java.net.Proxy;
import java.net.URI;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SafePacProxySelectorTest {
    SafePacProxySelector pacProxySelector = new SafePacProxySelector((PacScriptSource)PacProxySelectorTest.getTestPacScriptSource("testSafeSelector.pac"));

    @Test
    public void testStrippedHttpsGetsProxied() {
        this.assertGetsProxied("https://sub.domain1.invalid");
        this.assertGetsProxied("https://sub.domain1.invalid/path/?query#fragment");
        this.assertGetsProxied("https://user:password@sub.domain1.invalid/");
        this.assertDoesntGetProxied("https://sub.different-domain1.invalid/");
    }

    @Test
    public void testStrippedWssGetsProxied() {
        this.assertGetsProxied("wss://sub.domain1.invalid");
        this.assertGetsProxied("wss://sub.domain1.invalid/path/?query#fragment");
        this.assertGetsProxied("wss://user:password@sub.domain1.invalid/");
        this.assertDoesntGetProxied("wss://sub.different-domain1.invalid/");
    }

    @Test
    public void testStrippedHttpGetsProxied() {
        this.assertGetsProxied("http://sub.domain2.invalid/path/something?q=a");
        this.assertGetsProxied("http://user:password@sub.domain2.invalid/path/?q=a");
        this.assertDoesntGetProxied("http://sub.domain2.invalid/path/?q=different");
        this.assertDoesntGetProxied("http://sub.domain2.invalid");
        this.assertDoesntGetProxied("http://sub.domain2.invalid/different");
    }

    @Test
    public void sanitizeWorksAsExpectedForCryptographicSchemes() {
        Assertions.assertEquals((Object)SafePacProxySelector.sanitizeURI((URI)URI.create("https://u:p@sub.domain.com:99/path?q=a#f")), (Object)URI.create("https://sub.domain.com:99/"));
        Assertions.assertEquals((Object)SafePacProxySelector.sanitizeURI((URI)URI.create("https://sub.domain.com")), (Object)URI.create("https://sub.domain.com/"));
        Assertions.assertEquals((Object)SafePacProxySelector.sanitizeURI((URI)URI.create("wss://u:p@sub.domain.com:99/path?q=a#f")), (Object)URI.create("wss://sub.domain.com:99/"));
        Assertions.assertEquals((Object)SafePacProxySelector.sanitizeURI((URI)URI.create("wss://sub.domain.com")), (Object)URI.create("wss://sub.domain.com/"));
    }

    @Test
    public void sanitizeWorksAsExpectedForNonCryptographicSchemes() {
        Assertions.assertEquals((Object)SafePacProxySelector.sanitizeURI((URI)URI.create("http://u:p@sub.domain.com:99/path?q=a#f")), (Object)URI.create("http://sub.domain.com:99/path?q=a"));
        Assertions.assertEquals((Object)SafePacProxySelector.sanitizeURI((URI)URI.create("http://sub.domain.com")), (Object)URI.create("http://sub.domain.com"));
        Assertions.assertEquals((Object)SafePacProxySelector.sanitizeURI((URI)URI.create("ftp://u:p@sub.domain.com:99/path?q=a#f")), (Object)URI.create("ftp://sub.domain.com:99/path?q=a"));
        Assertions.assertEquals((Object)SafePacProxySelector.sanitizeURI((URI)URI.create("ftp://sub.domain.com")), (Object)URI.create("ftp://sub.domain.com"));
    }

    void assertGetsProxied(String url) {
        List results = this.pacProxySelector.select(URI.create(url));
        Assertions.assertEquals((int)1, (int)results.size());
        Assertions.assertEquals((Object)TestUtil.HTTP_TEST_PROXY, results.get(0));
    }

    void assertDoesntGetProxied(String url) {
        List results = this.pacProxySelector.select(URI.create(url));
        Assertions.assertEquals((int)1, (int)results.size());
        Assertions.assertEquals((Object)Proxy.NO_PROXY, results.get(0));
    }
}

