/*
 * Decompiled with CFR 0.152.
 */
package com.github.markusbernhardt.proxy.selector.whitelist;

import com.github.markusbernhardt.proxy.selector.whitelist.IPWithSubnetChecker;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class IPv4WithSubnetCheckerTest {
    @Test
    public void testIsValidIP4() {
        Assertions.assertTrue((boolean)IPWithSubnetChecker.isValidIP4Range((String)"127.0.0.1/8"), (String)"Accept 127.0.0.1/8");
        Assertions.assertTrue((boolean)IPWithSubnetChecker.isValidIP4Range((String)"127.0.0.1/32"), (String)"Accept 127.0.0.1/32");
        Assertions.assertTrue((boolean)IPWithSubnetChecker.isValidIP4Range((String)"255.255.255.255/32"), (String)"Accept 255.255.255.255/32");
        Assertions.assertTrue((boolean)IPWithSubnetChecker.isValidIP4Range((String)"0.0.0.0/0"), (String)"Accept 0.0.0.0/0");
        Assertions.assertFalse((boolean)IPWithSubnetChecker.isValidIP4Range((String)"127.0.0.1"), (String)"Reject 127.0.0.1");
        Assertions.assertFalse((boolean)IPWithSubnetChecker.isValidIP4Range((String)"localhost"), (String)"Reject localhost");
        Assertions.assertFalse((boolean)IPWithSubnetChecker.isValidIP4Range((String)"http://www.sick.de"), (String)"Reject http://www.sick.de");
        Assertions.assertFalse((boolean)IPWithSubnetChecker.isValidIP4Range((String)"test.sick.de"), (String)"Reject test.sick.de");
        Assertions.assertFalse((boolean)IPWithSubnetChecker.isValidIP4Range((String)"400.400.400.400"), (String)"Reject 400.400.400.400");
        Assertions.assertFalse((boolean)IPWithSubnetChecker.isValidIP4Range((String)"127.0.0.1/33"), (String)"Reject 127.0.0.1/33");
        Assertions.assertFalse((boolean)IPWithSubnetChecker.isValidIP4Range((String)"127.0.0.*"), (String)"Reject 127.0.0.*");
        Assertions.assertFalse((boolean)IPWithSubnetChecker.isValidIP4Range((String)"127.0.0.*/8"), (String)"Reject 127.0.0.*/8");
        Assertions.assertFalse((boolean)IPWithSubnetChecker.isValidIP4Range((String)"www.test.com/8"), (String)"Reject www.test.com/8");
        Assertions.assertFalse((boolean)IPWithSubnetChecker.isValidIP4Range((String)"127.0.0.1/33.html"), (String)"Reject 127.0.0.1/33.html");
    }

    @Test
    public void testIsValidIP6() {
        Assertions.assertTrue((boolean)IPWithSubnetChecker.isValidIP6Range((String)"2001:db8::/32"), (String)"Accept 2001:db8::/32");
        Assertions.assertTrue((boolean)IPWithSubnetChecker.isValidIP6Range((String)"0::0/0"), (String)"Accept 0::0/0");
        Assertions.assertTrue((boolean)IPWithSubnetChecker.isValidIP6Range((String)"2001:db8::/128"), (String)"Accept 2001:db8::/128");
        Assertions.assertFalse((boolean)IPWithSubnetChecker.isValidIP6Range((String)"2001:zb8::/32"), (String)"Reject 2001:zb8::/32");
        Assertions.assertFalse((boolean)IPWithSubnetChecker.isValidIP6Range((String)"localhost"), (String)"Reject localhost");
    }
}

