/*
 * Decompiled with CFR 0.152.
 */
import com.pi4j.component.sensor.DistanceSensorChangeEvent;
import com.pi4j.component.sensor.DistanceSensorListener;
import com.pi4j.component.sensor.impl.DistanceSensorComponent;
import com.pi4j.gpio.extension.ads.ADS1115GpioProvider;
import com.pi4j.gpio.extension.ads.ADS1115Pin;
import com.pi4j.gpio.extension.ads.ADS1x15GpioProvider;
import com.pi4j.io.gpio.GpioController;
import com.pi4j.io.gpio.GpioFactory;
import com.pi4j.io.gpio.GpioPin;
import com.pi4j.io.gpio.GpioPinAnalogInput;
import com.pi4j.io.gpio.GpioProvider;
import com.pi4j.io.i2c.I2CFactory;
import java.io.IOException;
import java.text.DecimalFormat;

public class ADS1115DistanceSensorExample {
    public static void main(String[] args) throws InterruptedException, I2CFactory.UnsupportedBusNumberException, IOException {
        System.out.println("<--Pi4J--> ADS1115 Distance Sensor Example ... started.");
        final DecimalFormat df = new DecimalFormat("#.##");
        final DecimalFormat pdf = new DecimalFormat("###.#");
        GpioController gpio = GpioFactory.getInstance();
        final ADS1115GpioProvider gpioProvider = new ADS1115GpioProvider(1, 72);
        final GpioPinAnalogInput distanceSensorPin = gpio.provisionAnalogInputPin((GpioProvider)gpioProvider, ADS1115Pin.INPUT_A0, "DistanceSensor-A0");
        gpioProvider.setProgrammableGainAmplifier(ADS1x15GpioProvider.ProgrammableGainAmplifierValue.PGA_4_096V, ADS1115Pin.ALL);
        gpioProvider.setEventThreshold(150.0, ADS1115Pin.ALL);
        gpioProvider.setMonitorInterval(100);
        DistanceSensorComponent distanceSensor = new DistanceSensorComponent(distanceSensorPin);
        distanceSensor.addCalibrationCoordinate(21600.0, 13.0);
        distanceSensor.addCalibrationCoordinate(21500.0, 14.0);
        distanceSensor.addCalibrationCoordinate(21400.0, 15.0);
        distanceSensor.addCalibrationCoordinate(21200.0, 16.0);
        distanceSensor.addCalibrationCoordinate(21050.0, 17.0);
        distanceSensor.addCalibrationCoordinate(20900.0, 18.0);
        distanceSensor.addCalibrationCoordinate(20500.0, 19.0);
        distanceSensor.addCalibrationCoordinate(20000.0, 20.0);
        distanceSensor.addCalibrationCoordinate(15000.0, 30.0);
        distanceSensor.addCalibrationCoordinate(12000.0, 40.0);
        distanceSensor.addCalibrationCoordinate(9200.0, 50.0);
        distanceSensor.addCalibrationCoordinate(8200.0, 60.0);
        distanceSensor.addCalibrationCoordinate(6200.0, 70.0);
        distanceSensor.addCalibrationCoordinate(4200.0, 80.0);
        distanceSensor.addListener(new DistanceSensorListener[]{new DistanceSensorListener(){

            public void onDistanceChange(DistanceSensorChangeEvent event) {
                double value = event.getRawValue();
                double distance = event.getDistance();
                double percent = value * 100.0 / 32767.0;
                double voltage = gpioProvider.getProgrammableGainAmplifier((GpioPin)distanceSensorPin).getVoltage() * (percent / 100.0);
                System.out.print("\r DISTANCE=" + df.format(distance) + "cm : VOLTS=" + df.format(voltage) + "  | PERCENT=" + pdf.format(percent) + "% | RAW=" + value + "       ");
            }
        }});
        Thread.sleep(600000L);
        gpio.shutdown();
        System.out.println("Exiting ADS1115DistanceSensorExample");
    }
}

