/*
 * Decompiled with CFR 0.152.
 */
import com.pi4j.gpio.extension.ads.ADS1115GpioProvider;
import com.pi4j.gpio.extension.ads.ADS1115Pin;
import com.pi4j.gpio.extension.ads.ADS1x15GpioProvider;
import com.pi4j.io.gpio.GpioController;
import com.pi4j.io.gpio.GpioFactory;
import com.pi4j.io.gpio.GpioPinAnalogInput;
import com.pi4j.io.gpio.GpioProvider;
import com.pi4j.io.gpio.event.GpioPinAnalogValueChangeEvent;
import com.pi4j.io.gpio.event.GpioPinListener;
import com.pi4j.io.gpio.event.GpioPinListenerAnalog;
import com.pi4j.io.i2c.I2CFactory;
import java.io.IOException;
import java.text.DecimalFormat;

public class ADS1115GpioExample {
    public static void main(String[] args) throws InterruptedException, I2CFactory.UnsupportedBusNumberException, IOException {
        System.out.println("<--Pi4J--> ADS1115 GPIO Example ... started.");
        final DecimalFormat df = new DecimalFormat("#.##");
        final DecimalFormat pdf = new DecimalFormat("###.#");
        GpioController gpio = GpioFactory.getInstance();
        final ADS1115GpioProvider gpioProvider = new ADS1115GpioProvider(1, 72);
        GpioPinAnalogInput[] myInputs = new GpioPinAnalogInput[]{gpio.provisionAnalogInputPin((GpioProvider)gpioProvider, ADS1115Pin.INPUT_A0, "MyAnalogInput-A0"), gpio.provisionAnalogInputPin((GpioProvider)gpioProvider, ADS1115Pin.INPUT_A1, "MyAnalogInput-A1"), gpio.provisionAnalogInputPin((GpioProvider)gpioProvider, ADS1115Pin.INPUT_A2, "MyAnalogInput-A2"), gpio.provisionAnalogInputPin((GpioProvider)gpioProvider, ADS1115Pin.INPUT_A3, "MyAnalogInput-A3")};
        gpioProvider.setProgrammableGainAmplifier(ADS1x15GpioProvider.ProgrammableGainAmplifierValue.PGA_4_096V, ADS1115Pin.ALL);
        gpioProvider.setEventThreshold(500.0, ADS1115Pin.ALL);
        gpioProvider.setMonitorInterval(100);
        GpioPinListenerAnalog listener = new GpioPinListenerAnalog(){

            public void handleGpioPinAnalogValueChangeEvent(GpioPinAnalogValueChangeEvent event) {
                double value = event.getValue();
                double percent = value * 100.0 / 32767.0;
                double voltage = gpioProvider.getProgrammableGainAmplifier(event.getPin()).getVoltage() * (percent / 100.0);
                System.out.println(" (" + event.getPin().getName() + ") : VOLTS=" + df.format(voltage) + "  | PERCENT=" + pdf.format(percent) + "% | RAW=" + value + "       ");
            }
        };
        myInputs[0].addListener(new GpioPinListener[]{listener});
        myInputs[1].addListener(new GpioPinListener[]{listener});
        myInputs[2].addListener(new GpioPinListener[]{listener});
        myInputs[3].addListener(new GpioPinListener[]{listener});
        Thread.sleep(600000L);
        gpio.shutdown();
        System.out.println("Exiting ADS1115GpioExample");
    }
}

