/*
 * Decompiled with CFR 0.152.
 */
import com.pi4j.io.gpio.GpioController;
import com.pi4j.io.gpio.GpioFactory;
import com.pi4j.io.gpio.GpioPinDigitalInput;
import com.pi4j.io.gpio.GpioPinDigitalOutput;
import com.pi4j.io.gpio.PinPullResistance;
import com.pi4j.io.gpio.PinState;
import com.pi4j.io.gpio.RaspiPin;
import com.pi4j.io.gpio.trigger.GpioBlinkStateTrigger;
import com.pi4j.io.gpio.trigger.GpioBlinkStopStateTrigger;
import com.pi4j.io.gpio.trigger.GpioTrigger;

public class BlinkTriggerGpioExample {
    public static void main(String[] args) throws InterruptedException {
        System.out.println("<--Pi4J--> GPIO Blink Trigger Example ... started.");
        GpioController gpio = GpioFactory.getInstance();
        GpioPinDigitalInput myButton = gpio.provisionDigitalInputPin(RaspiPin.GPIO_02, PinPullResistance.PULL_DOWN);
        System.out.println(" ... complete the GPIO #02 circuit and see the blink trigger take effect.");
        GpioPinDigitalOutput myLed = gpio.provisionDigitalOutputPin(RaspiPin.GPIO_04, PinState.LOW);
        myButton.addTrigger(new GpioTrigger[]{new GpioBlinkStateTrigger(PinState.HIGH, myLed, 250L)});
        myButton.addTrigger(new GpioTrigger[]{new GpioBlinkStopStateTrigger(PinState.LOW, myLed)});
        while (true) {
            Thread.sleep(500L);
        }
    }
}

