/*
 * Decompiled with CFR 0.152.
 */
import com.pi4j.io.gpio.GpioController;
import com.pi4j.io.gpio.GpioFactory;
import com.pi4j.io.gpio.GpioPinDigitalInput;
import com.pi4j.io.gpio.GpioProvider;
import com.pi4j.io.gpio.PinPullResistance;
import com.pi4j.io.gpio.RaspiBcmPin;
import com.pi4j.io.gpio.RaspiGpioProvider;
import com.pi4j.io.gpio.RaspiPinNumberingScheme;
import com.pi4j.io.gpio.event.GpioPinDigitalStateChangeEvent;
import com.pi4j.io.gpio.event.GpioPinListener;
import com.pi4j.io.gpio.event.GpioPinListenerDigital;
import com.pi4j.util.Console;
import com.pi4j.util.ConsoleColor;

public class BroadcomPinNumberingGpioListenerExample {
    public static void main(String[] args) throws InterruptedException {
        System.out.println("<--Pi4J--> GPIO Listener Example ... started.");
        GpioFactory.setDefaultProvider((GpioProvider)new RaspiGpioProvider(RaspiPinNumberingScheme.BROADCOM_PIN_NUMBERING));
        final Console console = new Console();
        console.title(new String[]{"<-- The Pi4J Project -->", "GPIO Listen Example"});
        console.promptForExit();
        GpioController gpio = GpioFactory.getInstance();
        GpioPinDigitalInput myButton = gpio.provisionDigitalInputPin(RaspiBcmPin.GPIO_13, "MyButton", PinPullResistance.PULL_DOWN);
        myButton.setShutdownOptions(Boolean.valueOf(true));
        console.println(" ... Successfully provisioned [" + myButton.getPin() + "] with PULL resistance = [" + myButton.getPin() + "]");
        console.emptyLine();
        console.box(new String[]{"Please complete the [" + myButton.getPin() + "] circuit and see", "the listener feedback here in the console."});
        console.emptyLine();
        myButton.addListener(new GpioPinListener[]{new GpioPinListenerDigital(){

            public void handleGpioPinDigitalStateChangeEvent(GpioPinDigitalStateChangeEvent event) {
                console.println(" --> GPIO PIN STATE CHANGE: " + event.getPin() + " = " + ConsoleColor.conditional((boolean)event.getState().isHigh(), (ConsoleColor)ConsoleColor.GREEN, (ConsoleColor)ConsoleColor.RED, (Object[])new Object[]{event.getState()}));
            }
        }});
        console.waitForExit();
        gpio.shutdown();
    }
}

