/*
 * Decompiled with CFR 0.152.
 */
import com.pi4j.io.gpio.GpioController;
import com.pi4j.io.gpio.GpioFactory;
import com.pi4j.io.gpio.GpioPinDigitalInput;
import com.pi4j.io.gpio.GpioPinInput;
import com.pi4j.io.gpio.Pin;
import com.pi4j.io.gpio.PinPullResistance;
import com.pi4j.io.gpio.RCMPin;
import com.pi4j.io.gpio.RaspiPin;
import com.pi4j.io.gpio.event.GpioPinDigitalStateChangeEvent;
import com.pi4j.io.gpio.event.GpioPinListener;
import com.pi4j.io.gpio.event.GpioPinListenerDigital;
import com.pi4j.platform.PlatformAlreadyAssignedException;
import com.pi4j.system.SystemInfo;
import com.pi4j.util.CommandArgumentParser;
import com.pi4j.util.Console;
import com.pi4j.util.ConsoleColor;
import java.io.IOException;
import java.util.ArrayList;

public class GpioListenAllExample {
    public static void main(String[] args) throws InterruptedException, PlatformAlreadyAssignedException, IOException {
        final Console console = new Console();
        console.title(new String[]{"<-- The Pi4J Project -->", "GPIO Listen (All Pins) Example"});
        console.promptForExit();
        GpioController gpio = GpioFactory.getInstance();
        PinPullResistance pull = CommandArgumentParser.getPinPullResistance((PinPullResistance)PinPullResistance.PULL_UP, (String[])args);
        console.println(" ... please wait; provisioning GPIO pins with resistance [" + pull + "]");
        ArrayList<GpioPinDigitalInput> provisionedPins = new ArrayList<GpioPinDigitalInput>();
        SystemInfo.BoardType board = SystemInfo.getBoardType();
        Pin[] pins = board == SystemInfo.BoardType.RaspberryPi_ComputeModule ? RCMPin.allPins() : RaspiPin.allPins((SystemInfo.BoardType)board);
        for (Pin pin : pins) {
            try {
                GpioPinDigitalInput provisionedPin = gpio.provisionDigitalInputPin(pin, pull);
                provisionedPins.add(provisionedPin);
                provisionedPin.setShutdownOptions(Boolean.valueOf(true));
            }
            catch (Exception ex) {
                System.err.println(ex.getMessage());
            }
        }
        console.println(" ... GPIO pins provisioned and ready for use.");
        console.emptyLine();
        console.box(new String[]{"Please complete the GPIO circuit and see", "the listener feedback here in the console."});
        console.emptyLine();
        gpio.addListener((GpioPinListener)new GpioPinListenerDigital(){

            public void handleGpioPinDigitalStateChangeEvent(GpioPinDigitalStateChangeEvent event) {
                console.println(" --> GPIO PIN STATE CHANGE (EVENT): " + event.getPin() + " = " + ConsoleColor.conditional((boolean)event.getState().isHigh(), (ConsoleColor)ConsoleColor.GREEN, (ConsoleColor)ConsoleColor.RED, (Object[])new Object[]{event.getState()}));
            }
        }, (GpioPinInput[])provisionedPins.toArray(new GpioPinDigitalInput[0]));
        console.waitForExit();
        gpio.shutdown();
    }
}

