/*
 * Decompiled with CFR 0.152.
 */
import com.pi4j.io.gpio.BananaPiPin;
import com.pi4j.io.gpio.BananaProPin;
import com.pi4j.io.gpio.BpiPin;
import com.pi4j.io.gpio.GpioController;
import com.pi4j.io.gpio.GpioFactory;
import com.pi4j.io.gpio.GpioPin;
import com.pi4j.io.gpio.GpioPinDigitalOutput;
import com.pi4j.io.gpio.NanoPiPin;
import com.pi4j.io.gpio.OdroidC1Pin;
import com.pi4j.io.gpio.OrangePiPin;
import com.pi4j.io.gpio.Pin;
import com.pi4j.io.gpio.PinState;
import com.pi4j.io.gpio.RaspiPin;
import com.pi4j.platform.Platform;
import com.pi4j.platform.PlatformAlreadyAssignedException;
import com.pi4j.platform.PlatformManager;
import java.io.IOException;
import java.util.Arrays;
import java.util.Scanner;

public class GpioTest {
    private static boolean exit = false;

    public static void main(String[] args) throws InterruptedException, PlatformAlreadyAssignedException, IOException {
        PlatformManager.setPlatform((Platform)Platform.BANANAPRO);
        Scanner in = new Scanner(System.in);
        GpioController gpio = GpioFactory.getInstance();
        System.out.println("<--Pi4J--> GPIO Test Program ... started.");
        block10: while (!exit) {
            System.out.println();
            System.out.println();
            System.out.println("----------------------------------------");
            System.out.println("SELECT TEST:");
            System.out.println("----------------------------------------");
            System.out.println(" ( O ) GPIO OUTPUTS");
            System.out.println(" ( I ) GPIO INPUTS");
            System.out.println(" ( X ) EXIT");
            System.out.println("----------------------------------------");
            String selection = in.next();
            switch (selection.toUpperCase()) {
                case "O": {
                    GpioTest.gpioOutputsMenu();
                    continue block10;
                }
                case "I": {
                    continue block10;
                }
                case "X": {
                    exit = true;
                    continue block10;
                }
            }
            System.err.println("Invalid Entry, Try Again!");
        }
        in.close();
        System.out.println();
        System.out.println();
        System.out.println("Goodbye!");
        System.out.println();
        System.out.println();
        gpio.shutdown();
    }

    public static void gpioOutputsMenu() {
        System.out.println();
        System.out.println();
        System.out.println("----------------------------------------");
        System.out.println("GPIO OUTPUTS TEST:");
        System.out.println("----------------------------------------");
        switch (PlatformManager.getPlatform()) {
            case RASPBERRYPI: {
                Object[] pins = RaspiPin.allPins();
                Arrays.sort(pins);
                GpioTest.gpioOutputsTest((Pin[])pins);
                break;
            }
            case BANANAPI: {
                Object[] pins = BananaPiPin.allPins();
                Arrays.sort(pins);
                GpioTest.gpioOutputsTest((Pin[])pins);
                break;
            }
            case BANANAPRO: {
                Object[] pins = BananaProPin.allPins();
                Arrays.sort(pins);
                GpioTest.gpioOutputsTest((Pin[])pins);
                break;
            }
            case BPI: {
                Object[] pins = BpiPin.allPins();
                Arrays.sort(pins);
                GpioTest.gpioOutputsTest((Pin[])pins);
                break;
            }
            case NANOPI: {
                Object[] pins = NanoPiPin.allPins();
                Arrays.sort(pins);
                GpioTest.gpioOutputsTest((Pin[])pins);
                break;
            }
            case ODROID: {
                Object[] pins = OdroidC1Pin.allPins();
                Arrays.sort(pins);
                GpioTest.gpioOutputsTest((Pin[])pins);
                break;
            }
            case ORANGEPI: {
                Object[] pins = OrangePiPin.allPins();
                Arrays.sort(pins);
                GpioTest.gpioOutputsTest((Pin[])pins);
                break;
            }
        }
    }

    public static void gpioOutputsTest(Pin[] pins) {
        Scanner in = new Scanner(System.in);
        GpioController gpio = GpioFactory.getInstance();
        for (Pin pin : pins) {
            System.out.println("... provisioning pin: " + pin.toString());
            GpioPinDigitalOutput outputPin = gpio.provisionDigitalOutputPin(pin, PinState.LOW);
            System.out.println(">>> pin: " + pin.toString() + " should be in the LOW state.");
            System.out.println("... press ENTER to continue ...");
            in.next();
            outputPin.high();
            System.out.println(">>> pin: " + pin.toString() + " should be in the HIGH state.");
            System.out.println("... press ENTER to continue ...");
            in.next();
            outputPin.toggle();
            System.out.println(">>> pin: " + pin.toString() + " should be in the LOW state.");
            System.out.println("... press ENTER to continue ...");
            in.next();
            outputPin.blink(1000L);
            System.out.println(">>> pin: " + pin.toString() + " should be blinking 1 time per second.");
            System.out.println("... press ENTER to continue ...");
            in.next();
            outputPin.blink(0L);
            System.out.println("... un-provisioning pin: " + pin.toString());
            gpio.unprovisionPin(new GpioPin[]{outputPin});
        }
        in.close();
    }
}

