/*
 * Decompiled with CFR 0.152.
 */
import com.pi4j.io.i2c.I2CBus;
import com.pi4j.io.i2c.I2CDevice;
import com.pi4j.io.i2c.I2CFactory;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;

public class I2CWiiMotionPlusExample {
    public static void main(String[] args) throws Exception {
        System.out.println("Starting:");
        I2CBus bus = I2CFactory.getInstance((int)1);
        WiiMotionPlus wiiMotionPlus = new WiiMotionPlus(bus);
        wiiMotionPlus.init();
        int iteration = 0;
        I2CWiiMotionPlusExample.makeBackup("log.txt");
        FileWriter logFile = new FileWriter("log.txt");
        BufferedWriter bw = new BufferedWriter(logFile, 2048);
        PrintWriter log = new PrintWriter(bw);
        try {
            while (true) {
                long now = System.currentTimeMillis();
                ThreeAxis threeAxis = wiiMotionPlus.read();
                long lasted = System.currentTimeMillis() - now;
                System.out.print(I2CWiiMotionPlusExample.formatInt(iteration));
                System.out.print(' ');
                System.out.print(I2CWiiMotionPlusExample.formatLong(lasted));
                System.out.print(' ');
                System.out.print(I2CWiiMotionPlusExample.formatInt(threeAxis.x));
                System.out.print(' ');
                System.out.print(I2CWiiMotionPlusExample.formatInt(threeAxis.y));
                System.out.print(' ');
                System.out.print(I2CWiiMotionPlusExample.formatInt(threeAxis.z));
                System.out.print(' ');
                System.out.println();
                log.println(I2CWiiMotionPlusExample.formatInt(iteration) + "," + I2CWiiMotionPlusExample.formatLong(lasted) + "," + I2CWiiMotionPlusExample.formatInt(threeAxis.x) + "," + I2CWiiMotionPlusExample.formatInt(threeAxis.y) + "," + I2CWiiMotionPlusExample.formatInt(threeAxis.z));
                Thread.sleep(500L);
                ++iteration;
            }
        }
        catch (Throwable throwable) {
            bw.flush();
            bw.close();
            logFile.close();
            throw throwable;
        }
    }

    public static void makeBackup(String filename) {
        int i = 1;
        File f = new File(filename + "." + i);
        while (f.exists()) {
            f = new File(filename + "." + ++i);
        }
        for (int j = i; j >= 1; --j) {
            File to = new File(filename + "." + j);
            File from = new File(filename + "." + (j - 1));
            if (j == 1) {
                from = new File(filename);
            }
            from.renameTo(to);
        }
    }

    public static String formatInt(int i) {
        String x = "         " + Integer.toString(i);
        x = x.substring(x.length() - 6, x.length());
        return x;
    }

    public static String formatLong(long i) {
        String x = "         " + Long.toString(i);
        x = x.substring(x.length() - 6, x.length());
        return x;
    }

    public static class ThreeAxis {
        public int x;
        public int y;
        public int z;
    }

    public static class WiiMotionPlus {
        private I2CDevice initDevice;
        private I2CDevice device;

        public WiiMotionPlus(I2CBus bus) throws IOException {
            this.initDevice = bus.getDevice(83);
            this.device = bus.getDevice(82);
        }

        public void init() {
            try {
                this.initDevice.write(254, (byte)4);
            }
            catch (IOException ignore) {
                ignore.printStackTrace();
            }
        }

        public ThreeAxis read() throws IOException {
            byte[] buf = new byte[256];
            int res = this.device.read(0, buf, 0, 6);
            if (res != 6) {
                throw new RuntimeException("Read failure - got only " + res + " bytes from WiiMotionPlus");
            }
            ThreeAxis ret = new ThreeAxis();
            ret.x = this.asInt(buf[0]);
            ret.y = this.asInt(buf[1]);
            ret.z = this.asInt(buf[2]);
            ret.x |= ((this.asInt(buf[3]) & 0xFC) >> 2) * 256;
            ret.y |= ((this.asInt(buf[4]) & 0xFC) >> 2) * 256;
            ret.z |= ((this.asInt(buf[5]) & 0xFC) >> 2) * 256;
            return ret;
        }

        private int asInt(byte b) {
            int i = b;
            if (i < 0) {
                i += 256;
            }
            return i;
        }
    }
}

