/*
 * Decompiled with CFR 0.152.
 */
import com.pi4j.io.gpio.GpioController;
import com.pi4j.io.gpio.GpioFactory;
import com.pi4j.io.gpio.GpioPinDigitalInput;
import com.pi4j.io.gpio.PinPullResistance;
import com.pi4j.io.gpio.PinState;
import com.pi4j.io.gpio.RaspiPin;
import com.pi4j.io.gpio.event.IFTTTMakerChannelTriggerEvent;
import com.pi4j.io.gpio.event.IFTTTMakerChannelTriggerListener;
import com.pi4j.io.gpio.trigger.GpioTrigger;
import com.pi4j.io.gpio.trigger.IFTTTMakerChannelTrigger;
import com.pi4j.util.Console;

public class IFTTTMakerChannelTriggerExample {
    public static String IFTTT_MAKER_CHANNEL_API_KEY = "lyekJ_ZnpzXIMYpZiPaeXzMzpqGqX0KKLGWCwJYevgx";
    public static String IFTTT_MAKER_CHANNEL_EVENT_NAME = "pi4j";

    public static void main(String[] args) throws InterruptedException {
        final Console console = new Console();
        console.title(new String[]{"<-- The Pi4J Project -->", "IFTTT Maker Channel Trigger Example"});
        console.promptForExit();
        GpioController gpio = GpioFactory.getInstance();
        GpioPinDigitalInput input = gpio.provisionDigitalInputPin(RaspiPin.GPIO_00, "MyInputPin", PinPullResistance.PULL_DOWN);
        input.setDebounce(500);
        input.addTrigger(new GpioTrigger[]{new IFTTTMakerChannelTrigger(IFTTT_MAKER_CHANNEL_API_KEY, IFTTT_MAKER_CHANNEL_EVENT_NAME, PinState.HIGH, new IFTTTMakerChannelTriggerListener(){

            public boolean onTriggered(IFTTTMakerChannelTriggerEvent event) {
                if (event.getValue2().equals("1")) {
                    event.setValue2("ON");
                } else {
                    event.setValue2("OFF");
                }
                console.println(" --> IFTTT MAKER CHANNEL EVENT TRIGGER");
                console.println("     - GPIO PIN            : " + event.getPin());
                console.println("     - PIN STATE           : " + event.getState());
                console.println("     - IFTTT EVENT NAME    : " + event.getEventName());
                console.println("     - IFTTT EVENT VALUE 1 : " + event.getValue1());
                console.println("     - IFTTT EVENT VALUE 2 : " + event.getValue2());
                console.println("     - IFTTT EVENT VALUE 3 : " + event.getValue3());
                console.emptyLine();
                return true;
            }
        })});
        input.setShutdownOptions(Boolean.valueOf(true));
        console.println("Successfully provisioned [" + input + "] with PULL resistance = [" + input.getPullResistance() + "]");
        console.emptyLine();
        console.waitForExit();
        gpio.shutdown();
    }
}

