/*
 * Decompiled with CFR 0.152.
 */
import com.pi4j.component.lcd.LCDTextAlignment;
import com.pi4j.component.lcd.impl.GpioLcdDisplay;
import com.pi4j.io.gpio.GpioController;
import com.pi4j.io.gpio.GpioFactory;
import com.pi4j.io.gpio.GpioPinDigital;
import com.pi4j.io.gpio.GpioPinDigitalInput;
import com.pi4j.io.gpio.GpioPinInput;
import com.pi4j.io.gpio.Pin;
import com.pi4j.io.gpio.PinPullResistance;
import com.pi4j.io.gpio.PinState;
import com.pi4j.io.gpio.RaspiPin;
import com.pi4j.io.gpio.event.GpioPinDigitalStateChangeEvent;
import com.pi4j.io.gpio.event.GpioPinListener;
import com.pi4j.io.gpio.event.GpioPinListenerDigital;
import java.text.SimpleDateFormat;
import java.util.Date;

public class LcdExample {
    public static final int LCD_ROWS = 2;
    public static final int LCD_ROW_1 = 0;
    public static final int LCD_ROW_2 = 1;
    public static final int LCD_COLUMNS = 16;
    public static final int LCD_BITS = 4;

    public static void main(String[] args) throws InterruptedException {
        int index;
        System.out.println("<--Pi4J--> GPIO 4 bit LCD example program");
        GpioController gpio = GpioFactory.getInstance();
        final GpioLcdDisplay lcd = new GpioLcdDisplay(2, 16, RaspiPin.GPIO_11, RaspiPin.GPIO_10, new Pin[]{RaspiPin.GPIO_00, RaspiPin.GPIO_01, RaspiPin.GPIO_02, RaspiPin.GPIO_03});
        GpioPinDigitalInput[] myButtons = new GpioPinDigitalInput[]{gpio.provisionDigitalInputPin(RaspiPin.GPIO_13, "B1", PinPullResistance.PULL_UP), gpio.provisionDigitalInputPin(RaspiPin.GPIO_07, "B2", PinPullResistance.PULL_UP), gpio.provisionDigitalInputPin(RaspiPin.GPIO_04, "B3", PinPullResistance.PULL_UP), gpio.provisionDigitalInputPin(RaspiPin.GPIO_12, "B4", PinPullResistance.PULL_UP)};
        gpio.addListener((GpioPinListener)new GpioPinListenerDigital(){

            public void handleGpioPinDigitalStateChangeEvent(GpioPinDigitalStateChangeEvent event) {
                if (event.getState() == PinState.LOW) {
                    lcd.writeln(1, event.getPin().getName() + " PRESSED", LCDTextAlignment.ALIGN_CENTER);
                } else {
                    lcd.writeln(1, event.getPin().getName() + " RELEASED", LCDTextAlignment.ALIGN_CENTER);
                }
            }
        }, (GpioPinInput[])myButtons);
        lcd.clear();
        Thread.sleep(1000L);
        lcd.write(0, "The Pi4J Project");
        lcd.write(1, "----------------");
        for (index = 0; index < 5; ++index) {
            lcd.write(1, "----------------");
            Thread.sleep(500L);
            lcd.write(1, "****************");
            Thread.sleep(500L);
        }
        lcd.write(1, "----------------");
        for (index = 0; index < lcd.getColumnCount(); ++index) {
            lcd.write(1, index, ">");
            if (index > 0) {
                lcd.write(1, index - 1, "-");
            }
            Thread.sleep(300L);
        }
        for (index = lcd.getColumnCount() - 1; index >= 0; --index) {
            lcd.write(1, index, "<");
            if (index < lcd.getColumnCount() - 1) {
                lcd.write(1, index + 1, "-");
            }
            Thread.sleep(300L);
        }
        lcd.write(1, "----------------");
        Thread.sleep(500L);
        lcd.writeln(1, "<< LEFT");
        Thread.sleep(1000L);
        lcd.write(1, "----------------");
        Thread.sleep(500L);
        lcd.writeln(1, "RIGHT >>", LCDTextAlignment.ALIGN_RIGHT);
        Thread.sleep(1000L);
        lcd.write(1, "----------------");
        Thread.sleep(500L);
        lcd.writeln(1, "<< CENTER >>", LCDTextAlignment.ALIGN_CENTER);
        Thread.sleep(1000L);
        lcd.write(1, "----------------");
        Thread.sleep(500L);
        lcd.write(1, "<L>", LCDTextAlignment.ALIGN_LEFT);
        lcd.write(1, "<R>", LCDTextAlignment.ALIGN_RIGHT);
        lcd.write(1, "CC", LCDTextAlignment.ALIGN_CENTER);
        Thread.sleep(3000L);
        SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss");
        while (true) {
            if (gpio.isHigh((GpioPinDigital[])myButtons)) {
                lcd.writeln(1, formatter.format(new Date()), LCDTextAlignment.ALIGN_CENTER);
            }
            Thread.sleep(1000L);
        }
    }
}

