/*
 * Decompiled with CFR 0.152.
 */
import com.pi4j.gpio.extension.mcp.MCP23017GpioProvider;
import com.pi4j.gpio.extension.mcp.MCP23017Pin;
import com.pi4j.io.gpio.GpioController;
import com.pi4j.io.gpio.GpioFactory;
import com.pi4j.io.gpio.GpioPinDigitalInput;
import com.pi4j.io.gpio.GpioPinDigitalOutput;
import com.pi4j.io.gpio.GpioPinInput;
import com.pi4j.io.gpio.GpioProvider;
import com.pi4j.io.gpio.PinPullResistance;
import com.pi4j.io.gpio.PinState;
import com.pi4j.io.gpio.event.GpioPinDigitalStateChangeEvent;
import com.pi4j.io.gpio.event.GpioPinListener;
import com.pi4j.io.gpio.event.GpioPinListenerDigital;
import com.pi4j.io.i2c.I2CFactory;
import java.io.IOException;

public class MCP23017GpioExample {
    public static void main(String[] args) throws InterruptedException, I2CFactory.UnsupportedBusNumberException, IOException {
        System.out.println("<--Pi4J--> MCP23017 GPIO Example ... started.");
        GpioController gpio = GpioFactory.getInstance();
        MCP23017GpioProvider provider = new MCP23017GpioProvider(1, 33);
        GpioPinDigitalInput[] myInputs = new GpioPinDigitalInput[]{gpio.provisionDigitalInputPin((GpioProvider)provider, MCP23017Pin.GPIO_A0, "MyInput-A0", PinPullResistance.PULL_UP), gpio.provisionDigitalInputPin((GpioProvider)provider, MCP23017Pin.GPIO_A1, "MyInput-A1", PinPullResistance.PULL_UP), gpio.provisionDigitalInputPin((GpioProvider)provider, MCP23017Pin.GPIO_A2, "MyInput-A2", PinPullResistance.PULL_UP), gpio.provisionDigitalInputPin((GpioProvider)provider, MCP23017Pin.GPIO_A3, "MyInput-A3", PinPullResistance.PULL_UP), gpio.provisionDigitalInputPin((GpioProvider)provider, MCP23017Pin.GPIO_A4, "MyInput-A4", PinPullResistance.PULL_UP), gpio.provisionDigitalInputPin((GpioProvider)provider, MCP23017Pin.GPIO_A5, "MyInput-A5", PinPullResistance.PULL_UP), gpio.provisionDigitalInputPin((GpioProvider)provider, MCP23017Pin.GPIO_A6, "MyInput-A6", PinPullResistance.PULL_UP), gpio.provisionDigitalInputPin((GpioProvider)provider, MCP23017Pin.GPIO_A7, "MyInput-A7", PinPullResistance.PULL_UP)};
        gpio.addListener((GpioPinListener)new GpioPinListenerDigital(){

            public void handleGpioPinDigitalStateChangeEvent(GpioPinDigitalStateChangeEvent event) {
                System.out.println(" --> GPIO PIN STATE CHANGE: " + event.getPin() + " = " + event.getState());
            }
        }, (GpioPinInput[])myInputs);
        GpioPinDigitalOutput[] myOutputs = new GpioPinDigitalOutput[]{gpio.provisionDigitalOutputPin((GpioProvider)provider, MCP23017Pin.GPIO_B0, "MyOutput-B0", PinState.LOW), gpio.provisionDigitalOutputPin((GpioProvider)provider, MCP23017Pin.GPIO_B1, "MyOutput-B1", PinState.LOW), gpio.provisionDigitalOutputPin((GpioProvider)provider, MCP23017Pin.GPIO_B2, "MyOutput-B2", PinState.LOW), gpio.provisionDigitalOutputPin((GpioProvider)provider, MCP23017Pin.GPIO_B3, "MyOutput-B3", PinState.LOW), gpio.provisionDigitalOutputPin((GpioProvider)provider, MCP23017Pin.GPIO_B4, "MyOutput-B4", PinState.LOW), gpio.provisionDigitalOutputPin((GpioProvider)provider, MCP23017Pin.GPIO_B5, "MyOutput-B5", PinState.LOW), gpio.provisionDigitalOutputPin((GpioProvider)provider, MCP23017Pin.GPIO_B6, "MyOutput-B6", PinState.LOW), gpio.provisionDigitalOutputPin((GpioProvider)provider, MCP23017Pin.GPIO_B7, "MyOutput-B7", PinState.LOW)};
        for (int count = 0; count < 10; ++count) {
            gpio.setState(true, myOutputs);
            Thread.sleep(1000L);
            gpio.setState(false, myOutputs);
            Thread.sleep(1000L);
        }
        gpio.shutdown();
        System.out.println("Exiting MCP23017GpioExample");
    }
}

