/*
 * Decompiled with CFR 0.152.
 */
import com.pi4j.gpio.extension.mcp.MCP23S17GpioProvider;
import com.pi4j.gpio.extension.mcp.MCP23S17Pin;
import com.pi4j.io.gpio.GpioController;
import com.pi4j.io.gpio.GpioFactory;
import com.pi4j.io.gpio.GpioPinDigitalInput;
import com.pi4j.io.gpio.GpioPinDigitalOutput;
import com.pi4j.io.gpio.GpioPinInput;
import com.pi4j.io.gpio.GpioProvider;
import com.pi4j.io.gpio.PinPullResistance;
import com.pi4j.io.gpio.PinState;
import com.pi4j.io.gpio.event.GpioPinDigitalStateChangeEvent;
import com.pi4j.io.gpio.event.GpioPinListener;
import com.pi4j.io.gpio.event.GpioPinListenerDigital;
import com.pi4j.io.spi.SpiChannel;
import java.io.IOException;

public class MCP23S17GpioExample {
    public static void main(String[] args) throws InterruptedException, IOException {
        System.out.println("<--Pi4J--> MCP23S17 GPIO Example ... started.");
        GpioController gpio = GpioFactory.getInstance();
        MCP23S17GpioProvider provider = new MCP23S17GpioProvider(64, SpiChannel.CS0);
        GpioPinDigitalInput[] myInputs = new GpioPinDigitalInput[]{gpio.provisionDigitalInputPin((GpioProvider)provider, MCP23S17Pin.GPIO_B0, "MyInput-B0", PinPullResistance.PULL_UP), gpio.provisionDigitalInputPin((GpioProvider)provider, MCP23S17Pin.GPIO_B1, "MyInput-B1", PinPullResistance.PULL_UP), gpio.provisionDigitalInputPin((GpioProvider)provider, MCP23S17Pin.GPIO_B2, "MyInput-B2", PinPullResistance.PULL_UP), gpio.provisionDigitalInputPin((GpioProvider)provider, MCP23S17Pin.GPIO_B3, "MyInput-B3", PinPullResistance.PULL_UP), gpio.provisionDigitalInputPin((GpioProvider)provider, MCP23S17Pin.GPIO_B4, "MyInput-B4", PinPullResistance.PULL_UP), gpio.provisionDigitalInputPin((GpioProvider)provider, MCP23S17Pin.GPIO_B5, "MyInput-B5", PinPullResistance.PULL_UP), gpio.provisionDigitalInputPin((GpioProvider)provider, MCP23S17Pin.GPIO_B6, "MyInput-B6", PinPullResistance.PULL_UP), gpio.provisionDigitalInputPin((GpioProvider)provider, MCP23S17Pin.GPIO_B7, "MyInput-B7", PinPullResistance.PULL_UP)};
        gpio.addListener((GpioPinListener)new GpioPinListenerDigital(){

            public void handleGpioPinDigitalStateChangeEvent(GpioPinDigitalStateChangeEvent event) {
                System.out.println(" --> GPIO PIN STATE CHANGE: " + event.getPin() + " = " + event.getState());
            }
        }, (GpioPinInput[])myInputs);
        GpioPinDigitalOutput[] myOutputs = new GpioPinDigitalOutput[]{gpio.provisionDigitalOutputPin((GpioProvider)provider, MCP23S17Pin.GPIO_A0, "MyOutput-A0", PinState.LOW), gpio.provisionDigitalOutputPin((GpioProvider)provider, MCP23S17Pin.GPIO_A1, "MyOutput-A1", PinState.LOW), gpio.provisionDigitalOutputPin((GpioProvider)provider, MCP23S17Pin.GPIO_A2, "MyOutput-A2", PinState.LOW), gpio.provisionDigitalOutputPin((GpioProvider)provider, MCP23S17Pin.GPIO_A3, "MyOutput-A3", PinState.LOW), gpio.provisionDigitalOutputPin((GpioProvider)provider, MCP23S17Pin.GPIO_A4, "MyOutput-A4", PinState.LOW), gpio.provisionDigitalOutputPin((GpioProvider)provider, MCP23S17Pin.GPIO_A5, "MyOutput-A5", PinState.LOW), gpio.provisionDigitalOutputPin((GpioProvider)provider, MCP23S17Pin.GPIO_A6, "MyOutput-A6", PinState.LOW), gpio.provisionDigitalOutputPin((GpioProvider)provider, MCP23S17Pin.GPIO_A7, "MyOutput-A7", PinState.LOW)};
        for (int count = 0; count < 10; ++count) {
            gpio.setState(true, myOutputs);
            Thread.sleep(1000L);
            gpio.setState(false, myOutputs);
            Thread.sleep(1000L);
        }
        gpio.shutdown();
        System.out.println("Exiting MCP23S17GpioExample");
    }
}

