/*
 * Decompiled with CFR 0.152.
 */
import com.pi4j.gpio.extension.mcp.MCP3424GpioProvider;
import com.pi4j.gpio.extension.mcp.MCP3424Pin;
import com.pi4j.io.gpio.GpioController;
import com.pi4j.io.gpio.GpioFactory;
import com.pi4j.io.gpio.GpioPin;
import com.pi4j.io.gpio.GpioPinAnalogInput;
import com.pi4j.io.gpio.GpioPinInput;
import com.pi4j.io.gpio.GpioProvider;
import com.pi4j.io.gpio.event.GpioPinAnalogValueChangeEvent;
import com.pi4j.io.gpio.event.GpioPinListener;
import com.pi4j.io.gpio.event.GpioPinListenerAnalog;
import com.pi4j.io.i2c.I2CFactory;
import java.io.IOException;

public class MCP3424GpioExample {
    public static void main(String[] args) throws InterruptedException, I2CFactory.UnsupportedBusNumberException, IOException {
        System.out.println("<--Pi4J--> MCP3424 GPIO Example ... started.");
        GpioController gpio = GpioFactory.getInstance();
        final MCP3424GpioProvider provider = new MCP3424GpioProvider(1, 108, 18, 1);
        GpioPinAnalogInput[] inputs = new GpioPinAnalogInput[]{gpio.provisionAnalogInputPin((GpioProvider)provider, MCP3424Pin.GPIO_CH0, "Channel-0"), gpio.provisionAnalogInputPin((GpioProvider)provider, MCP3424Pin.GPIO_CH1, "Channel-1"), gpio.provisionAnalogInputPin((GpioProvider)provider, MCP3424Pin.GPIO_CH2, "Channel-2"), gpio.provisionAnalogInputPin((GpioProvider)provider, MCP3424Pin.GPIO_CH3, "Channel-3")};
        provider.setEventThreshold(0.0, inputs);
        for (GpioPinAnalogInput input : inputs) {
            System.out.print("<INITIAL VALUE> [" + input.getName() + "] : RAW VALUE = " + input.getValue());
            System.out.println(" -> " + provider.getAnalogValue(input.getPin()) + " V");
        }
        gpio.addListener((GpioPinListener)new GpioPinListenerAnalog(){

            public void handleGpioPinAnalogValueChangeEvent(GpioPinAnalogValueChangeEvent event) {
                GpioPin pin = event.getPin();
                double value = event.getValue();
                double analog = provider.getAnalogValue(pin.getPin());
                System.out.print("<CHANGED VALUE> [" + pin + "] : RAW VALUE = " + value);
                System.out.println(" -> " + analog + " V");
            }
        }, (GpioPinInput[])inputs);
        provider.setMonitorInterval(50);
        provider.setMonitorEnabled(true);
        for (int count = 0; count < 600; ++count) {
            Thread.sleep(1000L);
        }
        gpio.shutdown();
        System.out.println("<--Pi4J--> Exiting MCP3424 GPIO Example.");
    }
}

