/*
 * Decompiled with CFR 0.152.
 */
import com.pi4j.gpio.extension.mcp.MCP3424GpioProvider;
import com.pi4j.gpio.extension.mcp.MCP3424Pin;
import com.pi4j.io.gpio.GpioController;
import com.pi4j.io.gpio.GpioFactory;
import com.pi4j.io.gpio.GpioPinAnalogInput;
import com.pi4j.io.gpio.GpioProvider;
import com.pi4j.io.i2c.I2CFactory;
import java.io.IOException;

public class MCP3424GpioExampleNonMonitored {
    public static void main(String[] args) throws InterruptedException, I2CFactory.UnsupportedBusNumberException, IOException {
        System.out.println("<--Pi4J--> MCP3424 GPIO Example ... started.");
        GpioController gpio = GpioFactory.getInstance();
        MCP3424GpioProvider provider = new MCP3424GpioProvider(1, 108, 18, 1);
        GpioPinAnalogInput[] inputs = new GpioPinAnalogInput[]{gpio.provisionAnalogInputPin((GpioProvider)provider, MCP3424Pin.GPIO_CH0, "Channel-0"), gpio.provisionAnalogInputPin((GpioProvider)provider, MCP3424Pin.GPIO_CH1, "Channel-1"), gpio.provisionAnalogInputPin((GpioProvider)provider, MCP3424Pin.GPIO_CH2, "Channel-2"), gpio.provisionAnalogInputPin((GpioProvider)provider, MCP3424Pin.GPIO_CH3, "Channel-3")};
        for (int count = 0; count < 600; ++count) {
            StringBuilder sb = new StringBuilder();
            for (GpioPinAnalogInput input : inputs) {
                double analog = provider.getAnalogValue(input.getPin());
                sb.append(" \t[" + input.getValue() + " -> " + analog + " V] ");
            }
            System.out.println("<MCP3424 VALUES> " + sb.toString());
            Thread.sleep(1000L);
        }
        gpio.shutdown();
        System.out.println("<--Pi4J--> Exiting MCP3424 GPIO Example.");
    }
}

