/*
 * Decompiled with CFR 0.152.
 */
import com.pi4j.io.gpio.GpioController;
import com.pi4j.io.gpio.GpioFactory;
import com.pi4j.io.gpio.GpioPinDigitalMultipurpose;
import com.pi4j.io.gpio.PinMode;
import com.pi4j.io.gpio.PinPullResistance;
import com.pi4j.io.gpio.RaspiPin;
import com.pi4j.io.gpio.event.GpioPinDigitalStateChangeEvent;
import com.pi4j.io.gpio.event.GpioPinListener;
import com.pi4j.io.gpio.event.GpioPinListenerDigital;

public class MultipurposePinGpioExample {
    public static void main(String[] args) throws InterruptedException {
        System.out.println("<--Pi4J--> GPIO Multipurpose Pin Example ... started.");
        GpioController gpio = GpioFactory.getInstance();
        GpioPinDigitalMultipurpose pin = gpio.provisionDigitalMultipurposePin(RaspiPin.GPIO_02, PinMode.DIGITAL_INPUT, PinPullResistance.PULL_DOWN);
        pin.addListener(new GpioPinListener[]{new GpioPinListenerDigital(){

            public void handleGpioPinDigitalStateChangeEvent(GpioPinDigitalStateChangeEvent event) {
                System.out.println(" --> GPIO PIN STATE CHANGE: " + event.getPin() + " = " + event.getState());
            }
        }});
        System.out.println(" ... complete the GPIO #02 circuit and see the listener feedback here in the console.");
        while (true) {
            Thread.sleep(5000L);
            pin.setMode(PinMode.DIGITAL_OUTPUT);
            System.out.println(" --> GPIO PIN - RECONFIGURED AS OUPUT PIN");
            pin.pulse(1000L, true);
            pin.setMode(PinMode.DIGITAL_INPUT);
            System.out.println(" --> GPIO PIN - RECONFIGURED AS INPUT PIN");
        }
    }
}

