/*
 * Decompiled with CFR 0.152.
 */
import com.pi4j.io.gpio.GpioController;
import com.pi4j.io.gpio.GpioFactory;
import com.pi4j.io.gpio.GpioPinDigitalInput;
import com.pi4j.io.gpio.GpioPinDigitalOutput;
import com.pi4j.io.gpio.PinPullResistance;
import com.pi4j.io.gpio.PinState;
import com.pi4j.io.gpio.RaspiPin;
import com.pi4j.io.gpio.event.GpioPinDigitalStateChangeEvent;
import com.pi4j.io.gpio.event.GpioPinListener;
import com.pi4j.io.gpio.event.GpioPinListenerDigital;
import com.pi4j.wiringpi.GpioUtil;

public class NonPrivilegedGpioExample {
    public static void main(String[] args) throws InterruptedException {
        System.out.println("<--Pi4J--> Non-Privileged GPIO Example ... started.");
        if (GpioUtil.isPrivilegedAccessRequired()) {
            System.err.println("*****************************************************************");
            System.err.println("Privileged access is required on this system to access GPIO pins!");
            System.err.println("*****************************************************************");
            return;
        }
        GpioUtil.enableNonPrivilegedAccess();
        GpioController gpio = GpioFactory.getInstance();
        GpioPinDigitalOutput output = gpio.provisionDigitalOutputPin(RaspiPin.GPIO_01);
        output.setShutdownOptions(Boolean.valueOf(true), PinState.LOW);
        output.blink(1000L);
        System.out.println("Pin [" + output.getName() + "] should be blinking/toggling every 1 second.");
        GpioPinDigitalInput input = gpio.provisionDigitalInputPin(RaspiPin.GPIO_02, PinPullResistance.PULL_DOWN);
        input.setShutdownOptions(Boolean.valueOf(true));
        input.addListener(new GpioPinListener[]{new GpioPinListenerDigital(){

            public void handleGpioPinDigitalStateChangeEvent(GpioPinDigitalStateChangeEvent event) {
                System.out.println(" --> GPIO PIN STATE CHANGE: " + event.getPin() + " = " + event.getState());
            }
        }});
        System.out.println("You can connect pin [" + input.getName() + "] to +3VDC to capture input state changes.");
        Thread.sleep(60000L);
        gpio.shutdown();
        System.out.println("Exiting NonPrivilegedGpioExample");
    }
}

