/*
 * Decompiled with CFR 0.152.
 */
import com.pi4j.gpio.extension.olimex.OlimexAVRIOGpioProvider;
import com.pi4j.gpio.extension.olimex.OlimexAVRIOPin;
import com.pi4j.io.gpio.GpioController;
import com.pi4j.io.gpio.GpioFactory;
import com.pi4j.io.gpio.GpioPinDigitalInput;
import com.pi4j.io.gpio.GpioPinDigitalOutput;
import com.pi4j.io.gpio.GpioProvider;
import com.pi4j.io.gpio.PinPullResistance;
import com.pi4j.io.gpio.PinState;
import com.pi4j.io.gpio.RaspiPin;
import com.pi4j.io.gpio.event.GpioPinDigitalStateChangeEvent;
import com.pi4j.io.gpio.event.GpioPinListener;
import com.pi4j.io.gpio.event.GpioPinListenerDigital;
import com.pi4j.io.gpio.trigger.GpioPulseStateTrigger;
import com.pi4j.io.gpio.trigger.GpioSetStateTrigger;
import com.pi4j.io.gpio.trigger.GpioSyncStateTrigger;
import com.pi4j.io.gpio.trigger.GpioTrigger;
import java.io.IOException;

public class OlimexGpioExample {
    public static void main(String[] args) throws InterruptedException, IOException {
        System.out.println("<--Pi4J--> GPIO Listen Example ... started.");
        GpioController gpio = GpioFactory.getInstance();
        GpioPinDigitalInput myButton = gpio.provisionDigitalInputPin(RaspiPin.GPIO_02, PinPullResistance.PULL_DOWN);
        OlimexAVRIOGpioProvider olimexProvider = new OlimexAVRIOGpioProvider("/dev/ttyAMA0");
        GpioPinDigitalInput myInput = gpio.provisionDigitalInputPin((GpioProvider)olimexProvider, OlimexAVRIOPin.IN_01);
        GpioPinListenerDigital listener = new GpioPinListenerDigital(){

            public void handleGpioPinDigitalStateChangeEvent(GpioPinDigitalStateChangeEvent event) {
                System.out.println(" --> GPIO PIN STATE CHANGE: " + event.getPin() + " = " + event.getState());
            }
        };
        myButton.addListener(new GpioPinListener[]{listener});
        myInput.addListener(new GpioPinListener[]{listener});
        GpioPinDigitalOutput[] myRelays = new GpioPinDigitalOutput[]{gpio.provisionDigitalOutputPin((GpioProvider)olimexProvider, OlimexAVRIOPin.RELAY_01, "RELAY #1", PinState.LOW), gpio.provisionDigitalOutputPin((GpioProvider)olimexProvider, OlimexAVRIOPin.RELAY_02, "RELAY #2", PinState.LOW), gpio.provisionDigitalOutputPin((GpioProvider)olimexProvider, OlimexAVRIOPin.RELAY_03, "RELAY #3", PinState.LOW), gpio.provisionDigitalOutputPin((GpioProvider)olimexProvider, OlimexAVRIOPin.RELAY_04, "RELAY #4", PinState.LOW)};
        myButton.addTrigger(new GpioTrigger[]{new GpioSetStateTrigger(PinState.HIGH, myRelays[0], PinState.HIGH)});
        myButton.addTrigger(new GpioTrigger[]{new GpioSetStateTrigger(PinState.LOW, myRelays[0], PinState.LOW)});
        myButton.addTrigger(new GpioTrigger[]{new GpioSyncStateTrigger(myRelays[1])});
        myButton.addTrigger(new GpioTrigger[]{new GpioSyncStateTrigger(myRelays[2])});
        myButton.addTrigger(new GpioTrigger[]{new GpioPulseStateTrigger(PinState.HIGH, myRelays[3], 1000L)});
        System.out.println(" ... complete the GPIO #02 circuit and see the listener feedback here in the console.");
        Thread.sleep(60000L);
        gpio.shutdown();
        System.out.println("Exiting OlimexGpioExample");
    }
}

