/*
 * Decompiled with CFR 0.152.
 */
import com.pi4j.gpio.extension.pca.PCA9685GpioProvider;
import com.pi4j.gpio.extension.pca.PCA9685Pin;
import com.pi4j.io.gpio.GpioController;
import com.pi4j.io.gpio.GpioFactory;
import com.pi4j.io.gpio.GpioPinPwmOutput;
import com.pi4j.io.gpio.GpioProvider;
import com.pi4j.io.gpio.Pin;
import com.pi4j.io.i2c.I2CBus;
import com.pi4j.io.i2c.I2CFactory;
import java.math.BigDecimal;
import java.util.Scanner;

public class PCA9685GpioExample {
    private static final int SERVO_DURATION_MIN = 900;
    private static final int SERVO_DURATION_NEUTRAL = 1500;
    private static final int SERVO_DURATION_MAX = 2100;

    public static void main(String[] args) throws Exception {
        System.out.println("<--Pi4J--> PCA9685 PWM Example ... started.");
        BigDecimal frequency = new BigDecimal("48.828");
        BigDecimal frequencyCorrectionFactor = new BigDecimal("1.0578");
        I2CBus bus = I2CFactory.getInstance((int)1);
        PCA9685GpioProvider provider = new PCA9685GpioProvider(bus, 64, frequency, frequencyCorrectionFactor);
        GpioPinPwmOutput[] myOutputs = PCA9685GpioExample.provisionPwmOutputs(provider);
        provider.reset();
        int offset = 400;
        int pulseDuration = 600;
        for (int i = 0; i < 10; ++i) {
            Pin pin = PCA9685Pin.ALL[i];
            int onPosition = PCA9685GpioExample.checkForOverflow(400 * i);
            int offPosition = PCA9685GpioExample.checkForOverflow(600 * (i + 1));
            provider.setPwm(pin, onPosition, offPosition);
        }
        provider.setAlwaysOn(PCA9685Pin.PWM_10);
        provider.setAlwaysOff(PCA9685Pin.PWM_11);
        provider.setPwm(PCA9685Pin.PWM_12, 900);
        provider.setPwm(PCA9685Pin.PWM_13, 1500);
        provider.setPwm(PCA9685Pin.PWM_14, 2100);
        for (GpioPinPwmOutput output : myOutputs) {
            int[] onOffValues = provider.getPwmOnOffValues(output.getPin());
            System.out.println(output.getPin().getName() + " (" + output.getName() + "): ON value [" + onOffValues[0] + "], OFF value [" + onOffValues[1] + "]");
        }
        System.out.println("Press <Enter> to terminate...");
        new Scanner(System.in).nextLine();
        System.out.println("Exiting PCA9685GpioExample");
    }

    private static int checkForOverflow(int position) {
        int result = position;
        if (position > 4095) {
            result = position - 4096 - 1;
        }
        return result;
    }

    private static GpioPinPwmOutput[] provisionPwmOutputs(PCA9685GpioProvider gpioProvider) {
        GpioController gpio = GpioFactory.getInstance();
        GpioPinPwmOutput[] myOutputs = new GpioPinPwmOutput[]{gpio.provisionPwmOutputPin((GpioProvider)gpioProvider, PCA9685Pin.PWM_00, "Pulse 00"), gpio.provisionPwmOutputPin((GpioProvider)gpioProvider, PCA9685Pin.PWM_01, "Pulse 01"), gpio.provisionPwmOutputPin((GpioProvider)gpioProvider, PCA9685Pin.PWM_02, "Pulse 02"), gpio.provisionPwmOutputPin((GpioProvider)gpioProvider, PCA9685Pin.PWM_03, "Pulse 03"), gpio.provisionPwmOutputPin((GpioProvider)gpioProvider, PCA9685Pin.PWM_04, "Pulse 04"), gpio.provisionPwmOutputPin((GpioProvider)gpioProvider, PCA9685Pin.PWM_05, "Pulse 05"), gpio.provisionPwmOutputPin((GpioProvider)gpioProvider, PCA9685Pin.PWM_06, "Pulse 06"), gpio.provisionPwmOutputPin((GpioProvider)gpioProvider, PCA9685Pin.PWM_07, "Pulse 07"), gpio.provisionPwmOutputPin((GpioProvider)gpioProvider, PCA9685Pin.PWM_08, "Pulse 08"), gpio.provisionPwmOutputPin((GpioProvider)gpioProvider, PCA9685Pin.PWM_09, "Pulse 09"), gpio.provisionPwmOutputPin((GpioProvider)gpioProvider, PCA9685Pin.PWM_10, "Always ON"), gpio.provisionPwmOutputPin((GpioProvider)gpioProvider, PCA9685Pin.PWM_11, "Always OFF"), gpio.provisionPwmOutputPin((GpioProvider)gpioProvider, PCA9685Pin.PWM_12, "Servo pulse MIN"), gpio.provisionPwmOutputPin((GpioProvider)gpioProvider, PCA9685Pin.PWM_13, "Servo pulse NEUTRAL"), gpio.provisionPwmOutputPin((GpioProvider)gpioProvider, PCA9685Pin.PWM_14, "Servo pulse MAX"), gpio.provisionPwmOutputPin((GpioProvider)gpioProvider, PCA9685Pin.PWM_15, "not used")};
        return myOutputs;
    }
}

